<?php $__env->startSection('title', 'Account Approval'); ?>
<?php $__env->startSection('content'); ?>
<?php $__env->startSection('style'); ?>
    <style>
        .page-wrapper {
            display: block !important;
        }

        .member_container {
            height: 500px;
            background-color: white;
        }
.container-fluid{
		padding:0 !important;
	}
    </style>
<?php $__env->stopSection(); ?>
<div class="container mt-5 member_container">
    <h1 class="heading_sub">Account Approvals</h1>
    

    <table id="payments-table" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th>Emoloyee ID</th>
                <th>Name</th>
                <th>Email</th>
                <th>Designation</th>
                <th>Contact</th>
                <th>Date Registered</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($user->employee_id); ?></td>
                    <td><?php echo e($user->name); ?></td>
                    <td><?php echo e($user->email); ?></td>
                    <td><?php echo e($user->designation); ?></td>
                    <td><?php echo e($user->contact); ?></td>
                    <td><?php echo e($user->created_at->format('d-m-Y')); ?></td>

                    <td>
                        <form action="<?php echo e(route('sub.account_approve', $user->id)); ?>" method="POST"
                            style="display: inline;">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PATCH'); ?>
                            <button type="submit" class="btn btn-success">Approve</button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function() {
        var dataTable = $('#payments-table').DataTable({
            "paging": true,
            "lengthChange": false,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": false,
        });

        // Event listener for package filter dropdown
        $('#package-filter').on('change', function() {
            var packageName = $(this).val();
            var status = $('#status-filter').val();
            updateDataTableFilters(packageName, status);
        });


        function updateDataTableFilters(packageName, status) {
            dataTable.column(2).search(packageName).draw(); // Filter by Package Name
            dataTable.column(6).search(status).draw(); // Filter by Payment Status
        }
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('sub-admin.layout.subadmin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/vhosts/upgstsa.com/app.upgstsa.com/resources/views/sub-admin/approvals.blade.php ENDPATH**/ ?>