<?php $__env->startSection('title', 'List'); ?>
<?php $__env->startSection('content'); ?>

<div class="container mt-5" style="font-size: 12px;">
    <h1 class="mb-4 heading_sub">User List</h1>
    <div class="filters mb-4">
        <div class="row">
            <div class="col-md-3">
                <div class="form_field">
                    
                    <select class="input select2 form-control" name="current_city" id="filter-city" style="width: 100%;">
                        <option value="">Current City</option> <!-- This empty option is necessary for the placeholder to work -->
                        <option value="Agra">Agra</option>
                        <option value="Aligarh">Aligarh</option>
                        <option value="Allahabad">Allahabad</option>
                        <option value="Ambedkar Nagar">Ambedkar Nagar</option>
                        <option value="Amethi">Amethi</option>
                        <option value="Amroha">Amroha</option>
                        <option value="Auraiya">Auraiya</option>
                        <option value="Azamgarh">Azamgarh</option>
                        <option value="Badaun">Badaun</option>
                        <option value="Bagpat">Bagpat</option>
                        <option value="Bahraich">Bahraich</option>
                        <option value="Ballia">Ballia</option>
                        <option value="Balrampur">Balrampur</option>
                        <option value="Banda">Banda</option>
                        <option value="Barabanki">Barabanki</option>
                        <option value="Bareilly">Bareilly</option>
                        <option value="Basti">Basti</option>
                        <option value="Bijnor">Bijnor</option>
                        <option value="Bulandshahr">Bulandshahr</option>
                        <option value="Chandauli">Chandauli</option>
                        <option value="Chitrakoot">Chitrakoot</option>
                        <option value="Deoria">Deoria</option>
                        <option value="Etah">Etah</option>
                        <option value="Etawah">Etawah</option>
                        <option value="Faizabad">Faizabad</option>
                        <option value="Farrukhabad">Farrukhabad</option>
                        <option value="Fatehpur">Fatehpur</option>
                        <option value="Firozabad">Firozabad</option>
                        <option value="Gautam Buddha Nagar">Gautam Buddha Nagar</option>
                        <option value="Ghaziabad">Ghaziabad</option>
                        <option value="Ghazipur">Ghazipur</option>
                        <option value="Gonda">Gonda</option>
                        <option value="Gorakhpur">Gorakhpur</option>
                        <option value="Hamirpur">Hamirpur</option>
                        <option value="Hapur">Hapur</option>
                        <option value="Hardoi">Hardoi</option>
                        <option value="Hathras">Hathras</option>
                        <option value="Jalaun">Jalaun</option>
                        <option value="Jaunpur">Jaunpur</option>
                        <option value="Jhansi">Jhansi</option>
                        <option value="Kannauj">Kannauj</option>
                        <option value="Kanpur Dehat">Kanpur Dehat</option>
                        <option value="Kanpur Nagar">Kanpur Nagar</option>
                        <option value="Kasganj">Kasganj</option>
                        <option value="Kaushambi">Kaushambi</option>
                        <option value="Kushinagar">Kushinagar</option>
                        <option value="Lakhimpur Kheri">Lakhimpur Kheri</option>
                        <option value="Lalitpur">Lalitpur</option>
                        <option value="Lucknow">Lucknow</option>
                        <option value="Maharajganj">Maharajganj</option>
                        <option value="Mahoba">Mahoba</option>
                        <option value="Mainpuri">Mainpuri</option>
                        <option value="Mathura">Mathura</option>
                        <option value="Mau">Mau</option>
                        <option value="Meerut">Meerut</option>
                        <option value="Mirzapur">Mirzapur</option>
                        <option value="Moradabad">Moradabad</option>
                        <option value="Muzaffarnagar">Muzaffarnagar</option>
                        <option value="Pilibhit">Pilibhit</option>
                        <option value="Pratapgarh">Pratapgarh</option>
                        <option value="Rae Bareli">Rae Bareli</option>
                        <option value="Rampur">Rampur</option>
                        <option value="Saharanpur">Saharanpur</option>
                        <option value="Sant Kabir Nagar">Sant Kabir Nagar</option>
                        <option value="Sant Ravidas Nagar">Sant Ravidas Nagar</option>
                        <option value="Sambhal">Sambhal</option>
                        <option value="Shahjahanpur">Shahjahanpur</option>
                        <option value="Shamli">Shamli</option>
                        <option value="Shravasti">Shravasti</option>
                        <option value="Siddharthnagar">Siddharthnagar</option>
                        <option value="Sitapur">Sitapur</option>
                        <option value="Sonbhadra">Sonbhadra</option>
                        <option value="Sultanpur">Sultanpur</option>
                        <option value="Unnao">Unnao</option>
                        <option value="Varanasi (Kashi)">Varanasi (Kashi)</option>
                    </select>
                    <?php $__errorArgs = ['current_city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="invalid-feedback" role="alert">
                            <strong><?php echo e($message); ?></strong>
                        </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>


            <div class="col-md-3">
                <div class="form_field">
                    
                    <select class="input form-control" id="filter-designation" name="designation" required autocomplete="contact" autofocus>
                        <option value="">Select your designation</option>
                        <option value="Assistant Commissioner">Assistant Commissioner</option>
                        <option value="Deputy Commissioner">Deputy Commissioner</option>
                        <option value="Joint Commissioner">Joint Commissioner</option>
                        <option value="Additional Commissioner - Grade II">Additional Commissioner - Grade II</option>
                        <option value="Additional Commissioner - Grade I">Additional Commissioner - Grade I</option>
                        <option value="Member Tribunal">Member Tribunal</option>
                    </select>
                    <?php $__errorArgs = ['designation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="invalid-feedback" role="alert">
                            <strong><?php echo e($message); ?></strong>
                        </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            <div class="col-md-3">
                <select id="filter-m-fee" class="form-control">
                    <option value="">Select M fee</option>
                    <option value="N/A">N/A</option>
                    <option value="Paid">Paid</option>
                    <option value="Pending Approval">Pending Approval</option>
                    <option value="Declined">Declined</option>
                </select>
            </div>
            <div class="col-md-3">
                <select id="filter-b-fee" class="form-control">
                    <option value="">Select B fee</option>
                    <option value="N/A">N/A</option>
                    <option value="Paid">Paid</option>
                    <option value="Pending Approval">Pending Approval</option>
                    <option value="Declined">Declined</option>
                </select>
            </div>
        </div>
    </div>
    <div class="table-responsive">
        <table class="table table-striped table-bordered" id="users-table">
            <thead>
                <tr>
                    <th>Employee ID</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Contact</th>
                    <th>Designation</th>
                    <th>Current Office</th>
                    <th>Posting Area</th>
                    <th>Home District</th>
                    <th>Date of Birth</th>
                    <th>Batch</th>
                    <th>M fee</th>
                    <th>B fee</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($user->employee_id); ?></td>
                        <td><?php echo e($user->name); ?></td>
                        <td><?php echo e($user->email); ?></td>
                        <td><?php echo e($user->contact ?? 'Not updated'); ?></td>
                        <td><?php echo e($user->designation); ?></td>
                        <td><?php echo e($user->current_office); ?></td>
                        <td><?php echo e($user->posting_area); ?></td>
                        <td><?php echo e($user->home_district); ?></td>
                        <td><?php echo e($user->date_of_birth); ?></td>
                        <td><?php echo e($user->batch); ?></td>
                        <td>
                            <?php if($user->annual_status == 0): ?>
                                N/A
                            <?php elseif($user->annual_status == 1): ?>
                                Paid
                            <?php elseif($user->annual_status == 2): ?>
                                Pending Approval
                            <?php elseif($user->annual_status == 3): ?>
                                Declined
                            <?php else: ?>
                                Unknown
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($user->b_fund_status == 0): ?>
                                N/A
                            <?php elseif($user->b_fund_status == 1): ?>
                                Paid
                            <?php elseif($user->b_fund_status == 2): ?>
                                Pending Approval
                            <?php elseif($user->b_fund_status == 3): ?>
                                Declined
                            <?php else: ?>
                                Unknown
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>

    <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.24/js/dataTables.bootstrap4.min.js"></script>
    <script>
        $(document).ready(function() {
            var table = $('#users-table').DataTable({
                "paging": true,
                "lengthChange": true,
                "searching": true,
                "ordering": true,
                "info": true,
                "autoWidth": false,
                "responsive": true,
                "columnDefs": [
                    { "className": "dt-center", "targets": "_all" }
                ],
                "order": [[0, "desc"]]
            });

            // Custom filtering function for city
            $('#filter-city').on('change', function() {
                table.column(5).search(this.value).draw();
            });

            // Custom filtering function for designation
            $('#filter-designation').on('change', function() {
                table.column(4).search(this.value).draw();
            });

            // Custom filtering function for M fee
            $('#filter-m-fee').on('change', function() {
                table.column(10).search(this.value).draw();
            });

            // Custom filtering function for B fee
            $('#filter-b-fee').on('change', function() {
                table.column(11).search(this.value).draw();
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('sub-admin.layout.subadmin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/vhosts/upgstsa.com/app.upgstsa.com/resources/views/sub-admin/list.blade.php ENDPATH**/ ?>