<!-- resources/views/emails/payment_success.blade.php -->
<?php if( $payment->payment_type === 'offline' ): ?>
<html>
    <body>
        <h1>Payment Successful</h1>
        <p>Dear <?php echo e($user->name); ?>,</p>
        <p>Your payment for the <?php echo e($payment->package_name); ?> package has been successfully processed.</p>
        <p>Payment Details:</p>
        <ul>
            <li>Receipt Number: <?php echo e($payment->main_receipt_id); ?></li>
            <li>Amount: ₹<?php echo e($payment->amount); ?></li>
            <li>Payment Type: <?php echo e($payment->payment_type); ?></li>
            <li>Payment Status: <?php echo e($payment->payment_status); ?></li>
        </ul>
        <p>Thank you for your subscription!</p>
    </body>
    </html>

<?php endif; ?>

<?php if($payment->payment_type === 'online'): ?>
<html>
    <body>
        <h1>Payment Successful</h1>
        <p>Dear <?php echo e($user->name); ?>,</p>
        <p>Your payment for the <?php echo e($payment->package_name); ?> package has been successfully processed.</p>
        <p>Payment Details:</p>
        <ul>
            <li>Receipt Number: <?php echo e($payment->main_receipt_id); ?></li>
            <li>Amount: ₹<?php echo e($payment->amount); ?></li>
            <li>Payment Type: <?php echo e($payment->payment_type); ?></li>
            <li>Razorpay id: <?php echo e($payment->razorpay_id); ?></li>
            <li>Payment Status: <?php echo e($payment->payment_status); ?></li>
        </ul>
        <p>Thank you for your subscription!</p>
    </body>
    </html>
<?php endif; ?>
<?php /**PATH /var/www/vhosts/upgstsa.com/app.upgstsa.com/resources/views/emails/payment_success.blade.php ENDPATH**/ ?>