<?php $__env->startSection('title', 'Payment Details'); ?>

<?php $__env->startSection('content'); ?>

    <!-- User Details -->
    <div class="row_new">
        <div class="proile_img">
            <img src="<?php echo e(asset('user/profile_photo/' . $payment->user->profile_photo)); ?>" alt="User Profile Picture"
                class="img-fluid rounded-circle" style="max-width: 150px;">
        </div>
        <div class="user_info">
            <h2><?php echo e($payment->user->name); ?></h2>
            <p><strong>Email:</strong> <?php echo e($payment->user->email); ?></p>
            <p><strong>Designation:</strong> <?php echo e($payment->user->designation); ?></p>
            <!-- Add any other user details you want to display -->
        </div>
    </div>

    <!-- Payment Details -->
    <h1>Payment Details</h1>

    <div>
        <?php if($payment->payment_type === 'offline'): ?>
        <br>
        <strong>Receipt:</strong>
        <?php if(empty($payment->receipt_document)): ?>
            <?php echo e('null'); ?>

        <?php elseif(pathinfo($payment->receipt_document, PATHINFO_EXTENSION) === 'pdf'): ?>
            <a href="<?php echo e(asset($payment->receipt_document)); ?>" target="_blank" class="btn btn-primary">View Document</a>
        <?php else: ?>
            <a href="<?php echo e(asset($payment->receipt_document)); ?>" target="_blank">
                <img src="<?php echo e(asset($payment->receipt_document)); ?>" alt="Receipt Document" style="max-width: 150px;">
            </a>
        <?php endif; ?>
        <br>
    <?php endif; ?>
		<strong>Employee ID:</strong> <?php echo e($payment->user->employee_id); ?> <br>
        <strong>ID:</strong> <?php echo e($payment->id); ?> <br>
        <strong>User Name:</strong> <?php echo e($payment->user->name); ?> <br>
        <strong>Package Name:</strong> <?php echo e($payment->package_name); ?> <br>
        <strong>Payment Type:</strong> <?php echo e($payment->payment_type); ?> <br>
     <?php if($payment->payment_type === 'offline'): ?>
    <?php if($payment->package_name === 'Annual Subscription'): ?>
        <strong>Receipt Number:</strong> <?php echo e($payment->receipt_number); ?> <br>
    <?php else: ?>
        <strong>Cheque Number:</strong> <?php echo e($payment->cheque_number); ?> <br>
        <strong>Receipt Document:</strong> <?php echo e($payment->receipt_document); ?> <br>
    <?php endif; ?>
<?php endif; ?>


        <?php if($payment->payment_type === 'online'): ?>
            <strong>Razorpay ID:</strong> <?php echo e($payment->razorpay_id); ?> <br>
        <?php endif; ?>
        <strong>Payment Status:</strong> <?php echo e($payment->payment_status); ?> <br>
        <strong>Amount:</strong> <?php echo e($payment->amount); ?> <br>
        <strong>Date:</strong> <?php echo e($payment->created_at); ?> <br>
        <!-- Add any other payment details you want to display -->
    </div>
    <?php if($payment->payment_status === 'pending approval'): ?>
        <!-- Approve and Disapprove Buttons -->

        <br>


        <form action="<?php echo e(route('admin.payments.approve', $payment->id)); ?>" method="POST" style="display: inline;">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PATCH'); ?>
            <button type="submit" class="btn btn-success">Approve</button>
        </form>

        <form action="<?php echo e(route('admin.payments.disapprove', $payment->id)); ?>" method="POST" style="display: inline;">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PATCH'); ?>
            <button type="submit" class="btn btn-danger">Disapprove</button>
        </form>
    <?php endif; ?>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/vhosts/upgstsa.com/app.upgstsa.com/resources/views/admin/payment_show.blade.php ENDPATH**/ ?>