<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reset Password</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            font-family: arial;
        }
		.main-section{
			    margin: 50px auto;
		}
        .input-item {
            cursor: pointer;
            margin-top: 20px;
            display: flex;
            align-items: flex-start;
        }

        .input-item a {
            text-decoration: none;
            color: #5E55BA;
        }

        .input-item label {
            font-size: 14px;
            cursor: pointer;
            margin: 0;
        }

        .acount-text {
            font-size: 16px;
            margin: 20px 0px 0px 0px;
            color: #595959
        }

        .acount-text a {
            text-decoration: none;
            color: #5E55BA;
            font-weight: 600;
        }

        /*  */
        .form_title {
            font-size: 24px;
            color: #393a4f;
            font-weight: 300;
            text-align: left;

        }

        .align-center {
            align-items: center;
        }

        .form_subtitle {
            text-align: left;
            font-family: "Roboto", sans-serif;
            font-size: 14px;
            color: #a2a5b9;
            margin-bottom: 16px;
        }



        .form_field input {
            width: 100%;
        }

        .form_field input {
            font-size: 15px;
            height: 36px;
            border-radius: 5px;
            transition: all .3s;
            outline-color: red;
            padding: 5px 5px
        }

        .form_field label {
            font-size: 15px;
            color: #393a4f;
            margin: 0;
            font-weight: 600;
        }



        .login-img img {
            width: 100%;
        }



        .logo-img img {
            width: 100%;
        }

        .logo-img {
            width: 100px;
            margin: 0 auto;
        }

        .logo-img img {
                width: 100%;
    max-width: 100px;
    position: absolute;
    top: 0;
       left: 50%;
    transform: translate(-50%, 0);
        }

        .input-item ul {
            display: flex;
            justify-content: space-between;
            width: 100%;
            list-style: none;
            margin: 0;
        }

        /*  */
        .input-email {
            width: 100%;
        }

        .sent-btn {
            width: 170px;
            height: 48px;
            background: #5645fe;
            display: block;
            color: #fff !important;
            padding: 10px;
            text-align: center;
            border-radius: 5px;
            border: solid 2px #4335d2;
            filter: drop-shadow(0px 2px 1px #4335d2);
            transition: 0.5s;
        }

        .sent-btn:hover {
            background-color: #eaeaea;
            filter: unset;
            border: solid 2px #000;
            color: #000 !important;
        }

        .alert_notificatio {
            color: #00b975;
            background: #cdffed;
            padding: 15px;
            margin-bottom: 10px;
        }

        .alert_notificatio h3 {
            font-size: 18px;
            margin: 0;
            font-weight: 600;
        }

        /*  */
        @media screen and (max-width:992px) {
            .alert_notificatio h3 {
                font-size: 14px;
            }
        }

        /* 520 start */
        @media screen and (max-width:520px) {


           

            /*  */
            .title_form {
                font-size: 16px;
            }

            /*  */
            .form_subtitle,
            .form_title {
                text-align: center;
            }

            .sent-btn {
                width: 130px;
                height: 40px;
                font-size: 13px;
                font-weight: 600;
            }

        }

        /* 520 end */
        /* 480 start */
        @media screen and (max-width:480px) {
			 .login-img img {
                display: none;

            }

            .logo-img img {
                display: block !important;
                width: 100%;
               max-width: 100px;
               position: unset;
              top: 0;
              left: 0;
              margin-bottom: 50px;
			  transform: unset;
            }
            .alert_notificatio h3 {
                font-size: 12px;
            }
        }

        /* 480 end */
        /*  */
		
		   .alert_notification {
            display: none;
			color: #fffffe;
            background: #e24848;
            padding: 15px;
            margin-bottom: 10px;
        }
		 .alert_notificatio {
            color: white;
            background: #22c842;
            padding: 15px;
            margin-bottom: 10px;
        }
    </style>
</head>

<body>

    <div class="container main-section">

        <div class="row align-center">
            <div class="col-md-6">
                <div class="login-img">
                    <img src="https://i.ibb.co/BTqZW9N/login-img.jpg" alt="login-img">
                    <div class="logo-img">
                       <img src="/logo-upgst.png" alt="logor">
                    </div>
                </div>
            </div>
                        
            <div class="col-md-6 form-sec">
				<div class="alert_notification">
    <h3>No email found associated with this ID.</h3>
</div>
				 <?php if(session('success')): ?>
                        <div class="alert_notificatio">
                            <h3>
                                Password reset link sent to your email. </h3>
                        </div>
                    <?php endif; ?>
                <div class="form-aria">

                    <h2 class="form_title">Reset password </h2>
                    <h3 class="form_subtitle">If you forgot your password, well, then we'll email you instructions to
                        reset your password.</h3>
                  <!-- <div class="alert_notificatio">
                        <h3>
                            We have e-mailed your password reset link!
                        </h3>
                    </div> -->
                    <div class="form-name">
                        <!--  -->
                       <div class="form_field input-email">
   						 <label>User ID</label>
    					<input type="text" class="input-email" placeholder="Enter user id">
						</div>
                    </div>
					
					

						
					
					 <form method="POST" action="<?php echo e(route('password.email')); ?>">
                        <?php echo csrf_field(); ?>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <input id="email" type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="email" value="<?php echo e(old('email')); ?>" required autocomplete="email" autofocus>

                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                    <div class="input-item">
                        <ul class="align-items-center">
                            <li>
                                <button  type="submit" class="sent-btn" >Send Reset Link</button>
                            </li>
							</form>
                            <li>
                                <a href="<?php echo e(route('login')); ?>">Return to login</a>
                            </li>
                        </ul>

                    </div>

                </div>
            </div>
        </div>
        </section>
        <!--  -->

        <!-- ======== script satrt========= -->
        <script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.slim.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
        <!-- ======== script satrt========= -->
	
	<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function() {
            $('.input-email').on('focusout', function() {
                var userId = $(this).val();
                if (userId) {
                    $.ajax({
                        url: '<?php echo e(route("getEmailByUserId")); ?>',
                        type: 'GET',
                        data: { employee_id: userId },
                        success: function(response) {
                            if (response.email) {
                                $('#email').val(response.email).parent().show();
                                $('.sent-btn').show(); // Show the send button
                            }
                        },
                        error: function() {
                            $('#email').val('').parent().hide();
                            $('.sent-btn').hide(); // Hide the send button
                    $('.alert_notification').show(); // Show the error message
                        }
                    });
                } else {
                    $('#email').parent().hide();
                    $('.sent-btn').hide(); // Hide the send button
					                    $('.alert_notification').hide(); // Show the error message

                }
            });

            // Hide the email field and send button initially
            $('#email').parent().hide();
            $('.sent-btn').hide();
        });
</script>

</body>

</html>
<?php /**PATH /var/www/vhosts/upgstsa.com/app.upgstsa.com/resources/views/auth/passwords/email.blade.php ENDPATH**/ ?>