<?php $__env->startSection('title', 'Payments Report'); ?>
<?php $__env->startSection('content'); ?>
<style>
    .page-wrapper {
        display: block !important;
    }
</style>
<div class="container mt-5">
    <h1 class="heading_sub">Payments Report</h1>
    <div class="mb-3">
        <label for="package-filter" class="form-label">Filter by Package:</label>
        <select class="form-select" id="package-filter">
            <option value="">All</option>
            <option value="annual">Annual</option>
            <option value="benevolent">Benevolent</option>
        </select>
    </div>
    <div class="mb-3">
        <label for="status-filter" class="form-label">Filter by Payment Status:</label>
        <select class="form-select" id="status-filter">
            <option value="">All</option>
            <option value="success">Success</option>
            <option value="failed">Failed</option>
            <option value="pending">Pending Approval</option>
        </select>
    </div>
    <table id="payments-table" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th>ID</th>
                <th>User Name</th>
                <th>Package Name</th>
                <th>Payment Type</th>
                <th>Receipt Number</th>
                <th>Receipt Document</th>
                <th>Payment Status</th>
                <th>Amount</th>
                <th>Date</th>
                
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($payment->id); ?></td>
                <td><?php echo e($payment->user->name); ?></td>
                <td><?php echo e($payment->package_name); ?></td>
                <td><?php echo e($payment->payment_type); ?></td>
                <td><?php echo e($payment->main_receipt_id); ?></td>
                <td>
                    <?php if(empty($payment->receipt_document)): ?>
                    <?php echo e('N/A'); ?>

                    <?php elseif(pathinfo($payment->receipt_document, PATHINFO_EXTENSION) === 'pdf'): ?>
                    <a href="<?php echo e(asset($payment->receipt_document)); ?>" target="_blank">View Document</a>
                    <?php else: ?>
                    <img src="<?php echo e(asset($payment->receipt_document)); ?>" alt="Receipt Document" style="max-width: 100px;">
                    <?php endif; ?>
                </td>
                <td><?php echo e($payment->payment_status); ?></td>
                <td><?php echo e($payment->amount); ?></td>
                <td><?php echo e($payment->created_at); ?></td>
                
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.24/js/dataTables.bootstrap4.min.js"></script>
<script>
    $(document).ready(function () {
        var dataTable = $('#payments-table').DataTable({
            "paging": true,
            "lengthChange": false,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": false,
        });

        // Event listener for package filter dropdown
        $('#package-filter').on('change', function () {
            var packageName = $(this).val();
            var status = $('#status-filter').val();
            updateDataTableFilters(packageName, status);
        });

        // Event listener for status filter dropdown
        $('#status-filter').on('change', function () {
            var packageName = $('#package-filter').val();
            var status = $(this).val();
            updateDataTableFilters(packageName, status);
        });

        function updateDataTableFilters(packageName, status) {
            dataTable.column(2).search(packageName).draw(); // Filter by Package Name
            dataTable.column(6).search(status).draw(); // Filter by Payment Status
        }
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('sub-admin.layout.subadmin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/vhosts/upgstsa.com/app.upgstsa.com/resources/views/sub-admin/payments_history.blade.php ENDPATH**/ ?>