<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo $__env->yieldContent('title'); ?></title>


    <!-- jQuery is only used for hide(), show() and slideDown(). All other features use vanilla JS -->
    <script src="https://code.jquery.com/jquery-3.3.1.min.js"
        integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="https://fonts.gstatic.com">

    <link href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet"
        integrity="sha384-wvfXpqpZZVQGK6TAh5PVlGOfQNHSoD2xbE+QkPxCAFlNEevoEH3Sl0sibVcOQVnN" crossorigin="anonymous">

    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Nunito" crossorigin="anonymous">

    <!-- Styles -->
    
    <link href="<?php echo e(asset('binshopsblog_admin_css.css')); ?>" rel="stylesheet">
    
    
    
    
    
    


</head>
<style>

    html,
    body {
        height: 100%;
        margin: 0;
    }

    body {
        background-color: #8583834d;
        color: #636b6f;
        font-family: 'Nunito', sans-serif;
        font-weight: 200;

    }

    .page-wrapper {
        width: 98%;
        margin-left: 1%;

    }

    #app {
        width: 100%;
    }

    .container {
        max-width: 1482px;
        margin-left: 2px;
    }

    .dataTables_length {
        display: none;
    }

    .banner_img {
        background-image: url('<?php echo e(Auth::user()->cover_image ? asset('user/cover_image/' . Auth::user()->cover_image) : asset('default-cover.jpg')); ?>');
        height: 130px;
        background-size: cover;
        background-position: center;
    }
	.full-width-div{
	    position: unset !important;
    width: 104% !important;

    margin-left: -32px !important;
	}
	.list-group-color{
	    background: linear-gradient(178.1deg, rgb(60, 55, 106) 8.5%, rgb(23, 20, 69) 82.4%); !important}

	.modal-box {
  width: 100%;
  max-width: 500px;
  margin: 100px auto;
}

/* Custom Multi Select */
.sd-multiSelect {
  position: relative;
}
.sd-multiSelect .placeholder {
  opacity: 1;
  background-color: transparent;
  cursor: pointer;
}
.sd-multiSelect .ms-offscreen {
  height: 1px;
  width: 1px;
  opacity: 0;
  overflow: hidden;
  display: none;
}

.sd-multiSelect .sd-CustomSelect {
  width: 100% !important;
}

.sd-multiSelect .ms-choice {
  position: relative;
  text-align: left !important;
  width: 100%;
  border: 1px solid #e3e3e3;
  background: #ffff;
  box-shadow: none;
  font-size: 15px;
  height: 44px;
  font-weight: 500;
  color: #212529;
  line-height: 1.5;
  -webkit-appearance: none;
  -moz-appearance: none;
  appearance: none;
  border-radius: 0.25rem;
  transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
}

.sd-multiSelect .ms-choice:after {
  content: "\f107 ";
  font-family: "FontAwesome";
  position: absolute;
  right: 10px;
  top: 50%;
  transform: translateY(-50%);
  font-size: 18px;
}

.sd-multiSelect .ms-choice:focus {
  border-color: var(--theme-color);
}

.sd-multiSelect .ms-drop.bottom {
  display: none;
  background: #fff;
  border: 1px solid #e5e5e5;
  padding: 10px;
}

.sd-multiSelect .ms-drop li {
  position: relative;
  margin-bottom: 10px;
}

.sd-multiSelect .ms-drop li input[type="checkbox"] {
  padding: 0;
  height: initial;
  width: initial;
  margin-bottom: 0;
  display: none;
  cursor: pointer;
}

.sd-multiSelect .ms-drop li label {
  cursor: pointer;
  user-select: none;
  -ms-user-select: none;
  -moz-user-select: none;
  -webkit-user-select: none;
}

.sd-multiSelect .ms-drop li label:before {
  content: "";
  -webkit-appearance: none;
  background-color: transparent;
  border: 2px solid var(--theme-color);
  box-shadow: 0 1px 2px rgba(0, 0, 0, 0.05),
    inset 0px -15px 10px -12px rgba(0, 0, 0, 0.05);
  padding: 8px;
  display: inline-block;
  position: relative;
  vertical-align: middle;
  cursor: pointer;
  margin-right: 5px;
}

.sd-multiSelect .ms-drop li input:checked + span:after {
  content: "";
  display: block;
  position: absolute;
  top: 9px;
  left: 5px;
  width: 10px;
  height: 10px;
  background: var(--theme-color);
  border-width: 0 2px 2px 0;
}
.ms-drop bottom{
	background-color:red;
}
	<?php echo $__env->yieldContent('css'); ?>
</style>


<body>
    <div class="banner_img">
    </div>
    <div class="page-wrapper">
        <?php if(session('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="alert alert-danger">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>

        <?php echo $__env->make('user.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="container">
            <div class="content">
                <div id="app">


                    <main class="py-4">
                        <div class="container">
                            <div class='row full-width-div nav-bar-full'>
                                <div class='list-group-color'>
                                    <?php echo $__env->make('binshopsblog_admin::layouts.admin_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                </div>
                                <div class='col-md-9 main-content'>

                                    <?php if(isset($errors) && count($errors)): ?>
                                        <div class="alert alert-danger">
                                            <b>Sorry, but there was an error:</b>
                                            <ul class='m-0'>
                                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li><?php echo e($error); ?></li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        </div>
                                    <?php endif; ?>


                                    

                                    <?php if(\BinshopsBlog\Helpers::has_flashed_message()): ?>
                                        <div class='alert alert-info'>
                                            <h3><?php echo e(\BinshopsBlog\Helpers::pull_flashed_message()); ?></h3>
                                        </div>
                                    <?php endif; ?>

                                    <?php echo $__env->yieldContent('content'); ?>
                                </div>
                            </div>
                        </div>
                    </main>
                </div>
            </div>
        </div>
    </div>



</body>

</html>
<?php /**PATH C:\xampp\htdocs\upvkss\vendor\binshops\laravel-blog\src/Views/binshopsblog_admin/layouts/admin_layout.blade.php ENDPATH**/ ?>