<!-- resources/views/layouts/user_layout.blade.php -->

<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo $__env->yieldContent('title'); ?></title>

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Nunito:200,600" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>

    <!-- Styles -->
    
    <?php echo $__env->yieldContent('css'); ?>
    <link href="https://fonts.bunny.net/css?family=Nunito" rel="stylesheet">
    <?php echo app('Illuminate\Foundation\Vite')(['resources/sass/app.scss', 'resources/js/app.js']); ?>

</head>
<style>
    html,
    body {
        height: 100%;
        margin: 0;
    }

    body {
        background-color: #8583834d;
        color: #636b6f;
        font-family: 'Nunito', sans-serif;
        font-weight: 200;

    }

    .page-wrapper {
        width: 98%;
        margin-left: 1%;

    }

    #app {
        width: 100%;
    }

    .container {
        max-width: 1482px;
        margin-left: 2px;
    }

    .dataTables_length {
        display: none;
    }
</style>

<body>

    
    <?php echo $__env->yieldContent('banner_image'); ?>


    <div class="page-wrapper">
        <?php if(session('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="alert alert-danger">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>
        <?php echo $__env->yieldContent('banner_views'); ?>
        <?php echo $__env->make('user.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->yieldContent('info'); ?>
        <div class="container">
            <div class="content">
                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </div>
    </div>
    <!-- Bootstrap Modal -->
    <form action="<?php echo e(route('upload.image_cover')); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="modal fade" id="uploadCImageModal" tabindex="-1" aria-labelledby="uploadCImageModalLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="uploadImageModalLabel">Change Cover Image</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <input type="file" name="image" class="form-control">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary cancel" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Upload</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
</body>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js"></script> <!-- Add popper.js -->
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js"></script> <!-- Add Bootstrap JS -->
<?php echo $__env->yieldContent('script'); ?>

</html>
<?php /**PATH C:\xampp\htdocs\upvkss\resources\views/user/layout/app.blade.php ENDPATH**/ ?>