<?php $__env->startSection('title', 'Annual Membership fees'); ?>

<?php $__env->startSection('content'); ?>
    <style>
        .data_text p {
            font-size: 1.5vw;
            font-weight: 600;
        }

        .employee-text {
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            list-style: none;
            margin: 0;
            background: #fff;
            border: 1px solid #e0e0e0;
            padding: 8px;
            border-radius: 3px;
            filter: drop-shadow(0px 1px 1px #e0e0e0);
        }

        .employee-text li {
            font-size: 1.5vw;
            width: 48%;
            font-weight: 600;
            margin-bottom: 10px;
        }

        .employee-text li:nth-child(1) {
            border-right: solid 1px #727272;
        }

        .employee-text li:nth-child(3) {
            border-right: solid 1px #727272;
        }

        .employee-text li:nth-child(5) {
            border-right: solid 1px #727272;
        }

        .data_text span {
            font-weight: 700;
        }

        .employee-text li a {
            text-decoration: none;
            color: #000;
        }

        .shiping-sec {
            padding: 20px;
            border: 1px solid #e0e0e0;
            border-radius: 5px;
            filter: drop-shadow(0px 1px 1px #e0e0e0);
            display: flex;
            flex-direction: column;
            justify-content: center;
            text-align: center;
            height: 180px;

        }

        .shiping-sec i {
            width: 50px;
            height: 50px;
            background: #fff;
            border-radius: 100%;
            box-shadow: 0px 0px 1px 1px #6b6464;
            text-align: center;
            line-height: 50px;
            color: #02315a;
            margin: 0 auto;
        }

        .shiping-sec p {
            font-size: 20px;
            font-weight: 600;
        }

        .subtotal-sec {
            margin-top: 40px;
            padding: 20px;
            border: 1px solid #e0e0e0;
            border-radius: 5px;
            filter: drop-shadow(0px 1px 1px #e0e0e0);
            display: flex;
            flex-direction: column;
            justify-content: center;
            text-align: center;
        }

        .order-line {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 12px;
        }

        .sub-text {
            font-size: 18px;
            font-weight: 600;
            color: #999;
        }

        .price-text {
            font-size: 18px;
            font-weight: 600;
            color: #000000;
        }

        .continue_btn {
            width: 100%;
            font-size: 18px;
            font-weight: 600;
            text-decoration: none;
            color: #fff;
            background: #00315b;
            padding: 7px;
            display: block;
            text-align: center;
            border-radius: 5px;
            border: solid 2px #00315d;
            text-decoration: none;
        }

        .continue_btn:hover {
            width: 100%;
            background: #e2e2e2;
            transition: 0.5s;
            filter: unset;
            color: #00315b;
            text-decoration: none;
        }

        .form-main {
            display: flex;
            flex-direction: column;
        }

        .Receipt_form {
            width: 48%;
        }

        .Receipt_form input {
            width: 100%;
            height: 38px;
            font-size: 18px;
            outline-color: #347ab654;
            border-radius: 4px;
            padding: 8px;
        }

        .quantity-text {
            font-weight: 600;
            font-size: 15px;
            margin-bottom: 5px;
        }

        .Receipt-form {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .upload_btn {
            padding: 40px;
            width: 100%;
            border: 1px solid #e8e8e8;
            border-radius: 4px;
            background: #fff;
            display: flex;
            justify-content: center;
            align-items: center;
            cursor: pointer;
            transition: all .3s;
            margin-top: 30px;
            filter: drop-shadow(1px 1px 2px #dddddd)
        }

        .box-text {
            display: flex;
            flex-direction: column;
            text-align: center;
        }

        .box-text span {
            font-size: 20px;
        }

        .upload-text {
            font-weight: 600;
        }

        /* 992 start */
        @media screen and (max-width:992px) {
            .member_head {
                font-size: 20px;
            }

            .shiping-sec p {
                font-size: 16px;
            }
        }

        /* 992 end */
        /* 768 start */
        @media screen and (max-width:768px) {
            .upload_btn {
                margin-bottom: 30px;
            }


        }

        /* 768 end */
        /* 575 start */
        @media screen and (max-width:575px) {
            .Receipt-form {
                flex-direction: column;
            }

            .Receipt_form {
                width: 100%;
                margin-bottom: 20px;
            }

            .upload_btn {
                margin-top: 10px;
            }
        }

        .profile_img img {
            max-width: 150px;
        }

        .card-body h3,
        .card-body h4 {
            font-weight: bold;
        }

        .details-card .card-body div {
            margin-bottom: 1rem;
        }

        .details-card .card-body strong {
            display: inline-block;
            min-width: 150px;
        }

        .actions {
            text-align: center;
        }

        .actions .btn {
            margin: 0 0.5rem;
        }

        .row-equal-height {
            display: flex;
            flex-wrap: wrap;
        }

        .row-equal-height .col-md-4,
        .row-equal-height .col-md-8 {
            display: flex;
            align-items: stretch;
        }

        .row-equal-height .card {
            flex: 1;
        }
        .c_button_css{
            width: 306px !important;
        }
    </style>
    <?php use Carbon\Carbon;
    ?>
    <?php if($payments && $payments->receipt_number): ?>
        <h2>Membership Fees </h2>
        <br>
        <div class="container container_rule">
            <div class="row">
                <div class="col-lg-8">
                    <div class="Receipt-form">
                        <div class="Receipt_form">
                           <label class="quantity-text" for="fname">Receipt Number :</label>
                                <input class="name-text" type="text" placeholder="<?php echo e($payments->receipt_number); ?>"
                                    name="cheque_number" disabled>
                        </div>
                        <div class="Receipt_form">
                            <label class="quantity-text" for="fname">Receipt Date :</label>
                            <input class="name-text" type="text" placeholder="Cheque Date" name="doc_date" disabled
                                value="<?php echo e(Carbon::parse($payments->created_at)->format('d-m-Y')); ?>">
                        </div>
                    </div>
                    <div class="selection-box modal-trigger upload_btn">
                        <div class="box-content">

                            <?php if(empty($payments->receipt_document)): ?>
                            <h2>N/A</h2>
                            <?php elseif(pathinfo($payments->receipt_document, PATHINFO_EXTENSION) === 'pdf'): ?>
                                <a href="<?php echo e(asset($payments->receipt_document)); ?>" target="_blank">View Document</a>
                            <?php else: ?>
                                <img src="<?php echo e(asset($payments->receipt_document)); ?>" alt="Receipt Document"
                                    style="max-width: 455px;">
                            <?php endif; ?>
                            <br>


                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="shiping-sec">
                        <a href="#"> <i class="fa fa-handshake-o"></i></a>
                        <h4>Membership Fees</h4>
                    </div>
                    <div class="subtotal-sec">

                        <div class="order-line">
                            <span class="sub-text">Amount</span>
                            <span class="price-text">₹ 2000.00</span>
                        </div>
                        <div class="order-line">
                            <span class="sub-text">Late Fees</span>
                            <span class="price-text">₹ 0.00</span>
                        </div>

                        <div class="order-line">
                            <span class="sub-text">Total</span>
                            <span class="price-text">₹ 2000.00</span>
                        </div>
                        <?php if($payments->payment_status === 'success'): ?>
                            <div class="order-line">
                                <form action="<?php echo e(route('sub.receipt')); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <input type="text" name="employee_id" value="<?php echo e($payments->user->employee_id); ?>" hidden>
                                    <button class="continue_btn c_button_css" type="submit">View Receipt</button>
                                </form>
                            </div>
                        <?php else: ?>
                            <div class="order-line">
                                <button class="continue_btn" type="submit">Confirm</button>
                            </div>
                        <?php endif; ?>


                    </div>
                </div>
            </div>
        </div>

    <?php endif; ?>

    <?php if(!$payments): ?>
        <h2>User Details </h2>
        <div class="container mt-5">
            <!-- User Details -->
            <div class="row-equal-height mb-4">
                <div class="col-md-4 text-center">
                    <div class="card">
                        <div class="card-body">
                            <div class="profile_img mb-3">
                                <?php if($user->profile_photo): ?>
                                    <img src="<?php echo e(asset('user/profile_photo/' . $user->profile_photo)); ?>"
                                        class="img-fluid rounded-circle">
                                <?php else: ?>
                                    <img src="<?php echo e(asset('user/default_pic.jpg')); ?>" class="img-fluid rounded-circle">
                                <?php endif; ?>
                            </div>
                            <h3><?php echo e($user->name); ?></h3>
                            <p><strong>Email:</strong> <?php echo e($user->email); ?></p>
                            <p><strong>Designation:</strong> <?php echo e($user->designation); ?></p>
                        </div>
                    </div>
                </div>
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-body">
                            <h4>User Information</h4>
                            <p><strong>Employee ID:</strong> <?php echo e($user->employee_id); ?></p>
                            <p><strong>Name:</strong> <?php echo e($user->name); ?></p>
                            <p><strong>Gender:</strong> <?php echo e($user->gender); ?></p>
                            <p><strong>Date of birth:</strong> <?php echo e($user->date_of_birth); ?></p>
                            <br>
                            <form action="<?php echo e(route('submitOfflineSubscriptionsub_bfund')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="employee_id" value="<?php echo e($user->employee_id); ?>">
                                <!-- Submit button -->
                                <button type="submit" class="btn btn-success">Confirm Payment</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    <?php endif; ?>

    <?php if($payments && empty($payments->receipt_number)): ?>
    <div class="container mt-5">
        <!-- User Details -->
        <div class="row-equal-height mb-4">
            <div class="col-md-4 text-center">
                <div class="card">
                    <div class="card-body">
                        <div class="profile_img mb-3">
                            <?php if($payments->user->profile_photo): ?>
                                <img src="<?php echo e(asset('user/profile_photo/' . $payments->user->profile_photo)); ?>" class="img-fluid rounded-circle">
                            <?php else: ?>
                                <img src="<?php echo e(asset('user/default_pic.jpg')); ?>" class="img-fluid rounded-circle">
                            <?php endif; ?>
                        </div>
                        <h3><?php echo e($payments->user->name); ?></h3>
                        <p><strong>Email:</strong> <?php echo e($payments->user->email); ?></p>
                        <p><strong>Designation:</strong> <?php echo e($payments->user->designation); ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-8">
                <div class="card">
                    <div class="card-body">
                        <h4>User Information</h4>
                        <p><strong>Employee ID:</strong> <?php echo e($payments->user->employee_id); ?></p>
                        <p><strong>User Name:</strong> <?php echo e($payments->user->name); ?></p>
                        <div class="order-line">
                            <form action="<?php echo e(route('sub.receiptbfund')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <input type="text" name="employee_id" value="<?php echo e($payments->user->employee_id); ?>" hidden>
                                <button type="submit" class="btn btn-success">view receipt</button>
                            </form>
                        </div>
                        <!-- Add any other user details you want to display -->
                    </div>
                </div>
            </div>
        </div>

        <!-- Payment Details -->
        <h1 class="mb-4">Payment Details</h1>

        <div class="card details-card mb-4">
            <div class="card-body">
                <div><strong>ID:</strong> <?php echo e($payments->id); ?></div>
                <div><strong>Package Name:</strong> <?php echo e($payments->package_name); ?></div>
                <div><strong>Payment Type:</strong> <?php echo e($payments->payment_type); ?></div>
                <div><strong>Payment Status:</strong> <?php echo e($payments->payment_status); ?></div>
                <div><strong>Amount:</strong> <?php echo e($payments->amount); ?></div>
                <div><strong>Date:</strong> <?php echo e($payments->created_at); ?></div>

            </div>
        </div>


    </div>
    <?php endif; ?>
    <br>
    </form>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('sub-admin.layout.subadmin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/vhosts/upgstsa.com/app.upgstsa.com/resources/views/sub-admin/benevolentfund_b.blade.php ENDPATH**/ ?>