    <style>
        a {
            --hover-color: #010002;
            --accent-color: #ffc107;
            --underline-thickness: 3px;
            color-scheme: light;
        }

        .container_header {
            width: 100%;
            height: 150px;
            background-color: white;

        }

        .image-container {
            position: relative;
            display: inline-block;
            float: left;
        }

        .image--cover {
            width: 200px;
            height: 200px;
            border-radius: 50%;
            object-fit: cover;
            object-position: center right;
            margin-top: -125px;
            border: 3px solid white;
            margin-left: 25px;
        }

        .user_detail {
            float: left;
            font-size: medium;
            padding-left: 40px;
            font-family: sans-serif;
        }


        .edit-text {
            position: absolute;
            bottom: 32px;
            left: 60px;
            color: rgb(19, 19, 19);
            font-size: 20px;
            font-weight: bold;
            display: none;
        }

        .image-container:hover .edit-text {
            display: block;
        }

        .image-container:hover .image--cover {
            filter: blur(5px);
        }



        .wrapper {
            height: 70%;
            font-size: 30px;
            font-weight: bold;
            color: black;
            background-color: white;
            padding-top: 5px;
        }

        .user_head {
            height: 70%;
        }

        .edit_btn {
            float: right;
            margin-right: 30px;
            font-size: 22px;
            margin-top: 10px;
        }

        .nav_main {
            padding-left: 100px;

            border: 1px solid;
            height: 45px;
            align-items: center;
            display: flex;
background: linear-gradient(178.1deg, rgb(60, 55, 106) 8.5%, rgb(23, 20, 69) 82.4%);    color: white;
        }

        .nav_main nav {
            margin: 0;
            padding: 0;
            display: flex;
            text-transform: uppercase;
            font: bold 1.5rem sans-serif;
            height: 30%;
            display: flex;
            align-items: center;


            & a {
                font-size: 15px;

                color: var(--text-color);
                cursor: pointer;
                overflow: hidden;
                transition: 0.3s;
                position: relative;
                text-decoration: none;
                padding: 0 0.5em 0.25em;

                &::before {
                    content: "";
                    scale: 0 1;
                    position: absolute;
                    background: var(--accent-color);
                    transition: 0.3s, translate 0s 0.3s;
                    inset: calc(100% - var(--underline-thickness)) 0 0 0;
                }

                &:hover {
                    color: var(--hover-color);

                    &::before {
                        translate: 0;
                        transition: 0.3s;
                    }
                }
            }

            &:hover {
                & a::before {
                    scale: 1;
                }

                & a:has(~ a:hover)::before {
                    translate: 100% 0;
                    transition: 0.2s 0.2s, scale 0s 0.4s;
                }

                & a:hover~a::before {
                    translate: -100% 0;
                    transition: 0.2s 0.2s, scale 0s 0.4s;
                }
            }
        }

        /* The design is inspired from the mockapi.io */

        .popup {
            --burger-line-width: 1.125em;
            --burger-line-height: 0.125em;
            --burger-offset: 0.625em;
            --burger-bg: rgba(0, 0, 0, .15);
            --burger-color: #333;
            --burger-line-border-radius: 0.1875em;
            --burger-diameter: 2.125em;
            --burger-btn-border-radius: calc(var(--burger-diameter) / 2);
            --burger-line-transition: .3s;
            --burger-transition: all .1s ease-in-out;
            --burger-hover-scale: 1.1;
            --burger-active-scale: .95;
            --burger-enable-outline-color: var(--burger-bg);
            --burger-enable-outline-width: 0.125em;
            --burger-enable-outline-offset: var(--burger-enable-outline-width);
            /* nav */
            --nav-padding-x: 0.25em;
            --nav-padding-y: 0.625em;
            --nav-border-radius: 0.375em;
            --nav-border-color: #ccc;
            --nav-border-width: 0.0625em;
            --nav-shadow-color: rgba(0, 0, 0, .2);
            --nav-shadow-width: 0 1px 5px;
            --nav-bg: #eee;
            --nav-font-family: Menlo, Roboto Mono, monospace;
            --nav-default-scale: .8;
            --nav-active-scale: 1;
            --nav-position-left: 0;
            --nav-position-right: unset;
            /* if you want to change sides just switch one property */
            /* from properties to "unset" and the other to 0 */
            /* title */
            --nav-title-size: 0.625em;
            --nav-title-color: #777;
            --nav-title-padding-x: 1rem;
            --nav-title-padding-y: 0.25em;
            /* nav button */
            --nav-button-padding-x: 1rem;
            --nav-button-padding-y: 0.375em;
            --nav-button-border-radius: 0.375em;
            --nav-button-font-size: 12px;
            --nav-button-hover-bg: #6495ed;
            --nav-button-hover-text-color: #fff;
            --nav-button-distance: 0.875em;
            /* underline */
            --underline-border-width: 0.0625em;
            --underline-border-color: #ccc;
            --underline-margin-y: 0.3125em;
        }

        /* popup settings 👆 */

        .popup {
            display: inline-block;
            text-rendering: optimizeLegibility;
            position: relative;
        }

        .popup input {
            display: none;

        }

        .burger {
            display: flex;
            position: relative;
            align-items: center;
            justify-content: center;
            background: var(--burger-bg);
            width: var(--burger-diameter);
            height: var(--burger-diameter);
            border-radius: var(--burger-btn-border-radius);
            border: none;
            cursor: pointer;
            overflow: hidden;
            transition: var(--burger-transition);
            outline: var(--burger-enable-outline-width) solid transparent;
            outline-offset: 0;
        }

        .burger span {
            height: var(--burger-line-height);
            width: var(--burger-line-width);
            background: var(--burger-color);
            border-radius: var(--burger-line-border-radius);
            position: absolute;
            transition: var(--burger-line-transition);
        }

        .burger span:nth-child(1) {
            top: var(--burger-offset);
        }

        .burger span:nth-child(2) {
            bottom: var(--burger-offset);
        }

        .burger span:nth-child(3) {
            top: 50%;
            transform: translateY(-50%);
        }

        .popup-window {
            margin-left: -87px;
            transform: scale(var(--nav-default-scale));
            visibility: hidden;
            opacity: 0;
            position: absolute;
            padding: var(--nav-padding-y) var(--nav-padding-x);
            background: var(--nav-bg);
            font-family: var(--nav-font-family);
            color: var(--nav-text-color);
            border-radius: var(--nav-border-radius);
            box-shadow: var(--nav-shadow-width) var(--nav-shadow-color);
            border: var(--nav-border-width) solid var(--nav-border-color);
            top: calc(var(--burger-diameter) + var(--burger-enable-outline-width) + var(--burger-enable-outline-offset));
            left: var(--nav-position-left);
            right: var(--nav-position-right);
            transition: var(--burger-transition);
            z-index: 5 !important;

        }

        .popup-window legend {
            padding: var(--nav-title-padding-y) var(--nav-title-padding-x);
            margin: 0;
            color: var(--nav-title-color);
            font-size: var(--nav-title-size);
            text-transform: uppercase;
        }

        .popup-window ul {
            margin: 0;
            padding: 0;
            list-style-type: none;
        }

        .popup-window ul button {
            outline: none;
            width: 100%;
            border: none;
            background: none;
            display: flex;
            align-items: center;
            color: var(--burger-color);
            font-size: var(--nav-button-font-size);
            padding: var(--nav-button-padding-y) var(--nav-button-padding-x);
            white-space: nowrap;
            border-radius: var(--nav-button-border-radius);
            cursor: pointer;
            column-gap: var(--nav-button-distance);
        }

        .popup-window ul li:nth-child(1) svg,
        .popup-window ul li:nth-child(2) svg {
            color: cornflowerblue;
        }

        .popup-window ul li:nth-child(4) svg,
        .popup-window ul li:nth-child(5) svg {
            color: rgb(153, 153, 153);
        }

        .popup-window ul li:nth-child(7) svg {
            color: red;
        }

        .popup-window hr {
            margin: var(--underline-margin-y) 0;
            border: none;
            border-bottom: var(--underline-border-width) solid var(--underline-border-color);
        }

        /* actions */

        .popup-window ul button:hover,
        .popup-window ul button:focus-visible,
        .popup-window ul button:hover svg,
        .popup-window ul button:focus-visible svg {
            color: var(--nav-button-hover-text-color);
            background: var(--nav-button-hover-bg);
        }

        .burger:hover {
            transform: scale(var(--burger-hover-scale));
        }

        .burger:active {
            transform: scale(var(--burger-active-scale));
        }

        .burger:focus:not(:hover) {
            outline-color: var(--burger-enable-outline-color);
            outline-offset: var(--burger-enable-outline-offset);
        }

        .popup input:checked+.burger span:nth-child(1) {
            top: 50%;
            transform: translateY(-50%) rotate(45deg);
        }

        .popup input:checked+.burger span:nth-child(2) {
            bottom: 50%;
            transform: translateY(50%) rotate(-45deg);
        }

        .popup input:checked+.burger span:nth-child(3) {
            transform: translateX(calc(var(--burger-diameter) * -1 - var(--burger-line-width)));
        }

        .popup input:checked~nav {
            transform: scale(var(--nav-active-scale));
            visibility: visible;
            opacity: 1;
        }

        .detail {
            width: 5%;
            height: 100%;
            float: right;
            margin-right: 20px;
            margin-top: 10px;
        }

        .nav_main nav .nav_space {
            margin-right: 30px;
            /* Adjust spacing here */
        }

        .nav_main {
            padding-left: 100px;
        }
    </style>


    <div class="container_header">
        <div class="user_head">
            <div class="wrapper">
                <div class="image-container" id="imageContainer">
                    <?php if(Auth::user()->profile_photo): ?>
                        <img src="<?php echo e(asset('user/profile_photo/' . Auth::user()->profile_photo)); ?>" class="image--cover">
                    <?php else: ?>
                        <img src="<?php echo e(asset('user/default_pic.jpg')); ?>" class="image--cover">
                    <?php endif; ?>
                    
                </div>
                <div class="user_detail">
                    <?php echo e(Auth::user()->name); ?> <br>
                    (<?php echo e(Auth::user()->designation); ?>) - (<?php echo e(Auth::user()->zone); ?>) <br>

                    Mobile : <?php echo e(Auth::user()->contact); ?> Email : <?php echo e(Auth::user()->email); ?>

                </div>
                


                <div class="detail">
                    <label class="popup">
                        <input type="checkbox">
                        <div class="burger" tabindex="0">
                            <span></span>
                            <span></span>
                            <span></span>
                        </div>
                        <nav class="popup-window">
                            <legend>Actions</legend>
                            <ul>
                                <li>
                                    <a href="<?php echo e(route('profile.edit')); ?>">
                                        <button>
                                            <svg stroke-linejoin="round" stroke-linecap="round" stroke-width="2"
                                                stroke="currentColor" fill="none" viewBox="0 0 24 24" height="14"
                                                width="14" xmlns="http://www.w3.org/2000/svg">
                                                <polygon points="16 3 21 8 8 21 3 21 3 16 16 3"></polygon>
                                            </svg>
                                            <span>Edit Profile</span>
                                        </button>
                                    </a>

                                </li>

                                <li>

                                    <a href="#"
                                        onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                        <button>
                                            <svg stroke-linejoin="round" stroke-linecap="round" stroke-width="2"
                                                stroke="currentColor" fill="none" viewBox="0 0 24 24" height="14"
                                                width="14" xmlns="http://www.w3.org/2000/svg">
                                                <line y2="18" x2="6" y1="6" x1="18">
                                                </line>
                                                <line y2="18" x2="18" y1="6" x1="6">
                                                </line>
                                            </svg>
                                            <span>Logout</span>
                                        </button>
                                    </a>

                                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST"
                                        style="display: none;">
                                        <?php echo csrf_field(); ?>
                                    </form>


                                </li>
                            </ul>
                        </nav>
                    </label>
                </div>
            </div>


        </div>

        <div class="nav_main">
            <nav>
                <a href="/home">Dashboard</a>
                <span class="nav_space"></span><!-- Add space here -->
                <a href="<?php echo e(route('users')); ?>">Members</a>
                <span class="nav_space"></span><!-- Add space here -->
                <a href="<?php echo e(route('subscription')); ?>">Annual membership</a>
                <span class="nav_space"></span><!-- Add space here -->
                <a href="<?php echo e(route('b_fund')); ?>">Benevolent Fund</a>
                <span class="nav_space"></span><!-- Add space here -->

                <a href="/blog_admin">Editorial</a>
            </nav>
        </div>

    </div>




    <!-- Bootstrap Modal -->
    <form action="<?php echo e(route('upload.image')); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="modal fade" id="uploadImageModal" tabindex="-1" aria-labelledby="uploadImageModalLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="uploadImageModalLabel">Change Profile Picture</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <input type="file" name="image" class="form-control">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary cancel" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Upload</button>
                    </div>
                </div>
            </div>
        </div>
    </form>


    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var imageContainer = document.getElementById('imageContainer');
            var uploadImageModal = new bootstrap.Modal(document.getElementById('uploadImageModal'));

            imageContainer.addEventListener('click', function() {
                uploadImageModal.show();
            });

            var closeButton = document.querySelector('.btn-close');
            closeButton.addEventListener('click', function() {
                uploadImageModal.hide();
            });

            var closeButton = document.querySelector('.cancel');
            closeButton.addEventListener('click', function() {
                uploadImageModal.hide();
            });
        });
    </script>
<?php /**PATH C:\xampp\htdocs\upvkss\resources\views/user/header.blade.php ENDPATH**/ ?>