<?php $__env->startSection('content'); ?>
    <div class="container is-custom">
        <!-- Profile page main wrapper -->
        <div id="profile-main" class="view-wrap is-headless">
            <div class="columns is-multiline no-margin">
                <!-- Left side column -->
                <div class="column is-paddingless">
                    <!-- Timeline Header -->
                    <!-- html/partials/pages/profile/timeline/timeline-header.html -->
                    <div class="cover-bg">
                        <img class="cover-image"
                            src="<?php echo e($user->cover_image ? asset('user/cover_image/' . Auth::user()->cover_image) : asset('default-cover.jpg')); ?>"
                            alt="Cover Image" />

                        <div class="avatar">
                            <?php if($user->profile_photo): ?>
                                <img src="<?php echo e(asset('user/profile_photo/' . $user->profile_photo)); ?>" d="user-avatar"
                                    class="avatar-image">
                            <?php else: ?>
                                <img src="<?php echo e(asset('user/default_pic.jpg')); ?>" d="user-avatar" class="avatar-image">
                            <?php endif; ?>

                            <div class=" is-far-left has-tooltip modal-trigger"
                                >

                            </div>
                        </div>
                        <div class="cover-overlay"></div>
                        <div
                            class="dropdown is-spaced is-right is-accent dropdown-trigger timeline-mobile-dropdown is-hidden-desktop">
                            <div>
                                <div class="button">
                                    <i data-feather="more-vertical"></i>
                                </div>
                            </div>
                            <div class="dropdown-menu" role="menu">
                                <div class="dropdown-content">
                                    <a href="/profile-main.html" class="dropdown-item">
                                        <div class="media">
                                            <i data-feather="activity"></i>
                                            <div class="media-content">
                                                <h3>Timeline</h3>
                                                <small>Open Timeline.</small>
                                            </div>
                                        </div>
                                    </a>
                                    <a href="/profile-about.html" class="dropdown-item">
                                        <div class="media">
                                            <i data-feather="align-right"></i>
                                            <div class="media-content">
                                                <h3>About</h3>
                                                <small>See about info.</small>
                                            </div>
                                        </div>
                                    </a>
                                    <a href="/profile-friends.html" class="dropdown-item">
                                        <div class="media">
                                            <i data-feather="heart"></i>
                                            <div class="media-content">
                                                <h3>Friends</h3>
                                                <small>See friends.</small>
                                            </div>
                                        </div>
                                    </a>
                                    <a href="/profile-photos.html" class="dropdown-item">
                                        <div class="media">
                                            <i data-feather="image"></i>
                                            <div class="media-content">
                                                <h3>Photos</h3>
                                                <small>See all photos.</small>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="profile-menu is-hidden-mobile">
                        <div class="menu-start">
                            <a href="<?php echo e(route('users')); ?>" class="button has-min-width">Members</a>
                            <a href="<?php echo e(route('subscription')); ?>" class="button has-min-width">Annual membership</a>
                        </div>
                        <div class="menu-end">
                            <a id="profile-friends-link" href="<?php echo e(route('b_fund')); ?>"
                                class="button has-min-width">Benevolent Fund</a>
                            <a href="/blog_admin" class="button has-min-width">Editorial</a>
                        </div>
                    </div>

                    <div class="profile-subheader">
                        <div class="subheader-middle">
                            <h2><?php echo e($user->name); ?></h2>
                            <span><?php echo e($user->designation); ?> - <?php echo e($user->zone); ?></span>
                        </div>
                    </div>
                </div>
            </div>

            <div class="columns">
                <div id="profile-timeline-widgets" class="column is-4">
                    <div class="box-heading">
                        <h4>Basic Infos</h4>
                    </div>
                    <div class="basic-infos-wrapper">
                        <div class="card is-profile-info">
                            <div class="info-row">
                                <div>
                                    <span>Bio</span>
                                    <a class="is-inverted"><?php echo e($user->bio); ?></a>
                                </div>
                            </div>
                            <div class="info-row">
                                <div>
                                    <span><i class="mdi mdi-contacts"></i>Mobile Number</span>

                                    <a class="is-inverted"> <?php echo e($user->cug_no); ?></a>
                                </div>
                            </div>
                            <div class="info-row">
                                <div>
                                    <span> <i class="mdi mdi-email"></i>Email</span>
                                    <a class="is-inverted"><?php echo e($user->email); ?></a>
                                </div>
                            </div>
                            <div class="info-row">
                                <div>
                                    <span><i class="mdi mdi-home"></i>Place of Posting</span>
                                    <a class="is-inverted"><?php echo e($user->posting_area); ?></a>
                                </div>
                            </div>
                            <?php if($user->contact_privacy === 1): ?>
                                <div class="info-row">
                                    <div>
                                        <span>Contact</span>
                                        <a class="is-muted"><?php echo e($user->contact); ?></a>
                                    </div>
                                    <i class="mdi mdi-contacts"></i>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <!-- Photos widget -->
                     <div class="box-heading">
                                    <h4>Photos</h4>
                                    <div class="dropdown is-neutral is-spaced is-right dropdown-trigger">
                                        <div>
                                            <div class="button">
                                                <i data-feather="more-vertical"></i>
                                            </div>
                                        </div>
                                        <div class="dropdown-menu" role="menu">
                                            <div class="dropdown-content">
                                                <a class="dropdown-item">
                                                    <div class="media">
                                                        <i data-feather="image"></i>
                                                        <div class="media-content">
                                                            <h3>View Photos</h3>
                                                            <small>View all your photos</small>
                                                        </div>
                                                    </div>
                                                </a>
                                                <a href="#" class="dropdown-item">
                                                    <div class="media">
                                                        <i data-feather="tag"></i>
                                                        <div class="media-content">
                                                            <h3>Tagged</h3>
                                                            <small>View photos you are tagged in.</small>
                                                        </div>
                                                    </div>
                                                </a>
                                                <a href="#" class="dropdown-item">
                                                    <div class="media">
                                                        <i data-feather="folder"></i>
                                                        <div class="media-content">
                                                            <h3>Albums</h3>
                                                            <small>Open my albums.</small>
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="is-photos-widget">
                                    <img src="https://via.placeholder.com/200x200"
                                        data-demo-src="https://friendkit.cssninja.io/assets/img/demo/widgets/photos/1.jpg"
                                        alt="" />
                                    <img src="https://via.placeholder.com/200x200"
                                        data-demo-src="https://friendkit.cssninja.io/assets/img/demo/widgets/photos/2.jpg"
                                        alt="" />
                                    <img src="https://via.placeholder.com/200x200"
                                        data-demo-src="https://friendkit.cssninja.io/assets/img/demo/widgets/photos/3.jpg"
                                        alt="" />
                                    <img src="https://via.placeholder.com/200x200"
                                        data-demo-src="https://friendkit.cssninja.io/assets/img/demo/widgets/photos/4.jpg"
                                        alt="" />
                                    <img src="https://via.placeholder.com/200x200"
                                        data-demo-src="https://friendkit.cssninja.io/assets/img/demo/widgets/photos/5.jpg"
                                        alt="" />
                                    <img src="https://via.placeholder.com/200x200"
                                        data-demo-src="https://friendkit.cssninja.io/assets/img/demo/widgets/photos/6.jpg"
                                        alt="" />
                                    <img src="https://via.placeholder.com/200x200"
                                        data-demo-src="https://friendkit.cssninja.io/assets/img/demo/widgets/photos/7.jpg"
                                        alt="" />
                                    <img src="https://via.placeholder.com/200x200"
                                        data-demo-src="https://friendkit.cssninja.io/assets/img/demo/widgets/photos/8.jpg"
                                        alt="" />
                                    <img src="https://via.placeholder.com/200x200"
                                        data-demo-src="https://friendkit.cssninja.io/assets/img/demo/widgets/photos/9.jpg"
                                        alt="" />
                                    <img src="https://via.placeholder.com/200x200"
                                        data-demo-src="https://friendkit.cssninja.io/assets/img/demo/widgets/photos/10.jpg"
                                        alt="" />
                                    <img src="https://via.placeholder.com/200x200"
                                        data-demo-src="https://friendkit.cssninja.io/assets/img/demo/widgets/photos/11.jpg"
                                        alt="" />
                                    <img src="https://via.placeholder.com/200x200"
                                        data-demo-src="https://friendkit.cssninja.io/assets/img/demo/widgets/photos/12.jpg"
                                        alt="" />
                                </div>




                    <!-- html/partials/widgets/schedule/schedule-widget.html -->
                    <div class="schedule">
                        <div class="schedule-day-container hidden">
                            <div class="day-header day-header--large">
                                <div class="day-header-bg"></div>
                                <div class="day-header-close">
                                    <i data-feather="x"></i>
                                </div>
                                <div class="day-header-content">
                                    <div class="day-header-title">
                                        <div class="day-header-title-day">24</div>
                                        <div class="day-header-title-month">October</div>
                                    </div>
                                    <div class="day-header-event">Workout Session</div>
                                </div>
                            </div>
                            <div class="day-content has-slimscroll">
                                <!-- Event 1 details -->
                                <!-- html/partials/widgets/schedule/event-details/event-1.html -->
                                <div id="event-1" class="event-details-wrap">
                                    <div class="meta-block">
                                        <i class="mdi mdi-lock"></i>
                                        <div class="meta">
                                            <span>Private</span>
                                            <span>This is a private event</span>
                                        </div>
                                    </div>
                                    <div class="meta-block">
                                        <i class="mdi mdi-map-marker"></i>
                                        <div class="meta">
                                            <span>Where</span>
                                            <span>@ Mom and Dad's house</span>
                                        </div>
                                    </div>
                                    <div class="meta-block">
                                        <i class="mdi mdi-progress-clock"></i>
                                        <div class="meta">
                                            <span>When</span>
                                            <span>02:00pm - 03:30pm</span>
                                        </div>
                                    </div>
                                    <div class="participants-wrap">
                                        <label>4 Participants</label>
                                        <div class="participants">
                                            <img src="https://via.placeholder.com/300x300"
                                                data-demo-src="https://friendkit.cssninja.io/assets/img/avatars/jenna.png"
                                                alt="" data-user-popover="0" />
                                            <img src="https://via.placeholder.com/300x300"
                                                data-demo-src="https://friendkit.cssninja.io/assets/img/avatars/nelly.png"
                                                alt="" data-user-popover="9" />
                                            <img src="https://via.placeholder.com/300x300"
                                                data-demo-src="https://friendkit.cssninja.io/assets/img/avatars/stella.jpg"
                                                alt="" data-user-popover="2" />
                                            <img src="https://via.placeholder.com/300x300"
                                                data-demo-src="https://friendkit.cssninja.io/assets/img/avatars/milly.jpg"
                                                alt="" data-user-popover="7" />
                                        </div>
                                    </div>
                                    <div class="event-description">
                                        <label>Description</label>
                                        <p>
                                            Lorem ipsum dolor sit amet, consectetur adipisicing elit. Adipisci
                                            blanditiis commodi accusamus dolores itaque repudiandae.
                                        </p>
                                    </div>
                                    <hr />
                                    <div class="button-wrap">
                                        <a class="button is-bold">Participating</a>
                                        <a class="button is-bold">Details</a>
                                    </div>
                                </div>
                                <!-- Event 2 details -->
                                <!-- html/partials/widgets/schedule/event-details/event-2.html -->
                                <div id="event-2" class="event-details-wrap">
                                    <div class="meta-block">
                                        <i class="mdi mdi-lock"></i>
                                        <div class="meta">
                                            <span>Private</span>
                                            <span>This is a private event</span>
                                        </div>
                                    </div>
                                    <div class="meta-block">
                                        <i class="mdi mdi-map-marker"></i>
                                        <div class="meta">
                                            <span>Where</span>
                                            <span>@ <a class="is-inverted">Wayne's Coffeeshop</a>, LA</span>
                                        </div>
                                    </div>
                                    <div class="meta-block">
                                        <i class="mdi mdi-progress-clock"></i>
                                        <div class="meta">
                                            <span>When</span>
                                            <span>11:00am - 12:30pm</span>
                                        </div>
                                    </div>
                                    <div class="participants-wrap">
                                        <label>3 Participants</label>
                                        <div class="participants">
                                            <img src="https://via.placeholder.com/300x300"
                                                data-demo-src="https://friendkit.cssninja.io/assets/img/avatars/jenna.png"
                                                alt="" data-user-popover="0" />
                                            <img src="https://via.placeholder.com/300x300"
                                                data-demo-src="https://friendkit.cssninja.io/assets/img/avatars/edward.jpeg"
                                                alt="" data-user-popover="4" />
                                            <img src="https://via.placeholder.com/300x300"
                                                data-demo-src="https://friendkit.cssninja.io/assets/img/avatars/rolf.jpg"
                                                alt="" data-user-popover="13" />
                                        </div>
                                    </div>
                                    <div class="event-description">
                                        <label>Description</label>
                                        <p>
                                            Lorem ipsum dolor sit amet, consectetur adipisicing elit. Adipisci
                                            blanditiis commodi accusamus dolores itaque repudiandae.
                                        </p>
                                    </div>
                                    <hr />
                                    <div class="button-wrap">
                                        <a class="button is-bold">Participating</a>
                                        <a class="button is-bold">Details</a>
                                    </div>
                                </div>
                                <!-- Event 3 details -->
                                <!-- html/partials/widgets/schedule/event-details/event-3.html -->
                                <div id="event-3" class="event-details-wrap">
                                    <div class="meta-block">
                                        <i class="mdi mdi-earth"></i>
                                        <div class="meta">
                                            <span>Public</span>
                                            <span>This is a public event</span>
                                        </div>
                                    </div>
                                    <div class="meta-block">
                                        <i class="mdi mdi-map-marker"></i>
                                        <div class="meta">
                                            <span>Where</span>
                                            <span>@ Frank's appartment</span>
                                        </div>
                                    </div>
                                    <div class="meta-block">
                                        <i class="mdi mdi-progress-clock"></i>
                                        <div class="meta">
                                            <span>When</span>
                                            <span>08:00pm - 02:00am</span>
                                        </div>
                                    </div>
                                    <div class="participants-wrap">
                                        <label>29 Participants</label>
                                        <div class="participants">
                                            <img src="https://via.placeholder.com/300x300"
                                                data-demo-src="https://friendkit.cssninja.io/assets/img/avatars/jenna.png"
                                                alt="" data-user-popover="0" />
                                            <img src="https://via.placeholder.com/300x300"
                                                data-demo-src="https://friendkit.cssninja.io/assets/img/avatars/elise.jpg"
                                                alt="" data-user-popover="6" />
                                            <img src="https://via.placeholder.com/300x300"
                                                data-demo-src="https://friendkit.cssninja.io/assets/img/avatars/daniel.jpg"
                                                alt="" data-user-popover="3" />
                                            <img src="https://via.placeholder.com/300x300"
                                                data-demo-src="https://friendkit.cssninja.io/assets/img/avatars/rolf.jpg"
                                                alt="" data-user-popover="13" />
                                            <img src="https://via.placeholder.com/300x300"
                                                data-demo-src="https://friendkit.cssninja.io/assets/img/avatars/milly.jpg"
                                                alt="" data-user-popover="7" />
                                            <div class="is-more">+24</div>
                                        </div>
                                    </div>
                                    <div class="event-description">
                                        <label>Description</label>
                                        <p>
                                            Lorem ipsum dolor sit amet, consectetur adipisicing elit. Adipisci
                                            blanditiis commodi accusamus dolores itaque repudiandae.
                                        </p>
                                    </div>
                                    <hr />
                                    <div class="button-wrap">
                                        <a class="button is-bold">Participating</a>
                                        <a class="button is-bold">Details</a>
                                    </div>
                                </div>
                                <!-- Event 4 details -->
                                <!-- html/partials/widgets/schedule/event-details/event-4.html -->
                                <div id="event-4" class="event-details-wrap">
                                    <div class="meta-block">
                                        <i class="mdi mdi-lock"></i>
                                        <div class="meta">
                                            <span>Private</span>
                                            <span>This is a private event</span>
                                        </div>
                                    </div>
                                    <div class="meta-block">
                                        <i class="mdi mdi-map-marker"></i>
                                        <div class="meta">
                                            <span>Where</span>
                                            <span>@ <a class="is-inverted">Gold Gym</a>, LA</span>
                                        </div>
                                    </div>
                                    <div class="meta-block">
                                        <i class="mdi mdi-progress-clock"></i>
                                        <div class="meta">
                                            <span>When</span>
                                            <span>05:00pm - 07:00pm</span>
                                        </div>
                                    </div>
                                    <div class="participants-wrap">
                                        <label>2 Participants</label>
                                        <div class="participants">
                                            <img src="https://via.placeholder.com/300x300"
                                                data-demo-src="https://friendkit.cssninja.io/assets/img/avatars/jenna.png"
                                                alt="" data-user-popover="0" />
                                            <img src="https://via.placeholder.com/300x300"
                                                data-demo-src="https://friendkit.cssninja.io/assets/img/avatars/lana.jpeg"
                                                alt="" data-user-popover="10" />
                                        </div>
                                    </div>
                                    <div class="event-description">
                                        <label>Description</label>
                                        <p>
                                            Lorem ipsum dolor sit amet, consectetur adipisicing elit. Adipisci
                                            blanditiis commodi accusamus dolores itaque repudiandae.
                                        </p>
                                    </div>
                                    <hr />
                                    <div class="button-wrap">
                                        <a class="button is-bold">Participating</a>
                                        <a class="button is-bold">Details</a>
                                    </div>
                                </div>
                                <!-- Event 5 details -->
                                <!-- html/partials/widgets/schedule/event-details/event-5.html -->
                                <div id="event-5" class="event-details-wrap">
                                    <div class="meta-block">
                                        <i class="mdi mdi-lock"></i>
                                        <div class="meta">
                                            <span>Private</span>
                                            <span>This is a private event</span>
                                        </div>
                                    </div>
                                    <div class="meta-block">
                                        <i class="mdi mdi-map-marker"></i>
                                        <div class="meta">
                                            <span>Where</span>
                                            <span>@ <a class="is-inverted">Massive Dynamics Office</a>, LA</span>
                                        </div>
                                    </div>
                                    <div class="meta-block">
                                        <i class="mdi mdi-progress-clock"></i>
                                        <div class="meta">
                                            <span>When</span>
                                            <span>08:30am - 10:00am</span>
                                        </div>
                                    </div>
                                    <div class="participants-wrap">
                                        <label>29 Participants</label>
                                        <div class="participants">
                                            <img src="https://via.placeholder.com/300x300"
                                                data-demo-src="https://friendkit.cssninja.io/assets/img/avatars/jenna.png"
                                                alt="" data-user-popover="0" />
                                            <img src="https://via.placeholder.com/300x300"
                                                data-demo-src="https://friendkit.cssninja.io/assets/img/avatars/dan.jpg"
                                                alt="" data-user-popover="1" />
                                            <img src="https://via.placeholder.com/300x300"
                                                data-demo-src="https://friendkit.cssninja.io/assets/img/avatars/edward.jpeg"
                                                alt="" data-user-popover="5" />
                                            <img src="https://via.placeholder.com/300x300"
                                                data-demo-src="https://friendkit.cssninja.io/assets/img/avatars/mike.jpg"
                                                alt="" data-user-popover="12" />
                                            <img src="https://via.placeholder.com/300x300"
                                                data-demo-src="https://friendkit.cssninja.io/assets/img/avatars/gaelle.jpeg"
                                                alt="" data-user-popover="11" />
                                            <div class="is-more">+4</div>
                                        </div>
                                    </div>
                                    <div class="event-description">
                                        <label>Description</label>
                                        <p>
                                            Lorem ipsum dolor sit amet, consectetur adipisicing elit. Adipisci
                                            blanditiis commodi accusamus dolores itaque repudiandae.
                                        </p>
                                    </div>
                                    <hr />
                                    <div class="button-wrap">
                                        <a class="button is-bold">Participating</a>
                                        <a class="button is-bold">Details</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- <div class="schedule-header">
                                        <div class="nav-icon">
                                            <i data-feather="chevron-left"></i>
                                        </div>
                                        <div class="month">October</div>
                                        <div class="nav-icon">
                                            <i data-feather="chevron-right"></i>
                                        </div>
                                    </div> -->
                        <!-- <div class="schedule-calendar">
                                        <div class="calendar-row day-row">
                                            <div class="day day-name">M</div>
                                            <div class="day day-name">T</div>
                                            <div class="day day-name">W</div>
                                            <div class="day day-name">T</div>
                                            <div class="day day-name">F</div>
                                            <div class="day day-name">S</div>
                                            <div class="day day-name">S</div>
                                        </div>
                                        <div class="calendar-row">
                                            <div class="day">&nbsp;</div>
                                            <div class="day">&nbsp;</div>
                                            <div class="day">1</div>
                                            <div class="day event green" data-content="1" data-day="2"
                                                data-event="Eat at mom and dad's">
                                                2
                                            </div>
                                            <div class="day">3</div>
                                            <div class="day">4</div>
                                            <div class="day">5</div>
                                        </div>
                                        <div class="calendar-row">
                                            <div class="day">6</div>
                                            <div class="day event purple" data-content="2" data-day="7"
                                                data-event="Meet customer in LA">
                                                7
                                            </div>
                                            <div class="day">8</div>
                                            <div class="day">9</div>
                                            <div class="day">10</div>
                                            <div class="day">11</div>
                                            <div class="day">12</div>
                                        </div>
                                        <div class="calendar-row">
                                            <div class="day">13</div>
                                            <div class="day">14</div>
                                            <div class="day">15</div>
                                            <div class="day">16</div>
                                            <div class="day">17</div>
                                            <div class="day">18</div>
                                            <div class="day">19</div>
                                        </div>
                                        <div class="calendar-row">
                                            <div class="day">20</div>
                                            <div class="day">21</div>
                                            <div class="day event green" data-content="3" data-day="22"
                                                data-event="Frank's birthday">
                                                22
                                            </div>
                                            <div class="day">23</div>
                                            <div class="day event primary" data-content="4" data-day="24"
                                                data-event="Workout Session">
                                                24
                                            </div>
                                            <div class="day">25</div>
                                            <div class="day event purple" data-content="5" data-day="26"
                                                data-event="Project review">
                                                26
                                            </div>
                                        </div>
                                        <div class="calendar-row">
                                            <div class="day">27</div>
                                            <div class="day">28</div>
                                            <div class="day">29</div>
                                            <div class="day">30</div>
                                            <div class="day"></div>
                                            <div class="day"></div>
                                            <div class="day"></div>
                                        </div>
                                        <div class="next-fab">
                                            <i data-feather="chevron-down"></i>
                                        </div>
                                    </div> -->
                        <div class="schedule-divider"></div>
                        <div class="schedule-events">
                            <div class="schedule-events-title">Upcoming events</div>
                            <div class="schedule-event">
                                <div class="event-date green">2</div>
                                <div class="event-title">
                                    <span>Eat at mom and dad's</span>
                                    <span>07:30pm | Home</span>
                                </div>
                            </div>
                            <div class="schedule-event">
                                <div class="event-date purple">7</div>
                                <div class="event-title">
                                    <span>Meet customer in LA</span>
                                    <span>11:00am | St Luc Café</span>
                                </div>
                            </div>
                            <div class="schedule-event">
                                <div class="event-date green">22</div>
                                <div class="event-title">
                                    <span>Frank's birthday</span>
                                    <span>03:00pm | Frank's home</span>
                                </div>
                            </div>
                            <div class="schedule-event">
                                <div class="event-date primary">24</div>
                                <div class="event-title">
                                    <span>Workout session</span>
                                    <span>07:00am | Gold Gym</span>
                                </div>
                            </div>
                            <div class="schedule-event">
                                <div class="event-date purple">26</div>
                                <div class="event-title">
                                    <span>Project review</span>
                                    <span>08:00am | Office</span>
                                </div>
                            </div>
                            <div class="button-wrap">
                                <a class="button is-fullwidth has-icon"><i data-feather="plus"></i>New Event</a>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="column is-8">

                    <!--  -->

                    <!--=========== birthday start =================-->




                    <!--=========== birthday end =================-->
                    <!--=========== retirement start ============ -->
                    <div class="main-section">

                        <!--=========== retirement end ============ -->
                        <div id="profile-timeline-posts" class="box-heading">
                            <h4>Posts</h4>
                            <!-- <div class="button-wrap">
                                        <button type="button" class="button is-active">Recent</button>
                                        <button type="button" class="button">Popular</button>
                                    </div> -->
                        </div>
                        <div class="profile-timeline">
                            <!-- Timeline post 1 -->
                            <!-- html/partials/pages/profile/posts/timeline-post1.html -->
                            <!-- Timeline POST #1 -->
                            <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="profile-post">

                                <!-- Timeline -->
                                <!-- <div class="time is-hidden-mobile">
                                                <div class="img-container">
                                                    <img src="https://via.placeholder.com/300x300"
                                                        data-demo-src="<?php echo e(asset('user/profile_photo/' . $post->user->profile_photo)); ?>"
                                                        onerror="this.onerror=null; this.src='<?php echo e(asset('user/default_pic.jpg')); ?>'"
                                                        alt="User Profile Photo" width="300" height="300">

                                                </div>
                                            </div> -->
                                <!-- Post -->
                                <div class="card is-post">
                                    <!-- Main wrap -->
                                    <div class="content-wrap">
                                        <!-- Header -->
                                        <div class="card-heading">
                                            <div class="user-block">
                                                <div class="image">
                                                    <img src="https://via.placeholder.com/300x300"
                                                        data-demo-src="<?php echo e(asset('user/profile_photo/' . $post->user->profile_photo)); ?>"
                                                        onerror="this.onerror=null; this.src='<?php echo e(asset('user/default_pic.jpg')); ?>'"
                                                        alt="User Profile Photo" width="300" height="300"
                                                        data-user-popover="0">
                                                </div>
                                                <div class="user-info">
                                                    <a href="#"><?php echo e($post->post->author->name); ?></a>
                                                    <?php
                                                        $posted_at = \Carbon\Carbon::parse($post->posted_at);
                                                    ?>
                                                    <span class="time"><?php echo e($posted_at->format('F j Y, g:ia')); ?>

                                                    </span>
                                                </div>
                                            </div>

                                            <div class="dropdown is-spaced is-right is-neutral dropdown-trigger">
                                                <div>
                                                    <div class="button">
                                                        <i data-feather="more-vertical"></i>
                                                    </div>
                                                </div>
                                                <div class="dropdown-menu" role="menu">
                                                    <div class="dropdown-content">
                                                        <a href="#" class="dropdown-item">
                                                            <div class="media">
                                                                <i data-feather="bookmark"></i>
                                                                <div class="media-content">
                                                                    <h3>Bookmark</h3>
                                                                    <small>Add this post to your bookmarks.</small>
                                                                </div>
                                                            </div>
                                                        </a>
                                                        <a class="dropdown-item">
                                                            <div class="media">
                                                                <i data-feather="bell"></i>
                                                                <div class="media-content">
                                                                    <h3>Notify me</h3>
                                                                    <small>Send me the updates.</small>
                                                                </div>
                                                            </div>
                                                        </a>
                                                        <hr class="dropdown-divider" />
                                                        <a href="#" class="dropdown-item">
                                                            <div class="media">
                                                                <i data-feather="flag"></i>
                                                                <div class="media-content">
                                                                    <h3>Flag</h3>
                                                                    <small>In case of inappropriate content.</small>
                                                                </div>
                                                            </div>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- /Header -->

                                        <!-- Post body -->
                                        <div class="card-body">
                                            <!-- Post body text -->
                                            <div class="post-text">
                                                <p>
                                                    <?php echo e($post->title); ?>

                                                </p>

                                                <p></p>
                                            </div>
                                            <!-- Featured image -->

                                            <div class="post-image">
                                                <a data-fancybox="profile-post1" data-lightbox-type="comments"
                                                    data-thumb="<?php echo e($post->image_url); ?>"
                                                    href="https://via.placeholder.com/1600x900"
                                                    data-demo-href="<?php echo e($post->image_url); ?>">
                                                    <img src="https://via.placeholder.com/1600x900"
                                                        data-demo-src="<?php echo e($post->image_url); ?>" alt="" />
                                                </a>
                                                

                                                <!-- Post actions -->
                                                <div class="like-wrapper">
                                                    <a href="javascript:void(0);" class="like-button">
                                                        <i class="mdi mdi-heart not-liked bouncy"></i>
                                                        <i class="mdi mdi-heart is-liked bouncy"></i>
                                                        <span class="like-overlay"></span>
                                                    </a>
                                                </div>

                                                <div class="fab-wrapper is-share">
                                                    <a href="javascript:void(0);"
                                                        class="small-fab share-fab modal-trigger"
                                                        data-modal="share-modal">
                                                        <i data-feather="link-2"></i>
                                                    </a>
                                                </div>

                                                <div class="fab-wrapper is-comment">
                                                    <a href="javascript:void(0);" class="small-fab">
                                                        <i data-feather="message-circle"></i>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- /Post body -->

                                        <!-- Post footer -->
                                        
                                        <!-- /Post footer -->
                                    </div>
                                    <!-- /Main wrap -->

                                    <!-- Comments -->
                                    <div class="comments-wrap is-hidden">
                                        <!-- Header -->
                                        <div class="comments-heading">
                                            <h4>Comments <small>(5)</small></h4>
                                            <div class="close-comments">
                                                <i data-feather="x"></i>
                                            </div>
                                        </div>
                                        <!-- Header -->

                                        <!-- Comments body -->
                                        <div class="comments-body has-slimscroll">
                                            <!-- Comment -->
                                            <div class="media is-comment">
                                                <!-- User image -->
                                                <div class="media-left">
                                                    <div class="image">
                                                        <img src="https://via.placeholder.com/300x300"
                                                            data-demo-src="https://friendkit.cssninja.io/assets/img/avatars/bobby.jpg"
                                                            data-user-popover="8" alt="" />
                                                    </div>
                                                </div>
                                                <!-- Content -->
                                                <div class="media-content">
                                                    <a href="#">Bobby Brown</a>
                                                    <span class="time">1 hour ago</span>
                                                    <p>
                                                        Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do
                                                        eiusmod tempo incididunt ut labore et dolore magna aliqua. Ut
                                                        enim
                                                        ad minim veniam, quis nostrud exercitation ullamco laboris
                                                        consequat.
                                                    </p>
                                                    <!-- Comment actions -->
                                                    <div class="controls">
                                                        <div class="like-count">
                                                            <i data-feather="thumbs-up"></i>
                                                            <span>1</span>
                                                        </div>
                                                        <div class="reply">
                                                            <a href="#">Reply</a>
                                                        </div>
                                                    </div>
                                                    <!-- Nested Comment -->
                                                    <div class="media is-comment">
                                                        <!-- User image -->
                                                        <div class="media-left">
                                                            <div class="image">
                                                                <img src="https://via.placeholder.com/300x300"
                                                                    data-demo-src="https://friendkit.cssninja.io/assets/img/avatars/daniel.jpg"
                                                                    data-user-popover="3" alt="" />
                                                            </div>
                                                        </div>
                                                        <!-- Content -->
                                                        <div class="media-content">
                                                            <a href="#">Daniel Wellington</a>
                                                            <span class="time">3 minutes ago</span>
                                                            <p>
                                                                Lorem ipsum dolor sit amet, consectetur adipisicing
                                                                elit,
                                                                sed
                                                                do eiusmod tempo incididunt ut labore et dolore magna
                                                                aliqua.
                                                            </p>
                                                            <!-- Comment actions -->
                                                            <div class="controls">
                                                                <div class="like-count">
                                                                    <i data-feather="thumbs-up"></i>
                                                                    <span>4</span>
                                                                </div>
                                                                <div class="reply">
                                                                    <a href="#">Reply</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <!-- Right side dropdown -->
                                                        <div class="media-right">
                                                            <div
                                                                class="dropdown is-spaced is-right is-neutral dropdown-trigger">
                                                                <div>
                                                                    <div class="button">
                                                                        <i data-feather="more-vertical"></i>
                                                                    </div>
                                                                </div>
                                                                <div class="dropdown-menu" role="menu">
                                                                    <div class="dropdown-content">
                                                                        <a class="dropdown-item">
                                                                            <div class="media">
                                                                                <i data-feather="x"></i>
                                                                                <div class="media-content">
                                                                                    <h3>Hide</h3>
                                                                                    <small>Hide this comment.</small>
                                                                                </div>
                                                                            </div>
                                                                        </a>
                                                                        <div class="dropdown-divider"></div>
                                                                        <a href="#" class="dropdown-item">
                                                                            <div class="media">
                                                                                <i data-feather="flag"></i>
                                                                                <div class="media-content">
                                                                                    <h3>Report</h3>
                                                                                    <small>Report this comment.</small>
                                                                                </div>
                                                                            </div>
                                                                        </a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- /Nested Comment -->
                                                </div>
                                                <!-- Right side dropdown -->
                                                <div class="media-right">
                                                    <div
                                                        class="dropdown is-spaced is-right is-neutral dropdown-trigger">
                                                        <div>
                                                            <div class="button">
                                                                <i data-feather="more-vertical"></i>
                                                            </div>
                                                        </div>
                                                        <div class="dropdown-menu" role="menu">
                                                            <div class="dropdown-content">
                                                                <a class="dropdown-item">
                                                                    <div class="media">
                                                                        <i data-feather="x"></i>
                                                                        <div class="media-content">
                                                                            <h3>Hide</h3>
                                                                            <small>Hide this comment.</small>
                                                                        </div>
                                                                    </div>
                                                                </a>
                                                                <div class="dropdown-divider"></div>
                                                                <a href="#" class="dropdown-item">
                                                                    <div class="media">
                                                                        <i data-feather="flag"></i>
                                                                        <div class="media-content">
                                                                            <h3>Report</h3>
                                                                            <small>Report this comment.</small>
                                                                        </div>
                                                                    </div>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- /Comment -->

                                            <!-- Comment -->
                                            <div class="media is-comment">
                                                <!-- User image -->
                                                <div class="media-left">
                                                    <div class="image">
                                                        <img src="https://via.placeholder.com/300x300"
                                                            data-demo-src="https://friendkit.cssninja.io/assets/img/avatars/mike.jpg"
                                                            data-user-popover="12" alt="" />
                                                    </div>
                                                </div>
                                                <!-- Content -->
                                                <div class="media-content">
                                                    <a href="#">Mike Lasalle</a>
                                                    <span class="time">Yesterday</span>
                                                    <p>
                                                        Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do
                                                        eiusmod tempo incididunt ut labore et dolore magna aliqua.
                                                    </p>
                                                    <!-- Comment actions -->
                                                    <div class="controls">
                                                        <div class="like-count">
                                                            <i data-feather="thumbs-up"></i>
                                                            <span>3</span>
                                                        </div>
                                                        <div class="reply">
                                                            <a href="#">Reply</a>
                                                        </div>
                                                    </div>
                                                    <!-- Nested Comment -->
                                                    <div class="media is-comment">
                                                        <!-- User image -->
                                                        <div class="media-left">
                                                            <div class="image">
                                                                <img src="https://via.placeholder.com/300x300"
                                                                    data-demo-src="https://friendkit.cssninja.io/assets/img/avatars/lana.jpeg"
                                                                    data-user-popover="10" alt="" />
                                                            </div>
                                                        </div>
                                                        <!-- Content -->
                                                        <div class="media-content">
                                                            <a href="#">Lana Henrikssen</a>
                                                            <span class="time">3 minutes ago</span>
                                                            <p>
                                                                Lorem ipsum dolor sit amet, consectetur adipisicing
                                                                elit,
                                                                sed
                                                                do eiusmod tempo incididunt ut labore et dolore magna
                                                                aliqua.
                                                            </p>
                                                            <!-- Comment actions -->
                                                            <div class="controls">
                                                                <div class="like-count">
                                                                    <i data-feather="thumbs-up"></i>
                                                                    <span>4</span>
                                                                </div>
                                                                <div class="reply">
                                                                    <a href="#">Reply</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <!-- Right side dropdown -->
                                                        <div class="media-right">
                                                            <div
                                                                class="dropdown is-spaced is-right is-neutral dropdown-trigger">
                                                                <div>
                                                                    <div class="button">
                                                                        <i data-feather="more-vertical"></i>
                                                                    </div>
                                                                </div>
                                                                <div class="dropdown-menu" role="menu">
                                                                    <div class="dropdown-content">
                                                                        <a class="dropdown-item">
                                                                            <div class="media">
                                                                                <i data-feather="x"></i>
                                                                                <div class="media-content">
                                                                                    <h3>Hide</h3>
                                                                                    <small>Hide this comment.</small>
                                                                                </div>
                                                                            </div>
                                                                        </a>
                                                                        <div class="dropdown-divider"></div>
                                                                        <a href="#" class="dropdown-item">
                                                                            <div class="media">
                                                                                <i data-feather="flag"></i>
                                                                                <div class="media-content">
                                                                                    <h3>Report</h3>
                                                                                    <small>Report this comment.</small>
                                                                                </div>
                                                                            </div>
                                                                        </a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- /Nested Comment -->
                                                </div>
                                                <!-- Right side dropdown -->
                                                <div class="media-right">
                                                    <div
                                                        class="dropdown is-spaced is-right is-neutral dropdown-trigger">
                                                        <div>
                                                            <div class="button">
                                                                <i data-feather="more-vertical"></i>
                                                            </div>
                                                        </div>
                                                        <div class="dropdown-menu" role="menu">
                                                            <div class="dropdown-content">
                                                                <a class="dropdown-item">
                                                                    <div class="media">
                                                                        <i data-feather="x"></i>
                                                                        <div class="media-content">
                                                                            <h3>Hide</h3>
                                                                            <small>Hide this comment.</small>
                                                                        </div>
                                                                    </div>
                                                                </a>
                                                                <div class="dropdown-divider"></div>
                                                                <a href="#" class="dropdown-item">
                                                                    <div class="media">
                                                                        <i data-feather="flag"></i>
                                                                        <div class="media-content">
                                                                            <h3>Report</h3>
                                                                            <small>Report this comment.</small>
                                                                        </div>
                                                                    </div>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- /Comment -->

                                            <!-- Comment -->
                                            <div class="media is-comment">
                                                <!-- User image -->
                                                <div class="media-left">
                                                    <div class="image">
                                                        <img src="https://via.placeholder.com/300x300"
                                                            data-demo-src="https://friendkit.cssninja.io/assets/img/avatars/nelly.png"
                                                            data-user-popover="9" alt="" />
                                                    </div>
                                                </div>
                                                <!-- Content -->
                                                <div class="media-content">
                                                    <a href="#">Nelly Schwartz</a>
                                                    <span class="time">2 days ago</span>
                                                    <p>
                                                        Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do
                                                        eiusmod tempo incididunt ut labore et dolore magna aliqua.
                                                    </p>
                                                    <!-- Comment actions -->
                                                    <div class="controls">
                                                        <div class="like-count">
                                                            <i data-feather="thumbs-up"></i>
                                                            <span>1</span>
                                                        </div>
                                                        <div class="reply">
                                                            <a href="#">Reply</a>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- Right side dropdown -->
                                                <div class="media-right">
                                                    <div
                                                        class="dropdown is-spaced is-right is-neutral dropdown-trigger">
                                                        <div>
                                                            <div class="button">
                                                                <i data-feather="more-vertical"></i>
                                                            </div>
                                                        </div>
                                                        <div class="dropdown-menu" role="menu">
                                                            <div class="dropdown-content">
                                                                <a class="dropdown-item">
                                                                    <div class="media">
                                                                        <i data-feather="x"></i>
                                                                        <div class="media-content">
                                                                            <h3>Hide</h3>
                                                                            <small>Hide this comment.</small>
                                                                        </div>
                                                                    </div>
                                                                </a>
                                                                <div class="dropdown-divider"></div>
                                                                <a href="#" class="dropdown-item">
                                                                    <div class="media">
                                                                        <i data-feather="flag"></i>
                                                                        <div class="media-content">
                                                                            <h3>Report</h3>
                                                                            <small>Report this comment.</small>
                                                                        </div>
                                                                    </div>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- /Comment -->
                                        </div>
                                        <!-- Comments body -->

                                        <!-- Comments footer -->
                                        <div class="card-footer">
                                            <div class="media post-comment has-emojis">
                                                <!-- Textarea -->
                                                <div class="media-content">
                                                    <div class="field">
                                                        <p class="control">
                                                            <textarea class="textarea comment-textarea" rows="5" placeholder="Write a comment..."></textarea>
                                                        </p>
                                                    </div>
                                                    <!-- Additional actions -->
                                                    <div class="actions">
                                                        <div class="image is-32x32">
                                                            <img class="is-rounded"
                                                                src="https://via.placeholder.com/300x300"
                                                                data-demo-src="https://friendkit.cssninja.io/assets/img/avatars/jenna.png"
                                                                data-user-popover="0" alt="" />
                                                        </div>
                                                        <div class="toolbar">
                                                            <div class="action is-auto">
                                                                <i data-feather="at-sign"></i>
                                                            </div>
                                                            <div class="action is-emoji">
                                                                <i data-feather="smile"></i>
                                                            </div>
                                                            <div class="action is-upload">
                                                                <i data-feather="camera"></i>
                                                                <input type="file" />
                                                            </div>
                                                            <a class="button is-solid primary-button raised">Post
                                                                Comment</a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- /Comments footer -->
                                    </div>
                                    <!-- /Comments -->
                                </div>
                                <!-- /Post -->
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <!-- /timeline POST #7 -->
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Profile page main wrapper -->
        </div>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('member', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\upvkss\resources\views/user/details.blade.php ENDPATH**/ ?>