<ul class="list-group">
    <li class="list-group-item list-group-color justify-content-between lh-condensed">
        <div>
            <h6 class="my-0"><a href="<?php echo e(route('binshopsblog.admin.index')); ?>">Dashboard</a>
                <span class="text-muted">(<?php
                $categoryCount = \BinshopsBlog\Models\BinshopsPost::where('user_id', auth()->user()->id)->count();

                echo $categoryCount . ' ' . str_plural('Post', $categoryCount);

                ?>)</span>
            </h6>
            <small class="text-muted">Overview of your posts</small>

            <div class="list-group ">

                <a href='<?php echo e(route('binshopsblog.admin.index')); ?>'
                    class='list-group-item list-group-color list-group-item list-group-color-action <?php if(\Request::route()->getName() === 'binshopsblog.admin.index'): ?> active <?php endif; ?>  '><i
                        class="fa fa-th fa-fw" aria-hidden="true"></i>
                    All Posts</a>
                <a href='<?php echo e(route('binshopsblog.admin.create_post')); ?>'
                    class='list-group-item list-group-color list-group-item list-group-color-action  <?php if(\Request::route()->getName() === 'binshopsblog.admin.create_post'): ?> active <?php endif; ?>  '><i
                        class="fa fa-plus fa-fw" aria-hidden="true"></i>
                    Add Post</a>
            </div>
        </div>
    </li>


    <li class="list-group-item list-group-color justify-content-between lh-condensed">
        <div>
            <h6 class="my-0"><a href="<?php echo e(route('binshopsblog.admin.comments.index')); ?>">Comments</a>

                <span class="text-muted">(<?php
                $commentCount = \BinshopsBlog\Models\BinshopsComment::withoutGlobalScopes()->count();

                echo $commentCount . ' ' . str_plural('Comment', $commentCount);

                ?>)</span>
            </h6>
            <small class="text-muted">Manage your comments</small>

            <div class="list-group ">
                <a href='<?php echo e(route('binshopsblog.admin.comments.index')); ?>'
                    class='list-group-item list-group-color list-group-item list-group-color-action  <?php if(\Request::route()->getName() === 'binshopsblog.admin.comments.index' && !\Request::get('waiting_for_approval')): ?> active <?php endif; ?>   '><i
                        class="fa  fa-fw fa-comments" aria-hidden="true"></i>
                    All Comments</a>


                <?php $userId = auth()->user()->id;

                $comment_approval_count = \BinshopsBlog\Models\BinshopsComment::withoutGlobalScopes()
                    ->whereHas('post', function ($query) use ($userId) {
                        $query->where('user_id', $userId);
                    })
                    ->count(); ?>


                <a href='<?php echo e(route('binshopsblog.admin.comments.index')); ?>?waiting_for_approval=true'
                    class='list-group-item list-group-color list-group-item list-group-color-action  <?php if(\Request::route()->getName() === 'binshopsblog.admin.comments.index' && \Request::get('waiting_for_approval')): ?> active <?php elseif($comment_approval_count > 0): ?> list-group-item list-group-color-warning <?php endif; ?>  '><i
                        class="fa  fa-fw fa-comments" aria-hidden="true"></i>
                    <?php echo e($comment_approval_count); ?>

                    Waiting for approval </a>

            </div>
        </div>
    </li>







    <?php if(config('binshopsblog.image_upload_enabled')): ?>
        <li class="list-group-item list-group-color  justify-content-between lh-condensed">
            <div>
                <h6 class="my-0"><a href="<?php echo e(route('binshopsblog.admin.images.upload')); ?>">Upload images</a></h6>

                <div class="list-group ">

                    <a href='<?php echo e(route('binshopsblog.admin.images.all')); ?>'
                        class='list-group-item list-group-color list-group-item list-group-color-action  <?php if(\Request::route()->getName() === 'binshopsblog.admin.images.all'): ?> active <?php endif; ?>  '><i
                            class="fa fa-picture-o fa-fw" aria-hidden="true"></i>
                        View All</a>

                    <a href='<?php echo e(route('binshopsblog.admin.images.upload')); ?>'
                        class='list-group-item list-group-color list-group-item list-group-color-action  <?php if(\Request::route()->getName() === 'binshopsblog.admin.images.upload'): ?> active <?php endif; ?>  '><i
                            class="fa fa-upload fa-fw" aria-hidden="true"></i>
                        Upload</a>
                </div>
            </div>
        </li>
    <?php endif; ?>
</ul>



<?php /**PATH C:\xampp\htdocs\upvkss\vendor\binshops\laravel-blog\src/Views/binshopsblog_admin/layouts/user_sidebar.blade.php ENDPATH**/ ?>