<style>
    a {
        --hover-color: #ebd9ff;
        --accent-color: #cc0404;
        --underline-thickness: 3px;
        color-scheme: light;
    }

    .container_header {
        width: 100%;
        height: 150px;
        background-color: white;

    }

    .image-container {
        position: relative;
        display: inline-block;
    }

    .image--cover {
        width: 100px;
        height: 100px;
        border-radius: 50%;
        object-fit: cover;
        object-position: center right;
        margin-top: -40px;
        border: 3px solid white;
        margin-left: 25px;
    }

    .edit-text {
        position: absolute;
        bottom: 32px;
        left: 60px;
        color: rgb(19, 19, 19);
        font-size: 20px;
        font-weight: bold;
        display: none;
    }





    .wrapper {
        height: 60%;
        font-size: 30px;
        font-weight: bold;
        color: black;
        background-color: white;
    }

    .user_head {
        height: 70%;
    }

    .edit_btn {
        float: right;
        margin-right: 30px;
        font-size: 22px;
        margin-top: 10px;
    }

    .nav_main nav {
        margin: 0;
        padding: 0;
        display: flex;
        text-transform: uppercase;
        font: bold 1.5rem sans-serif;

        & a {
            font-size: 15px;

            color: var(--text-color);
            cursor: pointer;
            overflow: hidden;
            transition: 0.3s;
            position: relative;
            text-decoration: none;
            padding: 0 0.5em 0.25em;

            &::before {
                content: "";
                scale: 0 1;
                position: absolute;
                background: var(--accent-color);
                transition: 0.3s, translate 0s 0.3s;
                inset: calc(100% - var(--underline-thickness)) 0 0 0;
            }

            &:hover {
                color: var(--hover-color);

                &::before {
                    translate: 0;
                    transition: 0.3s;
                }
            }
        }

        &:hover {
            & a::before {
                scale: 1;
            }

            & a:has(~ a:hover)::before {
                translate: 100% 0;
                transition: 0.2s 0.2s, scale 0s 0.4s;
            }

            & a:hover~a::before {
                translate: -100% 0;
                transition: 0.2s 0.2s, scale 0s 0.4s;
            }
        }
    }
</style>


<div class="container_header">
    <div class="user_head">
        <div class="wrapper">
            <div class="image-container"  id="imageContainer">
                <?php if($user->profile_photo): ?>
                    <img src="<?php echo e(asset('user/profile_photo/' . $user->profile_photo)); ?>" class="image--cover">
                <?php else: ?>
                    <img src="<?php echo e(asset('user/default_pic.jpg')); ?>" class="image--cover">
                <?php endif; ?>
                <span class="edit-text">Edit</span>
            </div>
            <?php echo e($user->name); ?> - (<?php echo e($user->designation); ?>)
            </div>

        <hr>
    </div>
    <div class="nav_main">
        <nav>
            <a href="/home">Dashboard</a>
            <a href="<?php echo e(route('users')); ?>">Members</a>
            <a href="<?php echo e(route('subscription')); ?>">Annual membership</a>
            <a href="#">Benevolent Fund</a>
            <a href="#">Payments</a>
            <a href="#">Editorial</a>
        </nav>
    </div>
</div>


<!-- Bootstrap Modal -->
<form action="<?php echo e(route('upload.image')); ?>" method="POST" enctype="multipart/form-data">
<?php echo csrf_field(); ?>
<div class="modal fade" id="uploadImageModal" tabindex="-1" aria-labelledby="uploadImageModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="uploadImageModalLabel">Upload Image</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                    <input type="file" name="image" class="form-control">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary cancel" data-bs-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Upload</button>
            </div>
        </div>
    </div>
</div>
</form>



<?php /**PATH C:\xampp\htdocs\upvkss\resources\views/user/header_userdetails.blade.php ENDPATH**/ ?>