<?php $__env->startSection('content'); ?>
    <div class="container is-custom">
        <!-- Profile page main wrapper -->
        <div id="profile-main" class="view-wrap is-headless">
            <div class="columns is-multiline no-margin">
                <!-- Left side column -->
                <div class="column is-paddingless">
                    <!-- Timeline Header -->
                    <!-- html/partials/pages/profile/timeline/timeline-header.html -->
                    <div class="cover-bg">
                        <img class="cover-image"
                            src="<?php echo e(Auth::user()->cover_image ? asset('user/cover_image/' . Auth::user()->cover_image) : asset('default-cover.jpg')); ?>"
                            alt="Cover Image" />

                        <div class="avatar">
                            <?php if(Auth::user()->profile_photo): ?>
                                <img src="<?php echo e(asset('user/profile_photo/' . Auth::user()->profile_photo)); ?>" d="user-avatar"
                                    class="avatar-image">
                            <?php else: ?>
                                <img src="<?php echo e(asset('user/default_pic.jpg')); ?>" d="user-avatar" class="avatar-image">
                            <?php endif; ?>
                            <div class="avatar-button">
                                <i data-feather="plus"></i>
                            </div>
                            <div class="pop-button is-far-left has-tooltip modal-trigger"
                                data-modal="change-profile-pic-modal" data-placement="right"
                                data-title="Change profile picture">
                                <a class="inner">
                                    <i data-feather="camera"></i>
                                </a>
                            </div>
                   
                   
                        </div>
                        <div class="cover-overlay"></div>
                        <div class="cover-edit modal-trigger" data-modal="change-cover-modal">
                            <i class="mdi mdi-camera"></i>
                            <span>Edit cover image</span>
                        </div>
                        
                        
                    </div>

                    <div class="profile-menu is-hidden-mobile">
                        <div class="menu-start">
                            <a href="<?php echo e(route('users')); ?>" class="button has-min-width">Members</a>
                            <a href="<?php echo e(route('subscription')); ?>" class="button has-min-width">Annual membership</a>
                        </div>
                        <div class="menu-end">
                            <a id="profile-friends-link" href="<?php echo e(route('b_fund')); ?>"
                                class="button has-min-width">Benevolent Fund</a>
                            <a href="/blog_admin/add_post" class="button has-min-width">Editorial</a>
                        </div>
                    </div>

                    <div class="profile-subheader">
                      
                        <div class="subheader-middle">
                            <h2><?php echo e($currentUser->name); ?></h2>
                            <span><?php echo e($currentUser->designation); ?> - <?php echo e($currentUser->current_office); ?></span>
                        </div>
                       
                    </div>
                </div>
            </div>

            <div class="columns">
                <div id="profile-timeline-widgets" class="column is-4">
                    
                    <div class="box-heading">
                        <h4>Basic Infos</h4>
                       
                    </div>

                    <div class="basic-infos-wrapper">
                        <div class="card is-profile-info">
                            <div class="info-row">
                                <div>
                                    <span>Bio</span>
                                    <a class="is-inverted"><?php echo e($currentUser->bio); ?></a>
                                </div>
                                
                            </div>
                            <div class="info-row">
                                <div>
                                    <span><i class="mdi mdi-contacts"></i>Mobile Number</span>

                                    <a class="is-inverted"> <?php echo e($currentUser->contact); ?></a>
                                </div>

                            </div>
                            <div class="info-row">
                                <div>
                                    <span> <i class="mdi mdi-email"></i>Email</span>
                                    <a class="is-inverted"><?php echo e($currentUser->email); ?></a>
                                </div>

                            </div>
                            <div class="info-row">
                                <div>
                                    <span><i class="mdi mdi-home"></i>Place of Posting</span>
                                    <a class="is-inverted"><?php echo e($currentUser->posting_area); ?></a>
                                </div>

                            </div>

                            <?php if($currentUser->contact_privacy === 1): ?>
                                <div class="info-row">
                                    <div>
                                        <span>Contact</span>
                                        <a class="is-muted"><?php echo e($currentUser->contact); ?></a>
                                    </div>
                                    <i class="mdi mdi-contacts"></i>
                                </div>
                            <?php endif; ?>
							
							
                        </div>
                    </div>

                   
                   
                    <!-- Trips widget -->
                    <!-- html/partials/pages/profile/timeline/widgets/trips-widget.html -->
                   

                    <!-- Schedule calendar widget -->
                    <!-- html/partials/widgets/schedule/schedule-widget.html -->
                 
                </div>

                <div class="column is-8">

                    <!--  -->
                    <div class="membership-fee flex-div">
                        <div class="membership">
                            <h2><i class="fa fa-handshake-o"></i> MEMBERSHIP FEE</h2>
                            <p class="amount-text">Amount: <span>₹2000.00</span></p>
                            <p class="status-text">STATUS</p>
                            <?php if($annualStatus === 1): ?>
                                <h4 class="paid_text">PAID</h4>
                                <div class="payment-text">Paid</div>
                            <?php elseif($annualStatus === 2): ?>
                                <h4 class="paid_text">Waiting for approval</h4>
                                <div class="payment-text">Waiting for approval</div>
                            <?php elseif($annualStatus === 3): ?>
                                <h4 class="paid_text">Failed</h4>
                                <a class="payment-text" href="<?php echo e(route('subscription')); ?>">Pay again</a>
                            <?php else: ?>
                                <h4 class="paid_text"><span>DUE</span></h4>
                                <a class="payment-text" href="<?php echo e(route('subscription')); ?>">Make Payment</a>
                            <?php endif; ?>
                        </div>
                        <div class="membership">
                            <h2><i class="fa fa-handshake-o"></i> BENEVOLENT FUND</h2>
                            <p class="amount-text">Amount: <span>₹20000.00</span></p>
                            <p class="status-text">STATUS</p>

                            <?php if($bFundStatus === 1): ?>
                                <h4 class="paid_text">PAID</h4>
                                <div class="payment-text">Paid</div>
                            <?php elseif($bFundStatus === 2): ?>
                                <h4 class="paid_text">Waiting for approval</h4>
                                <div class="payment-text">Waiting for approval</div>
                            <?php elseif($bFundStatus === 3): ?>
                                <h4 class="paid_text">Failed</h4>
                                <a class="payment-text" href="<?php echo e(route('b_fund')); ?>">Pay again</a>
                            <?php else: ?>
                                <h4 class="paid_text"><span>DUE</span></h4>
                                <a class="payment-text" href="<?php echo e(route('b_fund')); ?>">Make Payment</a>
                            <?php endif; ?>
                        </div>

                    </div>
                    <!--=========== birthday start =================-->

                     <div class="main-section">
                        <h3 class="birthday-text">Birthday this month</h3>
                        <div class="profile-sec">

                            <?php $__currentLoopData = $birthdays; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $birthday): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="profile-main">
                                    <div class="profile-img">

                                        <?php if($birthday->profile_photo): ?>
                                            <img src="<?php echo e(asset('user/profile_photo/' . $birthday->profile_photo)); ?>"
                                                d="user-avatar" class="avatar-image">
                                        <?php else: ?>
                                            <img src="<?php echo e(asset('user/default_pic.jpg')); ?>" d="user-avatar"
                                                class="avatar-image">
                                        <?php endif; ?>

                                    </div>
                                    <div class="profile-bg">
                                        <h3 class="date-text"><?php echo e($birthday->date_of_birth); ?></h3>
                                        <h4 class="profile-text"><?php echo e($birthday->name); ?></h4>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                        </div>
                    </div>
                    <!--=========== birthday end =================-->
                    <!--=========== retirement start ============ -->
                    <div class="main-section">
                        <h3 class="birthday-text">Retirement this month</h3>
                        <div class="profile-sec">

                            <?php $__currentLoopData = $anniversaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="profile-main">
                                           <div class="profile-img">

                                        <?php if($user->profile_photo): ?>
                                            <img src="<?php echo e(asset('user/profile_photo/' . $user->profile_photo)); ?>"
                                                d="user-avatar" class="avatar-image">
                                        <?php else: ?>
                                            <img src="<?php echo e(asset('user/default_pic.jpg')); ?>" d="user-avatar"
                                                class="avatar-image">
                                        <?php endif; ?>

                                    </div>
                                    <div class="profile-bg">
                                        <h3 class="date-text"><?php echo e($user->marriage_anniversary); ?></h3>
                                        <h4 class="profile-text"><?php echo e($user->name); ?></h4>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>




                        </div>
                        <!--=========== retirement end ============ -->
                        <div id="profile-timeline-posts" class="box-heading">
                            <h4>Posts</h4>
                           
                        </div>
                        <div class="profile-timeline">
                            
                            
                            <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="profile-post">

                                  
                                    <!-- Post -->
                                    <div class="card is-post">
                                        <!-- Main wrap -->
                                        <div class="content-wrap">
                                            <!-- Header -->
                                            <div class="card-heading">
                                                <div class="user-block">
                                                    <div class="image">
                                                        <img src="https://via.placeholder.com/300x300"
                                                            data-demo-src="<?php echo e(asset('user/profile_photo/' . $post->user->profile_photo)); ?>"
                                                            onerror="this.onerror=null; this.src='<?php echo e(asset('user/default_pic.jpg')); ?>'"
                                                            alt="User Profile Photo" width="300" height="300"
                                                            data-user-popover="0">
                                                    </div>
                                                    <div class="user-info">
                                                        <a href="#"><?php echo e($post->post->author->name); ?></a>
                                                        <?php
                                                            $posted_at = \Carbon\Carbon::parse($post->posted_at);
                                                        ?>
                                                        <span class="time"><?php echo e($posted_at->format('F j Y, g:ia')); ?>

                                                        </span>
                                                    </div>
                                                </div>

                                              
                                            </div>
                                            <!-- /Header -->

                                            <!-- Post body -->
                                            <div class="card-body">
                                                <!-- Post body text -->
                                                <div class="post-text">
                                                    <p>
                                                        <?php echo e($post->title); ?>

                                                    </p>

                                                    <p></p>
                                                </div>
                                                <!-- Featured image -->

                                                <div class="post-image">
                                                    <a data-fancybox="profile-post1" data-lightbox-type="comments"
                                                        data-thumb="<?php echo e($post->image_url); ?>"
                                                        href="https://via.placeholder.com/1600x900"
                                                        data-demo-href="<?php echo e($post->image_url); ?>">
                                                        <img src="https://via.placeholder.com/1600x900"
                                                            data-demo-src="<?php echo e($post->image_url); ?>" alt="" />
                                                    </a>
                                                    

                                                    <!-- Post actions -->
                                                  

                                                   

                                                    
                                                </div>
                                            </div>
                                            <!-- /Post body -->

                                            <!-- Post footer -->
                                          
                                            <!-- /Post footer -->
                                        </div>
                                        <!-- /Main wrap -->

                                        <!-- Comments -->
                                        
                                        <!-- /Comments -->
                                    </div>
                                    <!-- /Post -->
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Profile page main wrapper -->
        </div>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('member', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/vhosts/upgstsa.com/app.upgstsa.com/resources/views/user/dashboard.blade.php ENDPATH**/ ?>