<?php $__env->startSection('title', 'Payment Details'); ?>

<?php $__env->startSection('content'); ?>
    <style>
        .profile_img img {
            max-width: 150px;
        }

        .card-body h3,
        .card-body h4 {
            font-weight: bold;
        }

        .details-card .card-body div {
            margin-bottom: 1rem;
        }

        .details-card .card-body strong {
            display: inline-block;
            min-width: 150px;
        }

        .actions {
            text-align: center;
        }

        .actions .btn {
            margin: 0 0.5rem;
        }

        .row-equal-height {
            display: flex;
            flex-wrap: wrap;
        }

        .row-equal-height .col-md-4,
        .row-equal-height .col-md-8 {
            display: flex;
            align-items: stretch;
        }

        .row-equal-height .card {
            flex: 1;
        }
    </style>

    <div class="container mt-5">
        <!-- User Details -->
        <div class="row-equal-height mb-4">
            <div class="col-md-4 text-center">
                <div class="card">
                    <div class="card-body">
                        <div class="profile_img mb-3">
                            <?php if($payment->user->profile_photo): ?>
                                <img src="<?php echo e(asset('user/profile_photo/' . $payment->user->profile_photo)); ?>"
                                    class="img-fluid rounded-circle">
                            <?php else: ?>
                                <img src="<?php echo e(asset('user/default_pic.jpg')); ?>" class="img-fluid rounded-circle">
                            <?php endif; ?>
                        </div>
                        <h3><?php echo e($payment->user->name); ?></h3>
                        <p><strong>Email:</strong> <?php echo e($payment->user->email); ?></p>
                        <p><strong>Designation:</strong> <?php echo e($payment->user->designation); ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-8">
                <div class="card">
                    <div class="card-body">
                        <h4>User Information</h4>
                        <p><strong>Employee ID:</strong> <?php echo e($payment->user->employee_id); ?></p>
                        <p><strong>User Name:</strong> <?php echo e($payment->user->name); ?></p>
                        <form action="<?php echo e(route('sub.receipt')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <input type="text" name="employee_id" value="<?php echo e($payment->user->employee_id); ?>" hidden>
                            <?php if($payment->status === 'success'): ?>
                                <button type="submit" class="btn btn-success">view receipt</button>
                            <?php endif; ?>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Payment Details -->
        <h1 class="mb-4">Payment Details</h1>

        <div class="card details-card mb-4">
            <div class="card-body">
                <?php if($payment->payment_type === 'offline'): ?>
                    <div>
                        <strong>Receipt:</strong>
                        <?php if(empty($payment->receipt_document)): ?>
                            <?php echo e('null'); ?>

                        <?php elseif(pathinfo($payment->receipt_document, PATHINFO_EXTENSION) === 'pdf'): ?>
                            <a href="<?php echo e(asset($payment->receipt_document)); ?>" target="_blank" class="btn btn-primary">View
                                Document</a>
                        <?php else: ?>
                            <a href="<?php echo e(asset($payment->receipt_document)); ?>" target="_blank">
                                <img src="<?php echo e(asset($payment->receipt_document)); ?>" alt="Receipt Document"
                                    style="max-width: 150px;">
                            </a>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>

                <div><strong>ID:</strong> <?php echo e($payment->id); ?></div>
                <div><strong>Package Name:</strong> <?php echo e($payment->package_name); ?></div>
                <div><strong>Payment Type:</strong> <?php echo e($payment->payment_type); ?></div>

                <?php if($payment->payment_type === 'offline'): ?>
                    <?php if($payment->package_name === 'Annual Subscription'): ?>
                        <div><strong>Receipt Number:</strong> <?php echo e($payment->main_receipt_id); ?></div>
                    <?php else: ?>
                        <div><strong>Cheque Number:</strong> <?php echo e($payment->cheque_number); ?></div>
                        
                    <?php endif; ?>
                <?php endif; ?>

                <?php if($payment->payment_type === 'online'): ?>
                    <div><strong>Razorpay ID:</strong> <?php echo e($payment->razorpay_id); ?></div>
                <?php endif; ?>

                <div><strong>Payment Status:</strong> <?php echo e($payment->payment_status); ?></div>
                <div><strong>Amount:</strong> <?php echo e($payment->amount); ?></div>
                <div><strong>Date:</strong> <?php echo e($payment->created_at); ?></div>
            </div>
        </div>

        <?php if($payment->payment_status === 'pending approval'): ?>
            <!-- Approve and Disapprove Buttons -->
            <div class="actions mt-4">
                <?php if($payment->package_name === 'Annual Subscription'): ?>
                    <form action="<?php echo e(route('sub.payments.approve', $payment->id)); ?>" method="POST"
                        style="display: inline;">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PATCH'); ?>
                        <button type="submit" class="btn btn-success">Approve</button>
                    </form>

                    <form action="<?php echo e(route('subadmin.payments.disapprove', $payment->id)); ?>" method="POST"
                        style="display: inline;">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PATCH'); ?>
                        <button type="submit" class="btn btn-danger">Disapprove</button>
                    </form>
                <?php else: ?>
                    <form action="<?php echo e(route('sub.payments.approvebfund', $payment->id)); ?>" method="POST"
                        style="display: inline;">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PATCH'); ?>
                        <button type="submit" class="btn btn-success">Approve</button>
                    </form>

                    <form action="<?php echo e(route('subadmin.payments.disapprovebfund', $payment->id)); ?>" method="POST"
                        style="display: inline;">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PATCH'); ?>
                        <button type="submit" class="btn btn-danger">Disapprove</button>
                    </form>
                <?php endif; ?>

            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('sub-admin.layout.subadmin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/vhosts/upgstsa.com/app.upgstsa.com/resources/views/sub-admin/payment_show.blade.php ENDPATH**/ ?>