<?php $__env->startSection('blog-custom-css'); ?>
    <link type="text/css" href="<?php echo e(asset('binshops-blog.css')); ?>" rel="stylesheet">
<?php $__env->stopSection(); ?>

<?php $__env->startSection("content"); ?>

    <div class='col-sm-12 binshopsblog_container'>
        <?php if(\Auth::check() && \Auth::user()->canManageBinshopsBlogPosts()): ?>
            <div class="text-center">
                <p class='mb-1'>You are logged in as a blog admin user.
                    <br>
                    <a href='<?php echo e(route("binshopsblog.admin.index")); ?>'
                       class='btn border  btn-outline-primary btn-sm '>
                        <i class="fa fa-cogs" aria-hidden="true"></i>
                        Go To Blog Admin Panel</a>
                </p>
            </div>
        <?php endif; ?>

        <div class="row">
            <div class="col-md-9">

                <?php if($category_chain): ?>
                    <div class="container">
                        <div class="row">
                            <div class="col-md-12">
                                <?php $__empty_1 = true; $__currentLoopData = $category_chain; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    / <a href="<?php echo e($cat->categoryTranslations[0]->url($locale)); ?>">
                                        <span class="cat1"><?php echo e($cat->categoryTranslations[0]['category_name']); ?></span>
                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?> <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if(isset($binshopsblog_category) && $binshopsblog_category): ?>
                    <h2 class='text-center'> <?php echo e($binshopsblog_category->category_name); ?></h2>

                    <?php if($binshopsblog_category->category_description): ?>
                        <p class='text-center'><?php echo e($binshopsblog_category->category_description); ?></p>
                    <?php endif; ?>

                <?php endif; ?>

                <div class="container">
                    <div class="row">
                        <?php $__empty_1 = true; $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php echo $__env->make("binshopsblog::partials.index_loop", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="col-md-12">
                                <div class='alert alert-danger'>No posts!</div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <h6>Blog Categories</h6>
                <ul class="binshops-cat-hierarchy">
                    <?php if($categories): ?>
                        <?php echo $__env->make("binshopsblog::partials._category_partial", [
              'category_tree' => $categories,
                'name_chain' => $nameChain = "",
                'routeWithoutLocale' => $routeWithoutLocale
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php else: ?>
                        <span>No Categories</span>
                    <?php endif; ?>
                </ul>
            </div>
        </div>

        <?php if(config('binshopsblog.search.search_enabled') ): ?>
            <?php echo $__env->make('binshopsblog::sitewide.search_form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        <div class="row">
            <div class="col-md-12 text-center">
                <?php $__currentLoopData = $lang_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e(route("binshopsblog.index" , $lang->locale)); ?>">
                        <span><?php echo e($lang->name); ?></span>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.app",['title'=>$title], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\upvkss\resources\views/vendor/binshopsblog/index.blade.php ENDPATH**/ ?>