<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <meta http-equiv="x-ua-compatible" content="ie=edge" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo $__env->yieldContent('title'); ?></title>
    <!--  -->

    <!--  -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="icon" type="image/png" href="https://friendkit.cssninja.io/assets/img/favicon.png" />



    <!-- Google Tag Manager -->
    <script>
        var uploadImageCoverRoute = "<?php echo e(route('upload.image_cover')); ?>";
        var uploadImageProfileRoute = "<?php echo e(route('upload.image')); ?>";;
        (function(w, d, s, l, i) {
            w[l] = w[l] || []
            w[l].push({
                'gtm.start': new Date().getTime(),
                event: 'gtm.js'
            })
            var f = d.getElementsByTagName(s)[0],
                j = d.createElement(s),
                dl = l != 'dataLayer' ? '&l=' + l : ''
            j.async = true
            j.src = 'https://www.googletagmanager.com/gtm.js?id=' + i + dl
            f.parentNode.insertBefore(j, f)
        })(window, document, 'script', 'dataLayer', 'GTM-KQHJPZP')
    </script>
    <!-- End Google Tag Manager -->

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Montserrat:600,700,800,900" rel="stylesheet" />
    <link href="https://fonts.googleapis.com/css?family=Roboto:400,500" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/fontisto@v3.0.4/css/fontisto/fontisto-brands.min.css" rel="stylesheet" />
    <!-- Core CSS -->


    <link rel="stylesheet" href="/assets/css/app.css" />
    <link rel="stylesheet" href="/assets/css/core.css" />

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <?php echo $__env->yieldPushContent('head-code'); ?>

</head>
<style>
    .navbar-v1 {
        height: 115px;
    }

    .navbar>.container .navbar-menu,
    .container>.navbar .navbar-menu {
        justify-content: space-between;
    }

    .profile-menu .button {
        text-decoration: none !important;
    }

    .navbar-v1 .navbar-brand .navbar-item .logo {
        max-height: 90px !important;
        max-width: 90px !important;
    }

    .navbar-v1 .navbar-brand .navbar-item {
        height: 90px !important;
        max-width: 90px !important;
    }

    .navbar-v1 .navbar-brand {
        height: 90px;
    }

    .basic-infos-wrapper .is-profile-info .info-row a {
        text-decoration: none;
    }

    .box-heading {
        background: #00315b;
        color: #fff;
    }

    .box-heading h4 {
        font-size: 20px;
        margin: 0;
    }

    .box-heading {
        padding: 10px;
    }

    .profile-subheader .subheader-middle {
        width: 100%;
    }

    .membership-fee {
        width: 100%;
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin: 12px 0px;
        border-radius: 4px;
        overflow: hidden;

    }

    .membership {
        width: 48%;
        padding: 20px 15px 20px 15px;
        transition: 1s;
        background: #fff;
        border: solid 1px #000;
        border-radius: 5px;

    }

    .membership h2 {
        font-size: 20px;
        font-weight: 600;
        text-align: left;
        display: flex;
        color: #02315a;
        align-items: center;
    }

    .membership i {
        width: 50px;
        height: 50px;
        background: #fff;
        border-radius: 100%;
        box-shadow: 0px 0px 1px 1px #6b6464;
        text-align: center;
        line-height: 50px;
        color: #02315a;
        margin-right: 20px;
    }

    .amount-text {
        text-align: left;
        font-size: 20px;
        font-weight: 600;
        border-radius: 3px;
        color: #02315a;
        margin-bottom: 10px;
    }

    .amount-text span {
        font-size: 30px;
    }

    .status-text {
        font-size: 14px;
        font-weight: 700;
        margin: 0;
        color: #02315a;
    }

    .membership h4 {
        font-size: 20px;
        text-align: left;
        margin: 0;
        border-radius: 3px;
        color: #ff0000;
        font-weight: 700;
    }

    .payment-text {
        width: 100%;
        font-size: 18px;
        color: #ffffff;
        text-decoration: none;
        display: block;
        background: #000000;
        margin-top: 10px;
        padding: 10px;
        font-weight: 600;
        border: solid 1px #000;
        filter: drop-shadow(2px 4px 6px black);
        border-radius: 3px;
        text-align: center;
    }

    .payment-text:hover {
        color: #000000;
        background: #e0e0e0;
        border: solid 1px #000;
        filter: unset;
    }

    .view-wrapper {
        padding: 0 !important;
    }

    .navbar-v1.no-shadow {
        background: #00315b;
    }

    .view-wrapper .view-wrap.is-headless {
        padding-top: 0 !important;
    }

    .navbar-item.is-account {
        padding: 0;
    }

    .navbar-v1 .navbar-item {
        padding: 0;
    }

    .navbar-v1 .navbar-brand {
        margin-right: 0;
    }

    .navbar-v1 .control .input {
        width: 500px !important;
    }

    .basic-infos-wrapper .is-profile-info .info-row span {
        font-size: 18px;
        font-weight: 700;
        color: #393a4f;
        display: flex;
    }

    .basic-infos-wrapper .is-profile-info .info-row i {
        margin: 0 4px 0 0;
    }

    .basic-infos-wrapper .is-profile-info .info-row a {
        font-size: 20px;
        font-weight: 400;
        color: #000;
    }

    .profile-menu .button.has-min-width {
        width: 155px;
        background: #00315b;
        color: #fff;
        transition: 0.5s;
        font-weight: 700;
    }

    .profile-menu .button.has-min-width:hover {
        background: #4b6072;
    }

    .profile-subheader {
        padding: 20px 0;
    }

    .profile-subheader .subheader-middle h2 {
        font-size: 24px;
        font-weight: 700;
        color: #393a4f;
        line-height: 1.2;
        margin: 0;
    }

    .profile-subheader .subheader-middle span {
        display: block;
        font-size: 22px;
        color: #393a4f;
    }

    /*  */
    .birthday-text {
        font-size: 20px;
        background: #00315b;
        color: #fff;
        width: 100%;
        padding: 10px 10px;
        border-radius: .75rem;
        border: 1px solid #e8e8e8;
    }

    .home-demo .item {
        background: #ff3f4d;
    }

    .home-demo h2 {
        color: #FFF;
        text-align: center;
        padding: 5rem 0;
        margin: 0;
        font-style: italic;
        font-weight: 300;
    }

    .profile-sec {
        width: 100%;
        display: flex;
        justify-content: space-between;
        margin-bottom: 15px;
    }

    .profile-main {
        width: 24%;
        border: solid 2px #0084f7;
        border-radius: 3px;
        overflow: hidden;
    }

    .profile-img img {
        width: 100%;
    }

    .date-text {
        text-align: center;
        margin: 10px 0 0 0;
        font-size: 16px;
        font-weight: 700;
    }

    .profile-text {
        text-align: center;
        margin: 5px 0 0px 0px;
        font-size: 16px;
        font-weight: 700;

    }

    .profile-bg {
        width: 100%;
        background: aliceblue;
        padding: 5px 0px;
        border-radius: 1px;
        margin-top: 15px;
        filter: drop-shadow(0px 1px 3px #000);
        color: #00315b;
    }

    .dirextry-text {
        font-size: 26px;
        font-weight: 600;
        margin: 0;
        color: #000;
        text-align: center;
        margin: 30px 0 20px 0;
    }

    .search_form {
        display: flex;
        justify-content: center;
        margin-bottom: 50px;
    }

    .search-btn {
        margin-left: 20px;
        width: 250px;
        border: none;
        color: #fff;
        background: #0d6efd;
        height: 50px;
        border-radius: 5px;
        font-size: 20px;
        font-weight: 600;
    }

    .search-btn i {
        margin-right: 10px;
    }

    .select-bar {
        height: 48px;
        width: 250px;
        padding: 3px;
        border: solid 2px #000;
        border-radius: 3px;
    }

    .select-bar option,
    .design-bar option {
        font-size: 20px;

    }

    .design-bar {
        height: 48px;
        width: 350px;
        padding: 3px;
        margin-left: 15px;
        border: solid 2px #000;
        border-radius: 3px;
    }

    .table th {
        background: #00315b;
        color: #fff !important;
        border-radius: 0px;
        border: solid 4px #fff !important;
        margin: 0px 0px 0px;
        filter: drop-shadow(2px 3px 3px #000);
        height: 50px;
        text-align: center !important;
    }

    .hover td {
        font-size: 17px;
        border: solid 1px #b7b7b7;
    }

    .more_btn {
        width: 75px;
        height: 40px;
        background: #00315b;
        display: block;
        text-align: center;
        text-decoration: none;
        line-height: 37px;
        color: #fff;
        font-weight: 600;
        border-radius: 3px;
        filter: drop-shadow(1px 3px 2px #000);
    }

    /*  */
    .container-main {
        max-width: 992px;
        width: 100%;

    }

    .member-section {
        display: flex;
        justify-content: space-between;
        padding-top: 2.5vw;
    }

    .member-logo {
        width: 16%;
    }

    .member-logo img {
        width: 100%;
    }

    .member-text {
        text-align: center;
    }

    .member-text p {
        font-size: 2.8vw;
        font-weight: 600;
        color: #000;
        margin: 0;
        text-align: center;
    }

    .member-text h2 {
        font-size: 2.5vw;
        font-weight: 600;
        color: #000;
    }

    .member-text h3 {
        font-size: 2.5vw;
        font-weight: 800;
        color: #000;
    }

    .member-text h4 {
        font-size: 1.5vw;
        font-weight: 600;
        color: #000;
    }

    .mamber-scan {
        width: 19%;
    }

    .scan-logo {
        width: 100%;
        max-width: 146px;
    }

    .scan-logo img {
        width: 100%;
    }

    .member_date ul {
        display: flex;
        padding: 0;
        font-weight: 700;
    }

    .member_date li {
        margin-right: 10px;
        font-size: 1.5vw;
    }

    /*  */
    /*  */
    .fees-text {
        text-align: center;
        font-size: 28px;
    }

    .data-text {
        margin-top: 40px;
    }

    .data-text p {
        font-size: 1.5vw;
        font-weight: 600;
    }

    .data-text span {
        font-weight: 700;
    }

    .employee_text {
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        list-style: none;
        margin: 0;
        padding: 0;
    }

    .employee_text li {
        font-size: 1.5vw;
        width: 50%;
        font-weight: 600;
        margin-bottom: 10px;
    }

    .employee_text li a {
        text-decoration: none;
        color: #000;
    }

    .amount_text {
        margin-top: 15px;
    }

    .amount_text ul {
        display: flex;
        list-style: none;
        margin: 0;
        padding: 0;
    }

    .amount_text li {
        width: 120px;
        border: solid 1px #000;
        font-weight: 600;
        line-height: 34px;
        font-size: 1.6vw;
        text-align: center;
    }

    .amount_text ul li:nth-child(2) {
        font-size: 1.6vw;
        font-weight: 700;
    }

    .amount_text h4 {
        font-size: 1.8vw;
        font-weight: 600;
        color: #000;
        margin: 0px 0px 0px 10px;
    }

    .payment-sec {
        display: flex;
        justify-content: space-between;

    }

    .mode-text {
        width: 50%;
        margin-top: 10px;

    }

    .mode-text ul {
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        list-style: none;
        margin: 0;
        padding: 0;
        margin-top: 10px;
    }

    .mode-text li {
        width: 50%;
        font-size: 20px;
        font-weight: 600;
    }

    .online-text p {
        font-size: 1.6vw;
        font-weight: 600;
        color: #000;
        margin: 0;
        text-align: center;
    }

    .online-text h4 {
        font-size: 14px;
        font-weight: 600;
        text-align: right;
    }

    .online-text {
        margin-top: 40px;
    }

    .make-payment {
        width: 100%;
        max-width: 522px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin: 15px 0px;
    }

    .make-payment p {
        font-size: 1.5vw;
        font-weight: 700;
        margin: 0;
    }

    .online-btn,
    .ofline-btn {
        font-size: 1.5vw;
        text-decoration: none;
        width: 170px;
        height: 48px;
        padding: 10px 0px;
        background: #00315b;
        text-align: center;
        color: #fff;
        font-weight: 700;
        filter: drop-shadow(0px 3px 2px #000);
        border: solid 1px #00315b;
        border-radius: 3px;
        overflow: hidden;
    }

    .online-btn:hover {
        color: #00315b;
        border: solid 1px #00315b;
        background: #f0f0f0;
        filter: unset;
    }

    .ofline-btn:hover {
        color: #00315b;
        border: solid 1px #00315b;
        background: #f0f0f0;
        filter: unset;
    }

    .breadcrumb {
        justify-content: center;
        font-weight: 600;
    }

    .breadcrumb li a {
        text-decoration: none;
        font-size: 20px;
        color: #00315b;
    }

    .breadcrumb li {
        font-size: 20px;
        color: #00315b;
    }

    .breadcrumb li+li::before {
        color: #00315b;
        margin-right: 12px;
    }

    .directory-sec {
        margin: 50px 0px;
    }

    .search-button {
        height: 48px;
        width: 250px;
        border: solid 2px #000;
        border-radius: 3px;
        margin: 20px 0px;
        padding: 7px;

    }

    /*  */
    /* =============== */
    .navbar-item .nav-drop .inner .nav-drop-header span.username,
    .navbar-item .nav-drop .inner .nav-drop-header a.username {
        font-weight: 700 !important;
        color: #000000;
        font-size: 14px;
    }

    .form-group {
        margin: 15px 0px 0 0;
    }

    .form-group label {
        margin-bottom: 5px;
    }

    .form-main {
        display: flex;
        flex-direction: column;
    }

    .quantity-text {
        font-weight: 600;
        font-size: 15px;
        margin-bottom: 5px;
    }

    .name-text {
        width: 100%;
        height: 38px;
        font-size: 18px;
        outline-color: #347ab654;
        border-radius: 4px;
        padding: 8px;
    }

    .information-section {
        border: solid 1px #347ab6;
        border-radius: 6px;
        overflow: hidden;
        margin-top: 25px;
    }

    .information-text {
        font-size: 20px;
        font-weight: 600;
        margin: 0;
        width: 100%;
        background: #347ab6;
        color: #fff;

        padding: 10px;
    }

    .form_sec {
        padding: 15px 10px;
    }

    .form-main input {
        height: 38px;
        font-size: 18px;
        outline-color: #347ab654;
        border-radius: 4px;
        padding: 8px;
    }

    .input-row {
        margin: 20px 0px;
    }

    .button-sec {
        display: flex;
        justify-content: space-between;
        align-items: center;
        width: 100%;
        max-width: 350px;
        margin: 30px auto 0px;
    }

    .edit_btn,
    .update_btn {
        font-size: 18px;
        font-weight: 600;
        text-decoration: none;
        color: #fff;
        background: #00315b;
        width: 150px;
        padding: 7px;
        display: block;
        text-align: center;
        border-radius: 5px;
        border: solid 2px #00315d;
        filter: drop-shadow(1px 2px 2px #000);
    }

    .edit_btn:hover {
        background: #e2e2e2;
        transition: 0.5s;
        filter: unset;
        color: #00315b;
    }

    .update_btn:hover {
        background: #e2e2e2;
        transition: 0.5s;
        filter: unset;
        color: #00315b;
    }

    .cuurrent_form {
        margin-top: 20px;
    }

    .input_password {
        width: 100%;
        max-width: 450px;
    }

    .change-btn {
        width: 200px;
    }

    .bio-text a {
        text-decoration: none;
        font-size: 20px;
        font-weight: 500;
        color: #00315b;
    }

    .bio-text span {
        text-decoration: none;
        font-size: 20px;
        font-weight: 500;
        color: #00315b;
    }

    .bio-section {
        padding: 10px;
    }

    .pad0 {
        padding: 0;
    }

    /* =============== */
    /*  */
    @media screen and (max-width:1200px) {
        .member-text p {
            font-size: 32px;
        }

        .member-text h2 {
            font-size: 26px;
        }

        .member-text h3 {
            font-size: 26px;
        }

        .member-text h4 {
            font-size: 14px;
        }

        .mamber-scan {
            width: 20%;
        }

        .payment-text li {
            font-size: 1vw;
        }
    }

    @media screen and (max-width:992px) {
        .member-logo {
            width: 10%;
        }

        .member-text p {
            font-size: 26px;
        }

        .member-text h2 {
            font-size: 20px;
        }

        .member-text h4 {
            font-size: 13px;
        }

        .mamber-scan {
            width: 26%;
        }
    }

    @media screen and (max-width:926px) {
        .container {
            max-width: 100%;
        }

        .data-text p {
            margin-bottom: 5px;
        }

        .employee_text {
            margin: 5px 0px;
        }
    }

    @media screen and (max-width:768px) {
        .member-text p {
            font-size: 20px;
        }

        .member-text h2 {
            font-size: 18px;
        }

        .member-text h3 {
            font-size: 20px;
        }

        .member-text h4 {
            font-size: 13px;
        }

        .mamber-scan {
            width: 33%;
        }

        .scan-logo {
            max-width: 80px;
            margin: 0 auto 5px;
        }

        .member_date form {
            font-size: 14px;
        }
    }

    @media screen and (max-width:767px) {
        .member_date form {
            font-size: 2vw;
        }

        .employee_text li {
            font-size: 13px;
        }

        .payment-text li {
            width: unset;
            font-size: 8px;
        }

        .online-text h4 {
            font-size: 9px;
        }

        .online-text p {
            font-size: 16px;
        }

        .amount_text li {
            font-size: 2vw;
        }
    }

    @media screen and (max-width:575px) {
        .member-text p {
            font-size: 16px;
        }

        .member-text h2 {
            font-size: 16px;
        }

        .member-text h3 {
            font-size: 16px;
        }

        .member-text h4 {
            font-size: 12px;
        }

        .mamber-scan {
            width: 35%;
        }

        .scan-logo {
            max-width: 68px;
            margin: 0 auto 5px;
        }

        .member_date form {
            font-size: 14px;
        }

        .employee_text li {
            font-size: 2.4vw;
        }

        .data-text p {
            font-family: monospace;
            font-size: 16px;
            font-weight: 600;
            margin-top: 20px;
        }

        .amount_text h4 {
            font-size: 14px;
        }

        .online-text h4 {
            font-size: 2vw;
        }

        .online-text p {
            font-size: 3vw;
        }
    }

    @media screen and (max-width:475px) {
        .member-text p {
            font-size: 3vw;
        }

        .member-text h2 {
            font-size: 3vw;
        }

        .member-text h3 {
            font-size: 3vw;
            margin-bottom: 5px;
        }

        .member-text h4 {
            font-size: 2.3vw;
        }

        .member_date form {
            font-size: 2.5vw;
        }

        .member_date input {
            font-size: 2.5vw;
        }

        .scan-logo {
            max-width: 40px;
        }

        .member-logo {
            width: 12%;
        }

        .employee_text li {
            font-size: 2.3vw;
        }

        .employee_text span {
            font-weight: 700;
        }

        .amount_text li {
            font-size: 12px;
        }

        .amount_text h4 {
            font-size: 3.2vw;
        }

        .payment-text li {
            font-size: 7px;
        }

        .online-text h4 {
            font-size: 1.8vw;
        }

        .amount_text li {
            font-size: 12px;
            width: 68px;
        }
    }

    .data_text p {
        font-size: 1.5vw;
        font-weight: 600;
    }

    .employee-text {
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        list-style: none;
        margin: 0;
        background: #fff;
        border: 1px solid #e0e0e0;
        padding: 8px;
        border-radius: 3px;
        filter: drop-shadow(0px 1px 1px #e0e0e0);
    }

    .employee-text li {
        font-size: 1.5vw;
        width: 48%;
        font-weight: 600;
        margin-bottom: 10px;
    }

    .employee-text li:nth-child(1) {
        border-right: solid 1px #727272;
    }

    .employee-text li:nth-child(3) {
        border-right: solid 1px #727272;
    }

    .employee-text li:nth-child(5) {
        border-right: solid 1px #727272;
    }

    .data_text span {
        font-weight: 700;
    }

    .employee-text li a {
        text-decoration: none;
        color: #000;
    }

    .shiping-sec {
        padding: 20px;
        border: 1px solid #e0e0e0;
        border-radius: 5px;
        filter: drop-shadow(0px 1px 1px #e0e0e0);
        display: flex;
        flex-direction: column;
        justify-content: center;
        text-align: center;
        height: 180px;

    }

    .shiping-sec i {
        width: 50px;
        height: 50px;
        background: #fff;
        border-radius: 100%;
        box-shadow: 0px 0px 1px 1px #6b6464;
        text-align: center;
        line-height: 50px;
        color: #02315a;
        margin: 0 auto;
    }

    .shiping-sec p {
        font-size: 20px;
        font-weight: 600;
    }

    .subtotal-sec {
        margin-top: 40px;
        padding: 20px;
        border: 1px solid #e0e0e0;
        border-radius: 5px;
        filter: drop-shadow(0px 1px 1px #e0e0e0);
        display: flex;
        flex-direction: column;
        justify-content: center;
        text-align: center;
    }

    .order-line {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 12px;
    }

    .sub-text {
        font-size: 18px;
        font-weight: 600;
        color: #999;
    }

    .price-text {
        font-size: 18px;
        font-weight: 600;
        color: #000000;
    }

    .continue_btn,
    .razorpay-payment-button {
        width: 305px;
        font-size: 18px;
        font-weight: 600;
        text-decoration: none;
        color: #fff;
        background: #00315b;
        padding: 7px;
        display: block;
        text-align: center;
        border-radius: 5px;
        border: solid 2px #00315d;
        text-decoration: none;
    }

    .continue_btn:hover {
        width: 100%;
        background: #e2e2e2;
        transition: 0.5s;
        filter: unset;
        color: #00315b;
        text-decoration: none;
    }

    .container_rule {
        margin-top: 70px !important;
    }

    .accordion {
        background-color: #eee;
        cursor: pointer;
        width: 100%;
        transition: 0.4s;
    }

    .active,
    .accordion:hover {
        background-color: #ccc;
    }

    .panel {
        padding: 0 18px;
        background-color: white;
        overflow: hidden;
        max-height: 0;
        transition: max-height 0.3s ease-out;
        /* Adjust the duration (0.8s) as needed */
    }

    .padding_css_style {
        padding-block: 20px;
    }

    .event-sec {
        border-radius: 8px;
        background: #fff;
        border: 1px solid #e0e0e0;
        box-shadow: -1px 3px 10px 0 #0000004a;


    }


    .pool-text {
        font-size: 28px;
        font-weight: 700;
        color: #393a4f;
    }

    .time-text {
        font-size: 16px;
        color: #000000;
        margin-bottom: 14px;
        font-weight: 600
    }

    .button-separator {
        position: absolute;
        top: 50%;
        right: -27px;
        display: flex;
        align-items: center;
        justify-content: center;
        height: 50px;
        width: 50px;
        border-radius: 50%;
        background: #fff;
        transform: translateY(-50%);
        border: 1px solid #e0e0e0;
        box-shadow: -1px 3px 10px 0 #0000004a;
        z-index: 9;

    }

    .scribe-text {

        font-size: 20px;
        font-weight: 700;
        color: #393a4f;
        margin-bottom: 16px;
        margin-top: 6px;
    }

    .event-icon ul li span {
        color: #000000;
        font-size: 15px;
        font-weight: 600;
    }

    .event-icon ul li {
        font-size: 15px;
        color: #393a4f;
    }

    .event-icon ul li i {
        color: #5596e6;
        font-size: 14px;

    }

    .add-event {}

    .add-btn {}

    .condition span {}

    .subscribe-secrion p {}

    .subscribe_section {
        display: flex;
        justify-content: space-between;
    }

    .add-btn {
        width: 170px;
        font-size: 16px;
        font-weight: 600;
        text-decoration: none;
        color: #fff;
        background: #00315b;
        padding: 7px;
        display: block;
        text-align: center;
        border-radius: 5px;
        border: solid 2px #00315d;
        text-decoration: none;
    }

    .add-btn:hover {
        background: #e2e2e2;
        transition: 0.5s;
        filter: unset;
        color: #00315b;
        text-decoration: none;
    }

    .event_sec {
        padding: 22px 40px;
        border-right: 2px dashed #dedede;
        position: relative;
    }

    .right-bar {
        padding: 30px 30px 46px 30px;

    }

    .or_text {
        text-align: center;
        font-size: 20px;
        font-weight: 600;
        margin: 20px 0px 5px 0px;

    }

    .subscribe-section img {
        width: 100px;
    }


    .subscribe-section {
        display: flex;
        justify-content: apace-between;
    }

    .event-icon ul {
        list-style: none;
        padding: 0;
        margin: 0;
    }

    .event-icon ul li {
        margin-bottom: 10px;
    }

    .event-icon a {
        text-decoration: none;
        color: #000;

    }

    .pad0 {
        padding: 0;
    }

    .view-btn {
        width: 170px;
        font-size: 16px;
        font-weight: 600;
        color: #fff !important;
        background: #00315b;
        padding: 7px;
        display: block;
        text-align: center;
        border-radius: 5px;
        border: solid 2px #00315d;
        text-decoration: none;
        margin-right: 10px;
    }

    .view-btn:hover {
        background: #e2e2e2;
        transition: 0.5s;
        filter: unset;
        color: #00315b !important;
        text-decoration: none;
    }

    /* 768 start */
    @media screen and (max-width:768px) {
        .button-separator {
            display: none;
        }

        .event_sec {
            border: none;
        }

        .pool-text {
            font-size: 26px;
        }

        .view-flex {
            flex-direction: column;
        }


    }

    /* 768 end */
    /* 575 start */
    @media screen and (max-width:575px) {
        .view-btn {
            width: 100%;
            margin: 0 0 10px 0;
        }

        .event_sec {
            padding: 22px 30px 0px 30px;
        }

        .right-bar {
            padding: 0px 30px 46px 30px;
        }

        .add-btn {
            width: 100%;
        }
    }


    .Receipt-form {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
    }

    .Receipt_form {
        width: 48%;
    }

    .quantity-text {
        font-weight: 600;
        font-size: 15px;
        margin-bottom: 5px;
    }

    .Receipt_form input {
        width: 100%;
        height: 38px;
        font-size: 18px;
        outline-color: #347ab654;
        border-radius: 4px;
        padding: 8px;
    }




    .update-button {
        display: flex;
        justify-content: center;
        margin-top: 50px;
    }



    .gender-drop {
        width: 100%;
        height: 38px;
        font-size: 18px;
        outline-color: #347ab654;
        border-radius: 4px;
        padding: 4px 8px;
        border: solid;
    }

    .benevolent-center {
        text-align: center;
    }

    .update-center {
        text-align: center;
        margin-bottom: 50px;
    }

    /* 768 start */
    @media screen and (max-width:575px) {
        .update-center {
            margin-bottom: 25px;
            font-size: 14px;
        }

        .Receipt-form {
            flex-direction: column;
            margin: 0;
        }

        .Receipt_form {
            width: 100%;
            margin-bottom: 20px;
        }

        .update-button {
            margin-top: 25px;
        }

        .pool-text {
            font-size: 24px;
        }

        .event_sec {
            padding: 22px 22px;
        }
    }

    .dataTables_filter,
    .dataTables_length {
        display: none;
    }

    .loan_img {
        width: 100px
    }

    /*  */
</style>

<body>
    <!-- Google Tag Manager (noscript) -->
    <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-KQHJPZP" height="0" width="0"
            style="display: none; visibility: hidden"></iframe></noscript>
    <!-- End Google Tag Manager (noscript) -->

    <!-- Pageloader -->
    

    <div id="main-navbar" class="navbar navbar-v1 is-inline-flex is-transparent no-shadow is-hidden-mobile">
        <div class="container">

            <?php echo $__env->make('member.layout.navbar-main-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
    <?php echo $__env->make('member.layout.navbar-mobile', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<?php /**PATH C:\xampp\htdocs\upvkss\resources\views/member/layout/header.blade.php ENDPATH**/ ?>