
<?php

use App\Http\Controllers\InvoiceController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;
use App\Http\Controllers\SubscriptionController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\PostController;
use BinshopsBlog\Controllers\BinshopsAdminController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\SubAdminController;
use App\Http\Controllers\AdminAuthController;

include("blog.php");



// Public Routes
Route::get('/upload', 'App\Http\Controllers\UserController@showUploadForm')->name('upload.form');
Route::post('/upload', 'App\Http\Controllers\UserController@upload')->name('upload');
Auth::routes();
Route::get('/', function () {
    return view('welcome');
});
Route::post('/validate-register', [App\Http\Controllers\Auth\RegisterController::class, 'validateRegister'])->name('validate.register');
Route::post('/validate-email', [UserController::class, 'validateEmail'])->name('validate.email');
Route::post('/update-email', [UserController::class, 'updateEmail'])->name('update.email');

Route::post('/update-password-ajax', [UserController::class, 'updatePasswordajax'])->name('update-password-ajax');
Route::get('/get-email-by-user-id', [UserController::class, 'getEmailByUserId'])->name('getEmailByUserId');

// User not changed password route
Route::get('/password_check', [App\Http\Controllers\HomeController::class, 'password_check'])
    ->name('password_check')
    ->middleware('registrationTypeIsOne');



// User Auth Routes with registrationTypeIsOne middleware
Route::group(['middleware' => ['auth', 'registrationTypeIsOne']], function () {
    Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
    Route::get('/registration_status', [App\Http\Controllers\HomeController::class, 'registration_status'])->name('registration_status');

    // Other authenticated user routes...
    Route::get('/dashboard', [App\Http\Controllers\HomeController::class, 'index'])->name('dashboard');
    Route::get('/dashboard2', [App\Http\Controllers\HomeController::class, 'index2'])->name('dashboard2');
    Route::get('/profile/edit', [UserController::class, 'edit'])->name('profile.edit');
    Route::post('/update-bio', [UserController::class, 'updateBio'])->name('update.bio');
    Route::post('/update-present-posting', [UserController::class, 'update_p_info'])->name('update.p_info');
    Route::post('/update-posting-info', [UserController::class, 'updatePostingInfo'])->name('updatePostingInfo');
    Route::post('/update-password', [UserController::class, 'updatePassword'])->name('update-password');

    Route::post('/updateJurisdictionDetails', [UserController::class, 'update_jd'])->name('update_jd');
    Route::put('/profile/update/{id}', [UserController::class, 'update'])->name('profile.update');
    Route::get('/users', [UserController::class, 'list'])->name('users');
    Route::get('/users/sort', [UserController::class, 'sort'])->name('user.sort');
    Route::post('/upload-image', [UserController::class, 'uploadImage'])->name('upload.image');
    Route::post('/upload-image-cover', [UserController::class, 'uploadImagecover'])->name('upload.image_cover');
    Route::get('/users/offline_annual', [UserController::class, 'offline_annual'])->name('offline_annual');
    Route::get('/users/offline_benevolent', [UserController::class, 'offline_benevolent'])->name('offline_benevolent');
    Route::get('/users/update_nominee/{id}', [UserController::class, 'updae_nominee_index'])->name('updae_nominee_index');
    Route::post('/user/save_nominee', [UserController::class, 'save_nominee'])->name('save_nominee');

    Route::get('/user/{id}/details', [UserController::class, 'details'])->name('user.details');
    Route::get('/subscription', [SubscriptionController::class, 'index'])->name('subscription');
    Route::post('/offline-subscription/update', [SubscriptionController::class, 'update'])->name('offline.subscription.update');
    Route::get('/b_fund', [SubscriptionController::class, 'b_fund_index'])->name('b_fund');
    Route::get('/editorial', [PostController::class, 'index'])->name('editorial');
    Route::get('payment', [PaymentController::class, 'payment'])->name('payment');
    Route::post('payment', [PaymentController::class, 'paymentResponse'])->name('paymentResponse');
    Route::get('/invoice/download/{type}', [InvoiceController::class, 'download'])->name('invoice.download');
    Route::get('/update-payment-status', [PaymentController::class, 'updatePaymentStatus'])->name('update_payment_status');
    Route::get('/admin/approval_post', [BinshopsAdminController::class, 'approval_index'])->name('admin.approval');
    Route::post('/admin/approved/{id}', [BinshopsAdminController::class, 'approved'])->name('post.approved');
    Route::get('/subscription/export/{type}/{format?}', [SubscriptionController::class, 'export'])->name('subscription.export');
    Route::post('/submit-offline-subscription', [SubscriptionController::class, 'submitOfflineSubscription'])->name('offline.subscription.submit');

	     Route::get('/users/pan', [UserController::class, 'pan_index'])->name('pan.view');
    	 Route::get('/users/society/registration', [UserController::class, 'society_registration_index'])->name('society.view');
   		 Route::get('/users/memorandum', [UserController::class, 'memorandum_index'])->name('memorandum.view');
   		 Route::get('/users/association', [UserController::class, 'asssociation_index'])->name('association.view');
   		 Route::get('/terms', [UserController::class, 'terms_index'])->name('terms.view');
	     Route::get('/privacy_policy', [UserController::class, 'privacy_policy_index'])->name('policy.view');
    Route::post('/receipt/user', [UserController::class, 'view_receipt'])->name('user_b_fund.receipt');

});




 // Admin Routes with admin middleware
 Route::group(['middleware' => ['admin']], function () {
    Route::get('/admin/home', [AdminController::class, 'index'])->name('admin.dashboard');
    Route::get('/admin/payments', [AdminController::class, 'payments_index'])->name('admin.payments');
    Route::get('/admin/payments/{id}', [AdminController::class, 'show'])->name('admin.payments.show');
    Route::get('/payment/approvals', [AdminController::class, 'approvals'])->name('payment_approvals');
    Route::get('/collection', [AdminController::class, 'collection'])->name('collection');
    Route::get('/membership', [AdminController::class, 'membership'])->name('membership');
    Route::post('/find-user', [UserController::class, 'findUserByEmployeeId']);
    Route::get('/account/approval', [AdminController::class, 'account_approval'])->name('account_approval');
    Route::patch('/account/{id}/approve', [AdminController::class, 'account_approve'])->name('account_approve');
    Route::patch('/payments/{id}/approve', [AdminController::class, 'approve'])->name('admin.payments.approve');
    Route::patch('/payments/{id}/disapprove', [AdminController::class, 'disapprove'])->name('admin.payments.disapprove');
    Route::post('/submit-offline-subscription/admin', [AdminController::class, 'submitOfflineSubscription'])->name('offline.subscription.submit.admin');
});

Route::middleware(['auth', 'subadmin'])->group(function () {
    Route::get('/subadmin/edit', [SubAdminController::class, 'edit'])->name('admin.edit');
    Route::post('subadmin/change-password', [SubAdminController::class, 'updatePassword'])->name('subadmin.password.update');

    Route::get('/subadmin/home', [SubAdminController::class, 'index'])->name('subadmin.home');
    Route::get('/sub/membership', [SubAdminController::class, 'membership'])->name('sub.membership');
    Route::post('/find-user-sub', [UserController::class, 'findUserByEmployeeId']);
    Route::post('/find-user', [UserController::class, 'findUser']);

    Route::get('/sub/annual', [SubAdminController::class, 'annual'])->name('sub.annual');

    Route::post('/sub/submit-offline-subscription', [SubAdminController::class, 'submitOfflineSubscription'])->name('offline.subscription.submit.subadmin');
    Route::post('/receipt', [SubAdminController::class, 'view_receipt'])->name('sub.receipt');
    Route::post('/receipt/bfund', [SubAdminController::class, 'view_receiptbfund'])->name('sub.receiptbfund');

    Route::get('/sub/reports', [SubAdminController::class, 'reports'])->name('sub.reports');
    Route::get('/sub/list', [SubAdminController::class, 'list'])->name('sub.list');
    Route::patch('/subpayments/{id}/approve', [SubAdminController::class, 'approve'])->name('sub.payments.approve');
    Route::patch('/bfund/subpayments/{id}/approve', [SubAdminController::class, 'bfundapprove'])->name('sub.payments.approvebfund');
    Route::get('/download-as-image', [SubAdminController::class, 'downloadAsImage'])->name('download-as-image');
    Route::post('/submit', [SubAdminController::class, 'submitOfflineSubscriptionsub'])->name('submitOfflineSubscriptionsub');
    Route::post('/submit/bfund', [SubAdminController::class, 'submitOfflineSubscriptionsub_bfund'])->name('submitOfflineSubscriptionsub_bfund');
    Route::get('/sub/approvals', [SubAdminController::class, 'approvals'])->name('sub.approvals');
    Route::patch('/account/{id}/approvesub', [SubAdminController::class, 'account_approve'])->name('sub.account_approve');
    Route::get('/sub/history', [SubAdminController::class, 'history'])->name('sub.history');
    Route::get('/sub-admin/payments/{id}', [SubAdminController::class, 'show'])->name('sub.payments.show');
    Route::get('/subadmin/payments', [SubAdminController::class, 'payments_index'])->name('sub.payments');
    Route::get('/subadmin/payments/{id}', [SubAdminController::class, 'show'])->name('sub.payments.show');
    Route::get('/subadmin/bfundpayments/{id}', [SubAdminController::class, 'b_show'])->name('sub.bfundpayments.show');
    Route::get('/sub/history/payments', [SubAdminController::class, 'payments_history'])->name('sub.history.payments');
    Route::patch('/subpayments/{id}/disapprove', [SubAdminController::class, 'disapprove'])->name('subadmin.payments.disapprove');
    Route::patch('/bfund/payments/{id}/disapprove', [SubAdminController::class, 'bfunddisapprove'])->name('subadmin.payments.disapprovebfund');
});
