@extends('member')
@section('title', 'Members')
@section('content')

    <div class="directory-sec">
        <ul class="breadcrumb">
            <li><a href="/home">Dashboard</a></li>
            <li>Members Directory</li>
        </ul>
    </div>

    <form class="search_form" id="search-form">
        <select class="select-bar" name="posting_area">
            <option value="">Select City</option>
            @foreach ($cities as $city)
                <option value="{{ $city }}" {{ $posting_area == $city ? 'selected' : '' }}>{{ $city }}
                </option>
            @endforeach
        </select>
        <select class="design-bar" name="designation">
            <option value="">Select Designation</option>
            @foreach ($designations as $desig)
                <option value="{{ $desig }}" {{ $designation == $desig ? 'selected' : '' }}>{{ $desig }}
                </option>
            @endforeach
        </select>
        <button class="search-btn" type="submit"><i class="fa fa-search" aria-hidden="true"></i>Search Members</button>
    </form>

    {{-- <input type="search" id="table-search" class="" placeholder="search" aria-controls="users-table"> --}}

    <table class="table" id="users-table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Name</th>
                <th>Email</th>
                <th>Contact</th>
                <th>City</th>
                <th>Designation</th>
                <th>Action</th> <!-- Add action column -->
            </tr>
        </thead>
        <!-- <div class="text"></div> -->
        <tbody>
            @foreach ($users as $user)
                <tr class="hover">
                    <td>{{ $user->id }}</td>
                    <td>{{ $user->name }}</td>
                    <td>{{ $user->email }}</td>
                    <td>{{ $user->contact ?? 'Not updated' }}</td>
                    <td>{{ $user->posting_area }}</td>
                    <td>{{ $user->designation }}</td>
                    <td><a class="more_btn" href="{{ route('user.details', $user->id) }}"
                            class="btn btn-primary view-profile">More</a></td>
                </tr>
            @endforeach
        </tbody>
    </table>



@endsection
