@extends('member')
@section('content')
    <div class="container is-custom">
        <!-- Profile page main wrapper -->
        <div id="profile-main" class="view-wrap is-headless">
            <div class="columns is-multiline no-margin">
                <!-- Left side column -->
                <div class="column is-paddingless">
                    <!-- Timeline Header -->
                    <!-- html/partials/pages/profile/timeline/timeline-header.html -->
                    <div class="cover-bg">
                        <img class="cover-image"
                            src="{{ Auth::user()->cover_image ? asset('user/cover_image/' . Auth::user()->cover_image) : asset('default-cover.jpg') }}"
                            alt="Cover Image" />

                        <div class="avatar">
                            @if (Auth::user()->profile_photo)
                                <img src="{{ asset('user/profile_photo/' . Auth::user()->profile_photo) }}" d="user-avatar"
                                    class="avatar-image">
                            @else
                                <img src="{{ asset('user/default_pic.jpg') }}" d="user-avatar" class="avatar-image">
                            @endif
                            <div class="avatar-button">
                                <i data-feather="plus"></i>
                            </div>
                            <div class="pop-button is-far-left has-tooltip modal-trigger"
                                data-modal="change-profile-pic-modal" data-placement="right"
                                data-title="Change profile picture">
                                <a class="inner">
                                    <i data-feather="camera"></i>
                                </a>
                            </div>
                   
                   
                        </div>
                        <div class="cover-overlay"></div>
                        <div class="cover-edit modal-trigger" data-modal="change-cover-modal">
                            <i class="mdi mdi-camera"></i>
                            <span>Edit cover image</span>
                        </div>
                        {{-- <!--/html/partials/pages/profile/timeline/dropdowns/time
                        line-mobile-dropdown.html--> --}}
                        
                    </div>

                    <div class="profile-menu is-hidden-mobile">
                        <div class="menu-start">
                            <a href="{{ route('users') }}" class="button has-min-width">Members</a>
                            <a href="{{ route('subscription') }}" class="button has-min-width">Annual membership</a>
                        </div>
                        <div class="menu-end">
                            <a id="profile-friends-link" href="{{ route('b_fund') }}"
                                class="button has-min-width">Benevolent Fund</a>
                            <a href="/blog_admin/add_post" class="button has-min-width">Editorial</a>
                        </div>
                    </div>

                    <div class="profile-subheader">
                      
                        <div class="subheader-middle">
                            <h2>{{ $currentUser->name }}</h2>
                            <span>{{ $currentUser->designation }} - {{ $currentUser->current_office }}</span>
                        </div>
                       
                    </div>
                </div>
            </div>

            <div class="columns">
                <div id="profile-timeline-widgets" class="column is-4">
                    
                    <div class="box-heading">
                        <h4>Basic Infos</h4>
                       
                    </div>

                    <div class="basic-infos-wrapper">
                        <div class="card is-profile-info">
                            <div class="info-row">
                                <div>
                                    <span>Bio</span>
                                    <a class="is-inverted">{{ $currentUser->bio }}</a>
                                </div>
                                {{-- <i class="mdi mdi-school"></i> --}}
                            </div>
                            <div class="info-row">
                                <div>
                                    <span><i class="mdi mdi-contacts"></i>Mobile Number</span>

                                    <a class="is-inverted"> {{ $currentUser->contact }}</a>
                                </div>

                            </div>
                            <div class="info-row">
                                <div>
                                    <span> <i class="mdi mdi-email"></i>Email</span>
                                    <a class="is-inverted">{{ $currentUser->email }}</a>
                                </div>

                            </div>
                            <div class="info-row">
                                <div>
                                    <span><i class="mdi mdi-home"></i>Place of Posting</span>
                                    <a class="is-inverted">{{ $currentUser->posting_area }}</a>
                                </div>

                            </div>

                            @if ($currentUser->contact_privacy === 1)
                                <div class="info-row">
                                    <div>
                                        <span>Contact</span>
                                        <a class="is-muted">{{ $currentUser->contact }}</a>
                                    </div>
                                    <i class="mdi mdi-contacts"></i>
                                </div>
                            @endif
							
							
                        </div>
                    </div>

                   
                   
                    <!-- Trips widget -->
                    <!-- html/partials/pages/profile/timeline/widgets/trips-widget.html -->
                   

                    <!-- Schedule calendar widget -->
                    <!-- html/partials/widgets/schedule/schedule-widget.html -->
                 
                </div>

                <div class="column is-8">

                    <!--  -->
                    <div class="membership-fee flex-div">
                        <div class="membership">
                            <h2><i class="fa fa-handshake-o"></i> MEMBERSHIP FEE</h2>
                            <p class="amount-text">Amount: <span>₹2000.00</span></p>
                            <p class="status-text">STATUS</p>
                            @if ($annualStatus === 1)
                                <h4 class="paid_text">PAID</h4>
                                <div class="payment-text">Paid</div>
                            @elseif ($annualStatus === 2)
                                <h4 class="paid_text">Waiting for approval</h4>
                                <div class="payment-text">Waiting for approval</div>
                            @elseif ($annualStatus === 3)
                                <h4 class="paid_text">Failed</h4>
                                <a class="payment-text" href="{{ route('subscription') }}">Pay again</a>
                            @else
                                <h4 class="paid_text"><span>DUE</span></h4>
                                <a class="payment-text" href="{{ route('subscription') }}">Make Payment</a>
                            @endif
                        </div>
                        <div class="membership">
                            <h2><i class="fa fa-handshake-o"></i> BENEVOLENT FUND</h2>
                            <p class="amount-text">Amount: <span>₹20000.00</span></p>
                            <p class="status-text">STATUS</p>

                            @if ($bFundStatus === 1)
                                <h4 class="paid_text">PAID</h4>
                                <div class="payment-text">Paid</div>
                            @elseif ($bFundStatus === 2)
                                <h4 class="paid_text">Waiting for approval</h4>
                                <div class="payment-text">Waiting for approval</div>
                            @elseif ($bFundStatus === 3)
                                <h4 class="paid_text">Failed</h4>
                                <a class="payment-text" href="{{ route('b_fund') }}">Pay again</a>
                            @else
                                <h4 class="paid_text"><span>DUE</span></h4>
                                <a class="payment-text" href="{{ route('b_fund') }}">Make Payment</a>
                            @endif
                        </div>

                    </div>
                    <!--=========== birthday start =================-->

                     <div class="main-section">
                        <h3 class="birthday-text">Birthday this month</h3>
                        <div class="profile-sec">

                            @foreach ($birthdays as $birthday)
                                <div class="profile-main">
                                    <div class="profile-img">

                                        @if ($birthday->profile_photo)
                                            <img src="{{ asset('user/profile_photo/' . $birthday->profile_photo) }}"
                                                d="user-avatar" class="avatar-image">
                                        @else
                                            <img src="{{ asset('user/default_pic.jpg') }}" d="user-avatar"
                                                class="avatar-image">
                                        @endif

                                    </div>
                                    <div class="profile-bg">
                                        <h3 class="date-text">{{ $birthday->date_of_birth }}</h3>
                                        <h4 class="profile-text">{{ $birthday->name }}</h4>
                                    </div>
                                </div>
                            @endforeach


                        </div>
                    </div>
                    <!--=========== birthday end =================-->
                    <!--=========== retirement start ============ -->
                    <div class="main-section">
                        <h3 class="birthday-text">Retirement this month</h3>
                        <div class="profile-sec">

                            @foreach ($anniversaries as $user)
                                <div class="profile-main">
                                           <div class="profile-img">

                                        @if ($user->profile_photo)
                                            <img src="{{ asset('user/profile_photo/' . $user->profile_photo) }}"
                                                d="user-avatar" class="avatar-image">
                                        @else
                                            <img src="{{ asset('user/default_pic.jpg') }}" d="user-avatar"
                                                class="avatar-image">
                                        @endif

                                    </div>
                                    <div class="profile-bg">
                                        <h3 class="date-text">{{ $user->marriage_anniversary }}</h3>
                                        <h4 class="profile-text">{{ $user->name }}</h4>
                                    </div>
                                </div>
                            @endforeach




                        </div>
                        <!--=========== retirement end ============ -->
                        <div id="profile-timeline-posts" class="box-heading">
                            <h4>Posts</h4>
                           
                        </div>
                        <div class="profile-timeline">
                            
                            {{-- @foreach ($posts as $post) --}}
                            @foreach ($posts as $post)
                                <div class="profile-post">

                                  
                                    <!-- Post -->
                                    <div class="card is-post">
                                        <!-- Main wrap -->
                                        <div class="content-wrap">
                                            <!-- Header -->
                                            <div class="card-heading">
                                                <div class="user-block">
                                                    <div class="image">
                                                        <img src="https://via.placeholder.com/300x300"
                                                            data-demo-src="{{ asset('user/profile_photo/' . $post->user->profile_photo) }}"
                                                            onerror="this.onerror=null; this.src='{{ asset('user/default_pic.jpg') }}'"
                                                            alt="User Profile Photo" width="300" height="300"
                                                            data-user-popover="0">
                                                    </div>
                                                    <div class="user-info">
                                                        <a href="#">{{ $post->post->author->name }}</a>
                                                        @php
                                                            $posted_at = \Carbon\Carbon::parse($post->posted_at);
                                                        @endphp
                                                        <span class="time">{{ $posted_at->format('F j Y, g:ia') }}
                                                        </span>
                                                    </div>
                                                </div>

                                              
                                            </div>
                                            <!-- /Header -->

                                            <!-- Post body -->
                                            <div class="card-body">
                                                <!-- Post body text -->
                                                <div class="post-text">
                                                    <p>
                                                        {{ $post->title }}
                                                    </p>

                                                    <p></p>
                                                </div>
                                                <!-- Featured image -->

                                                <div class="post-image">
                                                    <a data-fancybox="profile-post1" data-lightbox-type="comments"
                                                        data-thumb="{{ $post->image_url }}"
                                                        href="https://via.placeholder.com/1600x900"
                                                        data-demo-href="{{ $post->image_url }}">
                                                        <img src="https://via.placeholder.com/1600x900"
                                                            data-demo-src="{{ $post->image_url }}" alt="" />
                                                    </a>
                                                    {{-- <a href="{{ route('single_post', ['id' => $post->id]) }}">
                                                    <img src="https://via.placeholder.com/1600x900" data-demo-src="{{ $post->image_url }}" alt="" />
                                                </a>
 --}}

                                                    <!-- Post actions -->
                                                  

                                                   

                                                    
                                                </div>
                                            </div>
                                            <!-- /Post body -->

                                            <!-- Post footer -->
                                          
                                            <!-- /Post footer -->
                                        </div>
                                        <!-- /Main wrap -->

                                        <!-- Comments -->
                                        
                                        <!-- /Comments -->
                                    </div>
                                    <!-- /Post -->
                                </div>
                            @endforeach

                            {{-- @endforeach --}}
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Profile page main wrapper -->
        </div>
    @endsection
