@extends('member')
@section('title', 'Benevolent Fund')

@section('content')
    @if (!$user_status)
        <div class="container container_rule">
			<div class="directory-sec anual-subcription">
        <ul class="breadcrumb">
            <li><a href="/home">Dashboard</a></li>
            <li>Benevolent Fund </li>
            <li>Cart</li>
        </ul>
    </div>
            <div class="row">
                <h3>Name: <span>{{ auth()->user()->name }}</span> </h3>
                <div class="col-lg-8">
                    <div class="data_text">
                        <ul class="employee-text">
                            <li><a href="#">Employee ID: <span> {{ auth()->user()->employee_id }}</span></a></li>
                            <li><a href="#">Batch: <span>2012</span></a></li>
                            <li><a href="#">Mobile Number: <span>{{ auth()->user()->contact }}</span></a></li>
                            <li><a href="#">Designation:<span> {{ auth()->user()->designation }}</span></a></li>
                            <li><a href="#">Place of posting:<span>{{ auth()->user()->posting_area }}</span></a></li>
                            <li><a href="#">Zone/Sector:<span> {{ auth()->user()->zone }}</span></a></li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="shiping-sec">
                        <a href="#"> <img src="{{asset('loan_9202734.png')}}" class="loan_img"  alt="loan_icon"></a>
                        <h4>Benevolent Fund</h4>
                    </div>
                    <div class="subtotal-sec">

                        <div class="order-line">
                            <span class="sub-text">Amount</span>
                            <span class="price-text">₹ 20000.00</span>
                        </div>
                        <div class="order-line">
                            <span class="sub-text">Late Fees</span>
                            <span class="price-text">₹ 0.00</span>
                        </div>

                        <div class="order-line">
                            <span class="sub-text">Total</span>
                            <span class="price-text">₹ 20000.00</span>
                        </div>
                        <div class="order-line">
                            <form action="{{ route('payment') }}" method="POST">
                                @csrf
                                <input type="hidden" name="type" value="Benevolent Fund">
                                <!-- Note that the amount is in paise = 2000 INR -->
                              <!--  <script src="https://checkout.razorpay.com/v1/checkout.js" data-key="{{ env('RAZOR_KEY') }}" data-amount="2000000"
                                    data-buttontext="Pay with Razorpay" data-name="UPVKSS" data-description="Yearly Membership" data-image=""
                                    data-prefill.name="name" data-prefill.email="" data-theme.color="#F37254"></script> -->
                            </form>
                        </div>
                        <div class="order-line">
                            <a class="continue_btn" href="{{ route('offline_benevolent') }}">Make Payment Offline</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif

    @if ($user_status === 1)
        <div class="container container_rule">
			<div class="directory-sec">
            <ul class="breadcrumb">
                <li><a href="/home">Dashboard</a></li>
                <li>Benevolent Fund</li>
            </ul>
        </div>
            <div class="event-sec">
                <div class="row">
                    <div class="col-md-7">
                        <div class="event_sec">
                            <h2 class="pool-text">Benevolent Fund</h2>
                            <h3 class="time-text">Effective from : {{$details->created_at}} </h3>
                            <div class="button-separator">
                                <i class="fa fa-chevron-right" aria-hidden="true"></i>
                            </div>
                            <div class="info-head">
                                <div class="event-icon">
                                    <ul>
                                        <li><a href="#">
                                                <span>Policy Number</span></a><br>00001/05/2024</li>
                                        <li><a href="#">
                                                <span>Date</span></a><br>{{ $details->created_at->format('d-m-Y') }}</li>
                                        <li><a href="#">
                                                <span>Policy Document</span></a>
                                        </li>
                                        <li class="d-flex view-flex">
											 <form action="{{ route('user_b_fund.receipt') }}" method="POST">
                                                @csrf
                                                <input type="text" name="employee_id" value="{{ $details->user->employee_id }}" hidden>
                                                <button type="submit" class="view-btn">View receipt</button>
                                            </form>
                                            <a class="view-btn" href="#">Download</a>
                                        </li>
                                    </ul>

                                </div>

                                <p></p>
                            </div>
                            <div class="info-body">

                            </div>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="right-bar">
                            @if ($hide)
                            <h2 class="scribe-text">Update Nominee Detail</h2>
                            <div class="subscribe_section">

                                <a class="button add-btn"   style="
                                color: rgb(0, 255, 0);" readonly>
                                   Already Updated
                                </a>
                            </div>
                            @else
                            <h2 class="scribe-text">Update Nominee Detail</h2>

                            <div class="subscribe_section">

                                <a href="{{route('updae_nominee_index', ['id' => $details->id])}}" class="button add-btn">
                                    Update Nominee
                                </a>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <br>
        <br>
    @elseif ($user_status === 2)
       <section>
        <div class="container">

            <div class="anual-membership">
                <h2 class="making_payment">Thank you for Making Payment for Benevolent Fund.</h2>
                <p class="payment_verification">Payment verification is in Progress, once it completed you will be able to <br> download or print Payment Receipt.</p>
            <h3 class="thank_text">Thank you</h3>
            <h4 class="team-tittle">Team UPGSTSA</h4>
                       <p class="member-dashboard">Go to <a href="https://app.upgstsa.com/home"> Members Dashboard</a></p>
            </div>
        </div>
    </section>
    @elseif ($user_status === 3)
        payment rejected
    @endif
    {{-- <div class="container py-4">
        <h1 class="mb-4">Benevolent Fund</h1>

        <div class="card">
            <div class="card-body">
                @if (!$user_status)
                    <h2>Online Membership</h2>
                    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam volutpat neque ac metus feugiat, sed
                        fringilla diam mattis. Duis consequat, ipsum ut sagittis pretium, odio nisl laoreet magna, non
                        scelerisque velit justo ac neque.</p>
                @endif

                @if ($user_status === 1)
                    <div class="already_pay">
                        <h1>Subscription Details</h1>

                        @if (is_null($details))
                            <p>No subscription details available.</p>
                        @else
                            <table class="table table-bordered">
                                <tr>
                                    <th>Name</th>
                                    <td>{{ auth()->user()->name }}</td>
                                </tr>
                                <tr>
                                    <th>Email</th>
                                    <td>{{ auth()->user()->email }}</td>
                                </tr>
                                <tr>
                                    <th>Contact</th>
                                    <td>{{ auth()->user()->contact }}</td>
                                </tr>
                                <tr>
                                    <th>Package Name</th>
                                    <td>{{ $details->package_name }}</td>
                                </tr>
                                <tr>
                                    <th>Payment Type</th>
                                    <td>{{ $details->payment_type }}</td>
                                </tr>
                                <tr>
                                    <th>Amount</th>
                                    <td>{{ $details->amount }}</td>
                                </tr>
                                <tr>
                                    <th>Token</th>
                                    <td>{{ $details->token }}</td>
                                </tr>
                                <tr>
                                    <th>Razorpay ID</th>
                                    <td>{{ $details->razorpay_id }}</td>
                                </tr>
                                <tr>
                                    <th>Start Date</th>
                                    <td>{{ $details->created_at }}</td>
                                </tr>
                            </table>
                            <a href="{{ route('subscription.export', ['type' => 'b_fund', 'format' => 'csv']) }}"
                                class="btn btn-primary">Export as CSV</a>
                            <a href="{{ route('subscription.export', ['type' => 'b_fund', 'format' => 'pdf']) }}"
                                class="btn btn-primary">Export as PDF</a>
                        @endif
                    </div>
                @elseif ($user_status === 2)
                    <table class="table table-bordered">
                        <tr>
                            <th>Receipt Number</th>
                            <td>{{ $details->receipt_number }}</td>
                        </tr>
                        <tr>
                            <th>Name</th>
                            <td>{{ auth()->user()->name }}</td>
                        </tr>
                        <tr>
                            <th>Email</th>
                            <td>{{ auth()->user()->email }}</td>
                        </tr>
                        <tr>
                            <th>Contact</th>
                            <td>{{ auth()->user()->contact }}</td>
                        </tr>
                        <tr>
                            <th>Package Name</th>
                            <td>{{ $details->package_name }}</td>
                        </tr>
                        <tr>
                            <th>Payment Type</th>
                            <td>{{ $details->payment_type }}</td>
                        </tr>
                        <tr>
                            <th>Amount</th>
                            <td>{{ $details->amount }}</td>
                        </tr>
                        <tr>
                            <th>Payment Status</th>
                            <td>{{ $details->payment_status }}</td>
                        </tr>
                        <tr>
                            <th>Start Date</th>
                            <td>{{ $details->created_at }}</td>
                        </tr>
                    </table>
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#editModal"
                        data-payment-id="{{ $details->id }}" data-receipt-number="{{ $details->receipt_number }}"
                        data-receipt-document-url="{{ asset($details->receipt_document) }}">
                        Edit
                    </button>
                @elseif ($user_status === 3)
                    <h3>Your offline payment has been failed and disapproved by the admin. Contact for more details or make a new payment request</h3>
                    <a href="{{ route('update_payment_status', ['type' => 'benevolent']) }}">Click here to update your benevolent fund status</a>

                @else
                    <form action="{{ route('payment') }}" method="POST">
                        @csrf
                        <input type="hidden" name="type" value="Benevolent Fund">
                        <!-- Note that the amount is in paise = 2000 INR -->
                        <script src="https://checkout.razorpay.com/v1/checkout.js" data-key="{{ env('RAZOR_KEY') }}" data-amount="2000000"
                            data-buttontext="Pay with Razorpay" data-name="UPVKSS" data-description="Yearly Membership" data-image=""
                            data-prefill.name="name" data-prefill.email="" data-theme.color="#F37254"></script>
                    </form>
                @endif
            </div>
        </div>

        @if (!$user_status)
            <div class="card mt-4">
                <div class="card-body">
                    <h2>Offline Membership</h2>
                    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam volutpat neque ac metus feugiat, sed
                        fringilla diam mattis. Duis consequat, ipsum ut sagittis pretium, odio nisl laoreet magna, non
                        scelerisque velit justo ac neque.</p>
                    <button class="btn btn-primary" data-bs-toggle="modal"
                        data-bs-target="#offlineSubscriptionModal">Subscribe Offline</button>
                </div>
            </div>
        @endif
    </div>

    <!-- Edit Modal Structure -->
    <div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editModalLabel">Edit Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <!-- Form or content to edit -->
                    <form action="{{ route('offline.subscription.update') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="payment_id" id="edit_payment_id" value="">
                        <div class="modal-body">
                            <div class="mb-3">
                                <label for="edit_receipt_number" class="form-label">Receipt Number</label>
                                <input type="text" class="form-control" id="edit_receipt_number" name="receipt_number"
                                    value="" required>
                            </div>
                            <div class="mb-3">
                                <label for="edit_receipt_document" class="form-label">Upload Receipt</label>
                                <input type="file" class="form-control" id="edit_receipt_document"
                                    name="receipt_document" accept="image/*,application/pdf">
                            </div>
                            <div id="edit_preview_container" class="preview-container"></div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save changes</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Offline Subscription Modal -->
    <div class="modal fade" id="offlineSubscriptionModal" tabindex="-1" aria-labelledby="offlineSubscriptionModalLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="offlineSubscriptionModalLabel">Offline Subscription</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="{{ route('offline.subscription.submit') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="offline_receipt_number" class="form-label">Receipt Number</label>
                            <input type="text" class="form-control" id="offline_receipt_number" name="receipt_number"
                                required>
                        </div>
                        <div class="mb-3">
                            <label for="offline_receipt_document" class="form-label">Upload Receipt</label>
                            <input type="file" class="form-control" id="offline_receipt_document"
                                name="receipt_document" accept="image/*,application/pdf" required>
                        </div>
                        <div id="offline_preview_container" class="preview-container"></div>
                    </div>
                    <input type="text" value="Benevolent Fund" name="type" hidden>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Subscribe</button>
                    </div>
                </form>
            </div>
        </div>
    </div> --}}
@endsection

<!-- Include Bootstrap JS and dependencies -->
{{-- <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/5.1.0/js/bootstrap.min.js"></script> --}}

{{-- <script>
    document.addEventListener('DOMContentLoaded', function() {
        const editModal = document.getElementById('editModal');
        const editPreviewContainer = document.getElementById('edit_preview_container');
        const offlinePreviewContainer = document.getElementById('offline_preview_container');

        editModal.addEventListener('show.bs.modal', function(event) {
            const button = event.relatedTarget; // Button that triggered the modal
            const paymentId = button.getAttribute('data-payment-id');
            const receiptNumber = button.getAttribute('data-receipt-number');
            const receiptDocumentUrl = button.getAttribute('data-receipt-document-url');
            // Update modal fields with existing data
            document.getElementById('edit_payment_id').value = paymentId;
            document.getElementById('edit_receipt_number').value = receiptNumber;
            editPreviewContainer.innerHTML = ''; // Clear any existing previews

            // Show existing receipt document
            if (receiptDocumentUrl) {
                const fileExtension = receiptDocumentUrl.split('.').pop().toLowerCase();
                if (['jpg', 'jpeg', 'png', 'gif'].includes(fileExtension)) {
                    const img = document.createElement('img');
                    img.src = receiptDocumentUrl;
                    img.style.maxWidth = '100%';
                    editPreviewContainer.appendChild(img);
                } else if (fileExtension === 'pdf') {
                    const iframe = document.createElement('iframe');
                    iframe.src = receiptDocumentUrl;
                    iframe.style.width = '100%';
                    iframe.style.height = '500px';
                    editPreviewContainer.appendChild(iframe);
                }
            }
        });

        document.getElementById('edit_receipt_document').addEventListener('change', function(event) {
            const file = event.target.files[0];
            editPreviewContainer.innerHTML = ''; // Clear any existing previews

            if (file) {
                const fileReader = new FileReader();

                fileReader.onload = function(e) {
                    const fileURL = e.target.result;
                    if (file.type.startsWith('image/')) {
                        const img = document.createElement('img');
                        img.src = fileURL;
                        img.style.maxWidth = '100%';
                        editPreviewContainer.appendChild(img);
                    } else if (file.type === 'application/pdf') {
                        const iframe = document.createElement('iframe');
                        iframe.src = fileURL;
                        iframe.style.width = '100%';
                        iframe.style.height = '500px';
                        editPreviewContainer.appendChild(iframe);
                    }
                };

                fileReader.readAsDataURL(file);
            }
        });

        document.getElementById('offline_receipt_document').addEventListener('change', function(event) {
            const file = event.target.files[0];
            offlinePreviewContainer.innerHTML = ''; // Clear any existing previews

            if (file) {
                const fileReader = new FileReader();

                fileReader.onload = function(e) {
                    const fileURL = e.target.result;
                    if (file.type.startsWith('image/')) {
                        const img = document.createElement('img');
                        img.src = fileURL;
                        img.style.maxWidth = '100%';
                        offlinePreviewContainer.appendChild(img);
                    } else if (file.type === 'application/pdf') {
                        const iframe = document.createElement('iframe');
                        iframe.src = fileURL;
                        iframe.style.width = '100%';
                        iframe.style.height = '500px';
                        offlinePreviewContainer.appendChild(iframe);
                    }
                };

                fileReader.readAsDataURL(file);
            }
        });
    });
</script> --}}
