@extends('sub-admin.layout.subadmin')
@section('title', 'Reports')
@section('content')
<style>
    .filters_date{
    height: 98px;
    }
    #filter-btn{
       margin-block: 26px;
    }
</style>
    <div class="container">
<div class="row heading_sub">
            <h2>Reports</h2>
        </div>      
		<div class="total mb-3">
            <h3>Total amount collection: ₹<span id="total-amount">{{$total}}</span></h3>
        </div>
		<div class="row mb-3 filters_date">
            <div class="col-md-4">
                <label for="start-date">Start Date:</label>
                <input type="date" id="start-date" class="form-control">
            </div>
            <div class="col-md-4">
                <label for="end-date">End Date:</label>
                <input type="date" id="end-date" class="form-control">
            </div>
            <div class="col-md-4 d-flex align-items-end">
                <button id="filter-btn" class="btn btn-primary">Filter</button>
            </div>
        </div>

        

        <table id="payments-table" class="table table-striped table-bordered" style="width:100%">
            <thead>
                <tr>
                    <th>Employee ID</th>
                    <th>User Name</th>
                    <th>Package Name</th>
                    <th>Payment Type</th>
                    <th>Receipt Number</th>
                    <th>Receipt Document</th>
                    <th>Payment Status</th>
                    <th>Amount</th>
                    <th>Date</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($payments as $payment)
                    <tr>
                        <td>{{ $payment->user->employee_id }}</td>
                        <td>{{ $payment->user->name }}</td>
                        <td>{{ $payment->package_name }}</td>
                        <td>{{ $payment->payment_type }}</td>
                        <td>{{ $payment->main_receipt_id }}</td>
                        <td>
                            @if (empty($payment->receipt_document))
                                {{ 'N/A' }}
                            @elseif (pathinfo($payment->receipt_document, PATHINFO_EXTENSION) === 'pdf')
                                <a href="{{ asset($payment->receipt_document) }}" target="_blank">View Document</a>
                            @else
                                <img src="{{ asset($payment->receipt_document) }}" alt="Receipt Document" style="max-width: 100px;">
                            @endif
                        </td>
                        <td>{{ $payment->payment_status }}</td>
                        <td>{{ $payment->amount }}</td>
                        <td>{{ $payment->created_at }}</td>
                        <td>
                            <a href="{{ route('sub.payments.show', $payment->id) }}" class="btn btn-primary btn-sm">View</a>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
@endsection

@push('scripts')
    <script>
        $(document).ready(function() {
            var dataTable = $('#payments-table').DataTable({
                "paging": true,
                "lengthChange": false,
                "searching": true,
                "ordering": true,
                "info": true,
                "autoWidth": false,
            });

            $('#filter-btn').on('click', function() {
                var startDate = $('#start-date').val();
                var endDate = $('#end-date').val();
                filterByDate(startDate, endDate);
            });

            function filterByDate(startDate, endDate) {
                // Custom filter for date range
                $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
                    var min = startDate ? new Date(startDate) : null;
                    var max = endDate ? new Date(endDate) : null;
                    var date = new Date(data[8]);

                    if ((min === null && max === null) ||
                        (min === null && date <= max) ||
                        (min <= date && max === null) ||
                        (min <= date && date <= max)) {
                        return true;
                    }
                    return false;
                });

                dataTable.draw();
                $.fn.dataTable.ext.search.pop();

                updateTotalAmount();
            }

            function updateTotalAmount() {
                var total = 0;
                dataTable.rows({ search: 'applied' }).every(function() {
                    var data = this.data();
                    total += parseFloat(data[7]);
                });

                $('#total-amount').text(total.toFixed(2));
            }
        });
    </script>
@endpush
