<!DOCTYPE html>
<html>

<head>
    <title>Annual Membership Fees - Payment Receipt</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: Arial, Helvetica, sans-serif;
        }

        .receip-section {
            padding: 10px;
        }

        .container.container-main {
            width: 100%;
            max-width: 2000px;
            border: solid 1px #000;
            padding: 20px;
            border-radius: 5px;
            overflow: hidden;
        }

        .member-section {
            display: flex;
            justify-content: space-between;
            padding-top: 0;
        }

        .member-logo {
            width: 12%;
        }

        .member-logo img {
            width: 100%;
        }

        .member-text p {
            font-size: 2vw;
            font-weight: 600;
            color: #000;
            margin: 0;
            text-align: center;
        }

        .member-text {
            text-align: center;
        }

        .breadcrumb li {
            font-size: 20px;
            color: #00315b;
        }

        .breadcrumb li a {
            text-decoration: none;
            font-size: 20px;
            color: #00315b;
        }

        .breadcrumb li+li::before {
            color: #00315b;
            margin: 0 12px;
        }

        .member-text p {
            font-size: 2vw;
            font-weight: 600;
            color: #000;
            margin: 0;
            text-align: center;
        }

        member-text h2 {
            font-size: 2vw;
            font-weight: 600;
            color: #000;
            margin: 0;
        }

        .member-text h3 {
            font-size: 2vw;
            font-weight: 800;
            color: #000;
            margin: 0;
        }

        .member-text h4 {
            font-size: 1.3vw;
            font-weight: 600;
            color: #000;
            margin: 0;
        }

        .data-text p {
            font-size: 1.2vw;
            font-weight: 600;
            margin: 0;
            margin-bottom: 5px;
        }

        .data-text span {
            font-weight: 700;
        }

        .employee_text li a {
            text-decoration: none;
            color: #000;
        }

        .employee_text li {
            font-size: 1.5vw;
            width: 50%;
            font-weight: 600;
            margin-bottom: 0px;
        }

        .amount_text ul {
            display: flex;
            list-style: none;
            margin: 0;
            padding: 0;
        }

        .amount_text li {
            width: 120px;
            border: solid 1px #000;
            font-weight: 600;
            line-height: 34px;
            font-size: 1.6vw;
            text-align: center;
        }

        .amount_text h4 {
            font-size: 1.8vw;
            font-weight: 600;
            color: #000;
            margin: 0px 0px 0px 10px;
        }

        .payment-sec {
            display: flex;
            justify-content: space-between;
        }

        .mode-text {
            width: 50%;
            margin-top: 0px;
        }

        .mode-text ul {
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            list-style: none;
            margin: 0;
            padding: 0;
            margin-top: 10px;
        }

        .mode-text li {
            width: 50%;
            font-size: 16px;
            font-weight: 600;
        }

        .employee_text {
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            list-style: none;
            margin: 0;
            padding: 0;
        }

        .amount_text {
            margin-top: 15px;
        }

        .no-print {
            width: 170px;
            margin: 50px auto 0;
        }

        .print_btn {
            font-size: 1.5vw;
            text-decoration: none;
            width: 170px;
            height: 48px;
            background: #00315b;
            text-align: center;
            color: #fff;
            font-weight: 700;
            filter: drop-shadow(0px 3px 2px #000);
            border: solid 1px #00315b;
            border-radius: 3px;
            overflow: hidden;
            transition: 0.5s;
        }

        .print_btn:hover {
            color: #00315b;
            border: solid 1px #00315b;
            background: #f0f0f0;
            filter: unset;
        }

        .member_date ul {
            display: flex;
            padding: 0;
            font-weight: 700;
            list-style: none;
        }

        .member_date li {
            margin-right: 10px;
            font-size: 1.5vw;
        }

        .scan-logo img {
            width: 125px;
        }

        .online-text h4 {
            font-size: 14px;
            font-weight: 600;
            text-align: right;
        }

        .member-text h2 {
            font-size: 2vw;
            font-weight: 600;
            color: #000;
            margin: 0;
        }
        @media print {
        .no-print {
            display: none;
        }
    }
    </style>

</head>

<body>

    <!-- =========== -->
    <section class="receip-section">
        <div class="container container-main">
            <div class="member-section">
                <div class="member-logo">
                    <img src="https://app.upgstsa.com/logo-upgst.png" alt="logor">
                </div>
                <div class="member-text">
                    <p>GST OFFICERS SERVICE ASSOCIATION UTTAR PRADESH</p>
                    <h2>ANNUAL MEMBERSHIP FEE</h2>
                    <h3>RECEIPT</h3>
                    <h4>Receipt Number: {{$details->main_receipt_id}}</h4>
                </div>
                <div class="mamber-scan">
                    <div class="scan-logo">
                        <img src="https://app.upgstsa.com/user/qr.jpg" alt="scan_logo">
                    </div>
                    <div class="member_date">
                        <ul>
                            <li>Date:</li>
                            <li>{{ $details->created_at->format('d-m-Y') }}</li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="data-text">
                <p>Name: <span>{{ $details->user->name }}</span> </p>
                <ul class="employee_text">
                    <li><a href="#">Employee ID: <span>{{ $details->user->employee_id ?? 'N/A' }}</span></a></li>
                    <li><a href="#">Batch: <span>{{ $details->user->batch ?? 'N/A' }}</span></a></li>
                    <li><a href="#">Mobile Number: <span>{{ $details->user->contact ?? 'N/A' }}</span></a></li>
                    <li><a href="#">Designation: <span>{{ $details->user->designation ?? 'N/A' }}</span></a></li>
                    <li><a href="#">Place of posting: <span>{{ $details->user->posting_area ?? 'N/A' }}</span></a>
                    </li>
                    <li><a href="#">Zone/Sector: <span>{{ $details->user->zone ?? 'N/A' }}</span></a></li>

                </ul>
                <div class="amount_text d-flex">
                    <ul>
                        <li>Amount</li>
                        <li>₹ 20000/00</li>

                    </ul>
                    <h4>Rupees: Twenty thounsand only</h4>
                </div>
                <div class="payment-sec">
                    <div class="mode-text">
                        <ul>
                            <li>Mode of payment: {{ $details->payment_type }}</li>
                            {{-- <li>TRN: 0123456789</li> --}}
                            <li>Cashier Name: {{ $details->cashier->name ?? 'N/A' }}</li>
                        </ul>
                    </div>
                    <div class="online-text">
                        <P>GST OFFICERS SERVICE ASSOCIATION UTTAR PRADESH</P>
                        <h4>ONLINE RECEIPT SINGNATURE NOT REQURED</h4>

                    </div>
                </div>
                <div class="no-print">
                    <button class="print_btn" onclick="window.print();">Print</button>
                </div>
            </div>
        </div>
    </section>
    <!--  data end-->
</body>
<!-- ==================== -->
<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<!-- =================== -->

</html>
