@extends('sub-admin.layout.subadmin')
@section('title', 'Payment Details')

@section('content')
    <style>
        .profile_img img {
            max-width: 150px;
        }

        .card-body h3,
        .card-body h4 {
            font-weight: bold;
        }

        .details-card .card-body div {
            margin-bottom: 1rem;
        }

        .details-card .card-body strong {
            display: inline-block;
            min-width: 150px;
        }

        .actions {
            text-align: center;
        }

        .actions .btn {
            margin: 0 0.5rem;
        }

        .row-equal-height {
            display: flex;
            flex-wrap: wrap;
        }

        .row-equal-height .col-md-4,
        .row-equal-height .col-md-8 {
            display: flex;
            align-items: stretch;
        }

        .row-equal-height .card {
            flex: 1;
        }
    </style>

    <div class="container mt-5">
        <!-- User Details -->
        <div class="row-equal-height mb-4">
            <div class="col-md-4 text-center">
                <div class="card">
                    <div class="card-body">
                        <div class="profile_img mb-3">
                            @if ($payment->user->profile_photo)
                                <img src="{{ asset('user/profile_photo/' . $payment->user->profile_photo) }}"
                                    class="img-fluid rounded-circle">
                            @else
                                <img src="{{ asset('user/default_pic.jpg') }}" class="img-fluid rounded-circle">
                            @endif
                        </div>
                        <h3>{{ $payment->user->name }}</h3>
                        <p><strong>Email:</strong> {{ $payment->user->email }}</p>
                        <p><strong>Designation:</strong> {{ $payment->user->designation }}</p>
                    </div>
                </div>
            </div>
            <div class="col-md-8">
                <div class="card">
                    <div class="card-body">
                        <h4>User Information</h4>
                        <p><strong>Employee ID:</strong> {{ $payment->user->employee_id }}</p>
                        <p><strong>User Name:</strong> {{ $payment->user->name }}</p>
                        <form action="{{ route('sub.receipt') }}" method="POST">
                            @csrf
                            <input type="text" name="employee_id" value="{{ $payment->user->employee_id }}" hidden>
                            @if ($payment->status === 'success')
                                <button type="submit" class="btn btn-success">view receipt</button>
                            @endif
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Payment Details -->
        <h1 class="mb-4">Payment Details</h1>

        <div class="card details-card mb-4">
            <div class="card-body">
                @if ($payment->payment_type === 'offline')
                    <div>
                        <strong>Receipt:</strong>
                        @if (empty($payment->receipt_document))
                            {{ 'null' }}
                        @elseif (pathinfo($payment->receipt_document, PATHINFO_EXTENSION) === 'pdf')
                            <a href="{{ asset($payment->receipt_document) }}" target="_blank" class="btn btn-primary">View
                                Document</a>
                        @else
                            <a href="{{ asset($payment->receipt_document) }}" target="_blank">
                                <img src="{{ asset($payment->receipt_document) }}" alt="Receipt Document"
                                    style="max-width: 150px;">
                            </a>
                        @endif
                    </div>
                @endif

                <div><strong>ID:</strong> {{ $payment->id }}</div>
                <div><strong>Package Name:</strong> {{ $payment->package_name }}</div>
                <div><strong>Payment Type:</strong> {{ $payment->payment_type }}</div>

                @if ($payment->payment_type === 'offline')
                    @if ($payment->package_name === 'Annual Subscription')
                        <div><strong>Receipt Number:</strong> {{ $payment->main_receipt_id }}</div>
                    @else
                        <div><strong>Cheque Number:</strong> {{ $payment->cheque_number }}</div>
                        {{-- <div><strong>Receipt Number:</strong> {{ $payment->receipt_number }}</div> --}}
                    @endif
                @endif

                @if ($payment->payment_type === 'online')
                    <div><strong>Razorpay ID:</strong> {{ $payment->razorpay_id }}</div>
                @endif

                <div><strong>Payment Status:</strong> {{ $payment->payment_status }}</div>
                <div><strong>Amount:</strong> {{ $payment->amount }}</div>
                <div><strong>Date:</strong> {{ $payment->created_at }}</div>
            </div>
        </div>

        @if ($payment->payment_status === 'pending approval')
            <!-- Approve and Disapprove Buttons -->
            <div class="actions mt-4">
                @if ($payment->package_name === 'Annual Subscription')
                    <form action="{{ route('sub.payments.approve', $payment->id) }}" method="POST"
                        style="display: inline;">
                        @csrf
                        @method('PATCH')
                        <button type="submit" class="btn btn-success">Approve</button>
                    </form>

                    <form action="{{ route('subadmin.payments.disapprove', $payment->id) }}" method="POST"
                        style="display: inline;">
                        @csrf
                        @method('PATCH')
                        <button type="submit" class="btn btn-danger">Disapprove</button>
                    </form>
                @else
                    <form action="{{ route('sub.payments.approvebfund', $payment->id) }}" method="POST"
                        style="display: inline;">
                        @csrf
                        @method('PATCH')
                        <button type="submit" class="btn btn-success">Approve</button>
                    </form>

                    <form action="{{ route('subadmin.payments.disapprovebfund', $payment->id) }}" method="POST"
                        style="display: inline;">
                        @csrf
                        @method('PATCH')
                        <button type="submit" class="btn btn-danger">Disapprove</button>
                    </form>
                @endif

            </div>
        @endif
    </div>
@endsection
