@extends('sub-admin.layout.subadmin')
@section('title', 'Annual Membership Fee')
<style>
    .member_container {
        height: 500px;
        background-color: white;
    }

    .heading_1 {
        padding-top: 20px;
        justify-content: center;
        align-items: center
    }

    .field_employee_id {
        width: 50%;
        border: 1px solid black;
    }

    .btn_css {
        width: 100px;
        height: 40px;
        border-radius: 20px !important;
        color: white !important;
    }

    .error_user {
        width: 100%;
        background-color: red;
        color: white;
        height: 50px;
        display: flex;
        justify-content: center;
        align-items: center;
    }
</style>
@section('content')

    <div class="member_container">
        @if (session('error'))
            <div class="error_user">{{ session('error') }}</div>
        @endif
        @if (session('success'))
            <div class="alert alert-success">
                <form action="{{ route('sub.receipt') }}" method="POST">
                    @csrf
                    <input type="text" name="employee_id" value="{{ session('employee_id') }}" hidden>
                    Click <button type="submit">here</button> to view the receipt
                </form>
            </div>
        @endif

        <div class="row heading_1">
            <h2>Benevolent Fund</h2>
        </div>


        <form action="{{ url('/find-user') }}" method="post">
            @csrf
            <div class="row heading_1">
                <div class="field_employee_id">
                    <input type="text" class="employee_id_m form-control" name="employee_id"
                        placeholder="Enter Employee ID">
                </div>
            </div>
            <div class="row heading_1">
                <button type="submit" class="btn btn-primary btn_css">Proceed</button>
            </div>
        </form>

    </div>
@endsection
