<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Document</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            font-family: arial;
        }

        .input-item {
            cursor: pointer;
            margin-top: 20px;
            display: flex;
            align-items: flex-start;
        }

        .input-item a {
            text-decoration: none;
            color: #5E55BA;
        }

        .input-item label {
            font-size: 14px;
            cursor: pointer;
            margin: 0;
        }

        .acount-text {
            font-size: 16px;
            margin: 20px 0px 0px 0px;
            color: #595959
        }

        .acount-text a {
            text-decoration: none;
            color: #5E55BA;
            font-weight: 600;
        }

        .form_title {
            font-size: 24px;
            color: #393a4f;
            font-weight: 300;
            text-align: left;
        }

        .align-center {
            align-items: center;
        }

        .form_subtitle {
            text-align: left;
            font-family: "Roboto", sans-serif;
            font-size: 16px;
            color: #a2a5b9;
            margin-bottom: 16px;
            line-height: 20px;
        }

        .form-name {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .form_field {
            width: 48%;
        }

        .form_field input {
            width: 100%;
        }

        .form_field input {
            font-size: 15px;
            height: 36px;
            border-radius: 5px;
            transition: all .3s;
            outline-color: red;
            padding: 5px 5px
        }

        .form_field label {
            font-size: 15px;
            color: #393a4f;
            margin: 0;
            font-weight: 600;
        }

        .login-img img {
            width: 100%;
        }

        .logo-img {
            width: 100px;
            margin: 0 auto 20px;
        }

        .logo-img img {
            width: 100%;
            display: none;
        }

        .input-item ul {
            display: flex;
            justify-content: space-between;
            width: 100%;
            list-style: none;
            margin: 0;
        }

        .title_form {
            font-size: 24px;
            color: #9a0505;
            font-weight: 600;
            text-align: left;
        }

        .input-email {
            width: 100%;
        }

        .sent-btn {
            width: 170px;
            height: 48px;
            background: #5645fe;
            display: block;
            color: #fff !important;
            padding: 10px;
            text-align: center;
            border-radius: 5px;
            border: solid 2px #4335d2;
            filter: drop-shadow(0px 2px 1px #4335d2);
            transition: 0.5s;
        }

        .sent-btn:hover {
            background-color: #eaeaea;
            filter: unset;
            border: solid 2px #000;
            color: #000 !important;
        }

        .alert_notificatio {
            color: #00b975;
            background: #cdffed;
            padding: 15px;
            margin-bottom: 10px;
        }

        .alert_notificatio h3 {
            font-size: 18px;
            margin: 0;
            font-weight: 600;
        }

        @media screen and (max-width: 992px) {
            .form_field label {
                font-size: 13px;
            }

            .alert_notificatio h3 {
                font-size: 14px;
            }

            .form_subtitle {
                font-size: 13px;
            }

            .title_form {
                font-size: 18px;
            }
        }

        @media screen and (max-width: 520px) {
            .login-img img {
                display: none;
            }

            .logo-img img {
                width: 100px;
                display: block !important;
            }

            .form-name {
                flex-direction: column;
            }

            .form_field {
                width: 100%;
                margin-bottom: 20px;
            }

            .input-item {
                margin-top: 0;
            }
        }

        @media screen and (max-width: 480px) {
            .alert_notificatio h3 {
                font-size: 12px;
            }

            .form_subtitle {
                font-size: 14px;
                line-height: 18px;
            }

            .title_form {
                font-size: 16px;
            }
        }
        .error-message{
            color: red;
        }
        #next_step {
            display: none;
        }
    </style>

</head>

<body>
    <div class="container">
        <div class="row align-center">
            <div class="col-md-6">
                <div class="login-img">
                    <img src="https://i.ibb.co/BTqZW9N/login-img.jpg" alt="login-img">
                    <div class="logo-img">
                        <img src="https://i.ibb.co/kK4JVgJ/logor.png" alt="logor">
                    </div>
                </div>
            </div>
            <div class="col-md-6 form-sec">
                <div class="form-aria">
                    @if(session('step') !== 'password')
                    <div id="step-email">
                        <h2 class="title_form">Please enter your email</h2>
                        <h3 class="form_subtitle">Please enter your email to continue with <b>GST Officers Service association Uttar Pradesh</b></h3>
                        <div class="form-name">
                            <div class="form_field">
                                <label>Email</label>
                                <input class="input-email" placeholder="Enter your email" type="email" id="email" name="email">
                                <span class="error-message" id="email_error"></span>
                            </div>
                        </div>
                        <div class="input-item">
                            <ul class="align-items-center">
                                <li>
                                    <button class="sent-btn" href="#" id="next_step">Next</button>
                                </li>
                            </ul>
                        </div>
                    </div>
                    @endif
                    @if(session('step') === 'password')
                    <div id="step-password" >
                        <h2 class="title_form">Please change password to continue</h2>
                        <h3 class="form_subtitle">Changing Password on first time login is mandatory, please change password to keep your account secure with <b>GST Officers Service association Uttar Pradesh</b></h3>
                        <div class="form-name">
                            <div class="form_field">
                                <label>New Password</label>
                                <input class="input-email" placeholder="Enter new password" type="password" id="password" name="password">
                                <span class="error-message" id="password_error"></span>
                            </div>
                            <div class="form_field">
                                <label>Confirm New Password</label>
                                <input class="input-email" placeholder="Enter confirm new password" type="password" id="c_password" name="c_password">
                                <span class="error-message" id="c_password_error"></span>
                            </div>
                        </div>
                        <div class="input-item">
                            <ul class="align-items-center">
                                <li>
                                    <button class="sent-btn" href="#" id="update_password">Change Password</button>
                                </li>
                            </ul>
                        </div>
                    </div>

                    @endif
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script>
      $(document).ready(function() {
    function debounce(func, wait) {
        let timeout;
        return function(...args) {
            clearTimeout(timeout);
            timeout = setTimeout(() => func.apply(this, args), wait);
        };
    }

    function validateEmail() {
        let email = $('#email').val();
        $('.error-message').text('');

        if (email) {
            $.ajax({
                url: '{{ route("validate.email") }}',
                type: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    email: email
                },
                success: function(response) {
                    if (response.success) {
                        $('#email_error').text('');
                        $('#next_step').show();
                    } else {
                        $('#email_error').text(response.message);
                        $('#next_step').hide();
                    }
                }
            });
        } else {
            $('#email_error').text('Email is required.');
            $('#next_step').hide();
        }
    }

    $('#email').on('keyup', debounce(validateEmail, 500));

    $('#next_step').on('click', function(e) {
        e.preventDefault();
        let email = $('#email').val();

        $.ajax({
            url: '{{ route("update.email") }}', // Your email update route
            type: 'POST',
            data: {
                _token: '{{ csrf_token() }}',
                email: email
            },
            success: function(response) {
                if (response.success) {
                  location.reload();
                } else {
                    $('#email_error').text(response.message);
                }
            }
        });
    });

    $('#update_password').on('click', function(e) {
        e.preventDefault();
        let password = $('#password').val();
        let password_confirmation = $('#c_password').val();
        let hasError = false;

        $('.error-message').text('');

        if (password.length < 6) {
            $('#password_error').text('Password must be at least 6 characters.');
            hasError = true;
        }

        if (password !== password_confirmation) {
            $('#c_password_error').text('Passwords do not match.');
            hasError = true;
        }

        if (!hasError) {
            $.ajax({
                url: '/update-password-ajax',
                type: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    password: password,
                    password_confirmation: password_confirmation
                },
                success: function(response) {
                    if (response.success) {
                        location.reload();
                    } else {
                        if (response.errors) {
                            if (response.errors.password) {
                                $('#password_error').text(response.errors.password[0]);
                            }
                            if (response.errors.password_confirmation) {
                                $('#c_password_error').text(response.errors.password_confirmation[0]);
                            }
                        }
                    }
                }
            });
        }
    });
});

    </script>
</body>

</html>
