@include('member.layout.header')

<div class="view-wrapper">
    <!-- Container -->
    <div class="container is-custom">
        @yield('content')
    </div>

    <!-- /Container -->

    @include('member.layout.modal')

</div>

@include('member.layout.footer')

{{-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script> --}}
<script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>

<script>
    $(document).ready(function() {
        var table = $('#users-table').DataTable({
            "bInfo": false
        });

        $('#search-form').on('submit', function(e) {
            e.preventDefault();

            $.ajax({
                type: 'GET',
                url: '{{ route('user.sort') }}',
                data: $('#search-form').serialize(),
                success: function(data) {
                    $('#users-table tbody').empty();
                    $.each(data.users, function(index, user) {
                        var newRow = $('<tr class="hover">').append(
                            $('<td>').text(user.id),
                            $('<td>').text(user.name),
                            $('<td>').text(user.email),
                            $('<td>').text(user.contact ?? 'Not updated'),
                            $('<td>').text(user.posting_area),
                            $('<td>').text(user.designation),
                            $('<td>').html('<a href="/user/' + user.id +
                                '/details" class="more_btn">More</a>'
                                )
                        );
                        $('#users-table tbody').append(newRow);
                    });

                    $('.dataTables_paginate').hide();
                }
            });
        });


    });
</script>
