<!-- resources/views/emails/payment_success.blade.php -->
@if ( $payment->payment_type === 'offline' )
<html>
    <body>
        <h1>Payment Successful</h1>
        <p>Dear {{ $user->name }},</p>
        <p>Your payment for the {{ $payment->package_name }} package has been successfully processed.</p>
        <p>Payment Details:</p>
        <ul>
            <li>Receipt Number: {{ $payment->main_receipt_id }}</li>
            <li>Amount: ₹{{ $payment->amount }}</li>
            <li>Payment Type: {{ $payment->payment_type }}</li>
            <li>Payment Status: {{ $payment->payment_status }}</li>
        </ul>
        <p>Thank you for your subscription!</p>
    </body>
    </html>

@endif

@if ($payment->payment_type === 'online')
<html>
    <body>
        <h1>Payment Successful</h1>
        <p>Dear {{ $user->name }},</p>
        <p>Your payment for the {{ $payment->package_name }} package has been successfully processed.</p>
        <p>Payment Details:</p>
        <ul>
            <li>Receipt Number: {{ $payment->main_receipt_id}}</li>
            <li>Amount: ₹{{ $payment->amount }}</li>
            <li>Payment Type: {{ $payment->payment_type }}</li>
            <li>Razorpay id: {{ $payment->razorpay_id }}</li>
            <li>Payment Status: {{ $payment->payment_status }}</li>
        </ul>
        <p>Thank you for your subscription!</p>
    </body>
    </html>
@endif
