<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - GST Officers Service Association Uttar Pradesh</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
    <link rel="icon" type="image/png" href="{{asset('icon.png')}}" />

    <style>
        * {
            margin: 0;
            padding: 0;
            font-family: arial;
        }

        .main-section {
            margin-top: 50px;
        }

        .form-name {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .input-item ul {
            display: flex;
            justify-content: space-between;
            width: 100%;
            list-style: none;
            margin: 0;
        }

        .create-button {
            margin-top: 30px;
        }

        .create-btn {
            width: 100%;
            height: 48px;
            background: #000;
            color: #fff;
            display: block;
            text-align: center;
            padding: 10px;
            text-decoration: none;
            border-radius: 5px;
            transition: 0.5s;
            border: solid 2px #000;
        }

        .create-btn:hover {
            text-decoration: none;
            background: #dddddd;
            border: solid 2px #000;
            transition: 0.5s;
            color: #000;
        }

        .acount-text {
            font-size: 16px;
            margin: 20px 0px 0px 0px;
            color: #595959
        }

        .acount-text a {
            text-decoration: none;
            color: #5E55BA;
            font-weight: 600;
        }

        .form_title {
            font-size: 24px;
            color: #393a4f;
            font-weight: 300;
            text-align: left;
        }

        .align-center {
            align-items: center;
        }

        .form_subtitle {
            text-align: left;
            font-family: "Roboto", sans-serif;
            font-size: 14px;
            color: #a2a5b9;
            margin-bottom: 16px;
        }

        .form_field label {
            font-size: 15px;
            color: #393a4f;
            margin: 0;
            font-weight: 600;
        }

        .input-item label {
            font-size: 14px;
            cursor: pointer;
            margin: 0;
        }

        .input-item a {
            text-decoration: none;
            color: #5E55BA;
        }

        .input-item input {
            width: 22px;
            height: 22px;
            cursor: pointer;
            margin-right: 10px;
        }

        .input-item {
            cursor: pointer;
            margin-top: 20px;
            display: flex;
            align-items: flex-start;
        }

        .form-sec {
            margin: 0 auto;
        }

        .form_field {
            width: 48%;
            position: relative;
        }

        .form_field input {
            width: 100%;
            font-size: 15px;
            height: 36px;
            border-radius: 5px;
            transition: all .3s;
            outline-color: red;
            padding: 5px 35px 5px 5px;
        }

        .email-form {
            margin-top: 20px;
        }

        .email-form label {
            font-size: 15px;
            color: #393a4f;
            margin: 0;
            font-weight: 600;
        }

        .email-form input {
            width: 100%;
            font-size: 15px;
            height: 36px;
            border-radius: 5px;
            transition: all .3s;
            outline-color: red;
            padding: 5px 35px 5px 5px;
        }

        .login-img img {
            width: 100%;
        }

        .logo-img {
            width: 100px;
            margin: 0 auto;
            margin-bottom: 30px;
        }

        .logo-img img {
            width: 100%;
            max-width: 100px;
            display: block;
            position: absolute;
            top: 0px;
            left: 50%;
            transform: translate(-50%, 0px);
            margin: 0 auto;
        }

        .logo-img {
            width: 100px;
        }

        .alert_notificatio {
            color: #fffffe;
            background: #e24848;
            padding: 15px;
            margin-bottom: 10px;
        }

        .alert_notificatio h3 {
            font-size: 18px;
            margin: 0;
            font-weight: 600;
        }

        @media screen and (max-width:520px) {
            .form_subtitle,
            .form_title {
                text-align: center;
            }

            .form-name {
                flex-direction: column;
            }

            .form_field {
                width: 100%;
                margin-bottom: 20px;
            }

            .input-item {
                margin: 0;
            }

            .form_title {
                font-size: 22px;
            }
        }

        @media screen and (max-width:480px) {
            .login-img img {
                width: 100%;
                display: none;
            }

            .logo-img img {
                width: 100%;
                max-width: 100px;
                display: block;
                margin: 0 auto;
                transform: unset;
                position: unset;
            }

            .main-section {
                margin: 50px 0px;
            }
        }

        .toggle-password {
            position: absolute;
            top: 69%;
            right: 10px;
            transform: translateY(-50%);
            cursor: pointer;
        }
    </style>
</head>

<body>

    <div class="container main-section">

        <div class="row align-center">
            <div class="col-md-6">
                <div class="login-img">
                    <img src="{{asset('login-img.png')}}" alt="login-img">
                    <div class="logo-img">
                        <img src="{{asset('logo-upgst.png')}}" alt="logor">
                    </div>
                </div>
            </div>
            <div class="col-md-6 form-sec">
                <div class="form-aria">
                    <h2 class="form_title">Welcome to UPGSTSA</h2>
                    <h3 class="form_subtitle">Enter your credentials to sign in.</h3>

                    @if (session('message'))
                        <div class="alert_notificatio">
                            <h3>
                                Your account is inactive. </h3>
                        </div>
                    @endif

                    <form method="POST" action="{{ route('login') }}">
                        @csrf
                        <div class="form-name">

                            <div class="form_field">
                                <label>User ID</label>
                                <input id="contact" type="tel"
                                    class="input @error('employee_id') is-invalid @enderror" name="employee_id"
                                    value="{{ old('employee_id') }}" required autocomplete="contact" autofocus>
                                @error('employee_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                            <div class="form_field">
                                <label>Password</label>
                                <input id="password" type="password"
                                    class="input @error('password') is-invalid @enderror" name="password" required
                                    autocomplete="current-password">
                                <i class="fa fa-eye toggle-password" onclick="togglePassword()"></i>
                                @error('password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="input-item">
                            <ul class="">
                                <li class="d-flex">
                                    <input type="checkbox" id="cheac-box">
                                    <label for="agree">Remember Me</label>
                                </li>
                                <li>
                                    <a href="{{ route('password.request') }}">Forgot password?</a>
                                </li>
                            </ul>
                        </div>

                        <div class="create-button">
                            <button class="create-btn" type="submit">Sign In</button>
                        </div>
                    </form>

                    <p class="acount-text">Don’t have an account? <a href="{{ route('register') }}"> Sign up here</a></p>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function togglePassword() {
            var passwordField = document.getElementById("password");
            var toggleIcon = document.querySelector(".toggle-password");
            if (passwordField.type === "password") {
                passwordField.type = "text";
                toggleIcon.classList.add("fa-eye-slash");
                toggleIcon.classList.remove("fa-eye");
            } else {
                passwordField.type = "password";
                toggleIcon.classList.add("fa-eye");
                toggleIcon.classList.remove("fa-eye-slash");
            }
        }
    </script>
</body>

</html>
