@extends('admin.layout.admin')
@section('title', 'Account Approval')
@section('content')
@section('style')
    <style>
        .page-wrapper {
            display: block !important;
        }

        .member_container {
            height: 500px;
            background-color: white;
        }
    </style>
@endsection
<div class="container mt-5 member_container">
    <h1>Account Approvals</h1>
    {{-- <div class="mb-3">
        <label for="package-filter" class="form-label">Filter by Package:</label>
        <select class="form-select" id="package-filter">
            <option value="">All</option>
            <option value="annual">Annual</option>
            <option value="benevolent">Benevolent</option>
        </select>
    </div> --}}

    <table id="payments-table" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th>Emoloyee ID</th>
                <th>Name</th>
                <th>Email</th>
                <th>Designation</th>
                <th>Contact</th>
                <th>Date Registered</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($users as $user)
                <tr>
                    <td>{{ $user->employee_id }}</td>
                    <td>{{ $user->name }}</td>
                    <td>{{ $user->email }}</td>
                    <td>{{ $user->designation }}</td>
                    <td>{{ $user->contact }}</td>
                    <td>{{ $user->created_at->format('d-m-Y') }}</td>

                    <td>
                        <form action="{{ route('account_approve', $user->id) }}" method="POST"
                            style="display: inline;">
                            @csrf
                            @method('PATCH')
                            <button type="submit" class="btn btn-success">Approve</button>
                        </form>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>

@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        var dataTable = $('#payments-table').DataTable({
            "paging": true,
            "lengthChange": false,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": false,
        });

        // Event listener for package filter dropdown
        $('#package-filter').on('change', function() {
            var packageName = $(this).val();
            var status = $('#status-filter').val();
            updateDataTableFilters(packageName, status);
        });


        function updateDataTableFilters(packageName, status) {
            dataTable.column(2).search(packageName).draw(); // Filter by Package Name
            dataTable.column(6).search(status).draw(); // Filter by Payment Status
        }
    });
</script>
@endpush
