@extends('admin.layout.admin')
@section('title', 'Payment Details')

@section('content')

    <!-- User Details -->
    <div class="row_new">
        <div class="proile_img">
            <img src="{{ asset('user/profile_photo/' . $payment->user->profile_photo) }}" alt="User Profile Picture"
                class="img-fluid rounded-circle" style="max-width: 150px;">
        </div>
        <div class="user_info">
            <h2>{{ $payment->user->name }}</h2>
            <p><strong>Email:</strong> {{ $payment->user->email }}</p>
            <p><strong>Designation:</strong> {{ $payment->user->designation }}</p>
            <!-- Add any other user details you want to display -->
        </div>
    </div>

    <!-- Payment Details -->
    <h1>Payment Details</h1>

    <div>
        @if ($payment->payment_type === 'offline')
        <br>
        <strong>Receipt:</strong>
        @if (empty($payment->receipt_document))
            {{ 'null' }}
        @elseif (pathinfo($payment->receipt_document, PATHINFO_EXTENSION) === 'pdf')
            <a href="{{ asset($payment->receipt_document) }}" target="_blank" class="btn btn-primary">View Document</a>
        @else
            <a href="{{ asset($payment->receipt_document) }}" target="_blank">
                <img src="{{ asset($payment->receipt_document) }}" alt="Receipt Document" style="max-width: 150px;">
            </a>
        @endif
        <br>
    @endif
		<strong>Employee ID:</strong> {{ $payment->user->employee_id }} <br>
        <strong>ID:</strong> {{ $payment->id }} <br>
        <strong>User Name:</strong> {{ $payment->user->name }} <br>
        <strong>Package Name:</strong> {{ $payment->package_name }} <br>
        <strong>Payment Type:</strong> {{ $payment->payment_type }} <br>
     @if ($payment->payment_type === 'offline')
    @if ($payment->package_name === 'Annual Subscription')
        <strong>Receipt Number:</strong> {{ $payment->receipt_number }} <br>
    @else
        <strong>Cheque Number:</strong> {{ $payment->cheque_number }} <br>
        <strong>Receipt Document:</strong> {{ $payment->receipt_document }} <br>
    @endif
@endif


        @if ($payment->payment_type === 'online')
            <strong>Razorpay ID:</strong> {{ $payment->razorpay_id }} <br>
        @endif
        <strong>Payment Status:</strong> {{ $payment->payment_status }} <br>
        <strong>Amount:</strong> {{ $payment->amount }} <br>
        <strong>Date:</strong> {{ $payment->created_at }} <br>
        <!-- Add any other payment details you want to display -->
    </div>
    @if ($payment->payment_status === 'pending approval')
        <!-- Approve and Disapprove Buttons -->

        <br>


        <form action="{{ route('admin.payments.approve', $payment->id) }}" method="POST" style="display: inline;">
            @csrf
            @method('PATCH')
            <button type="submit" class="btn btn-success">Approve</button>
        </form>

        <form action="{{ route('admin.payments.disapprove', $payment->id) }}" method="POST" style="display: inline;">
            @csrf
            @method('PATCH')
            <button type="submit" class="btn btn-danger">Disapprove</button>
        </form>
    @endif



@endsection
