@extends('admin.layout.admin')
@section('title', 'Collection')
@section('content')
@section('style')
<style>
    .page-wrapper {
        display: block !important;
    }
    .member_container {
        height: 500px;
        background-color: white;
    }
</style>
@endsection
<div class="container mt-5 member_container">
    <h1>Collection</h1>
    <div class="mb-3">
        <label for="package-filter" class="form-label">Filter by Package:</label>
        <select class="form-select" id="package-filter">
            <option value="">All</option>
            <option value="annual">Annual</option>
            <option value="benevolent">Benevolent</option>
        </select>
    </div>

    <table id="payments-table" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th>Emoloyee ID</th>
                <th>User Name</th>
                <th>Package Name</th>
                <th>Payment Type</th>
                <th>Receipt Number</th>
                <th>Receipt Document</th>
                <th>Payment Status</th>
                <th>Amount</th>
                <th>Date</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($payments as $payment)
            <tr>
                <td>{{ $payment->user->employee_id }}</td>
                <td>{{ $payment->user->name }}</td>
                <td>{{ $payment->package_name }}</td>
                <td>{{ $payment->payment_type }}</td>
                <td>{{ $payment->main_receipt_id }}</td>
                <td>
                    @if (empty($payment->receipt_document))
                    {{ 'N/A' }}
                    @elseif (pathinfo($payment->receipt_document, PATHINFO_EXTENSION) === 'pdf')
                    <a href="{{ asset($payment->receipt_document) }}" target="_blank">View Document</a>
                    @else
                    <img src="{{ asset($payment->receipt_document) }}" alt="Receipt Document" style="max-width: 100px;">
                    @endif
                </td>
                <td>{{ $payment->payment_status }}</td>
                <td>{{ $payment->amount }}</td>
                <td>{{ $payment->created_at }}</td>
                <td>
                    <a href="{{ route('admin.payments.show', $payment->id) }}" class="btn btn-primary btn-sm">View</a>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>

@endsection

@push('scripts')
<script>
    $(document).ready(function () {
        var dataTable = $('#payments-table').DataTable({
            "paging": true,
            "lengthChange": false,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": false,
        });

        // Event listener for package filter dropdown
        $('#package-filter').on('change', function () {
            var packageName = $(this).val();
            var status = $('#status-filter').val();
            updateDataTableFilters(packageName, status);
        });


        function updateDataTableFilters(packageName, status) {
            dataTable.column(2).search(packageName).draw(); // Filter by Package Name
            dataTable.column(6).search(status).draw(); // Filter by Payment Status
        }
    });
</script>
@endpush
