<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBFundPaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('b_fund_payments', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('main_receipt_id', 191)->nullable()->index();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('cashier_id')->nullable()->index();
            $table->string('package_name', 191);
            $table->string('payment_type', 191)->nullable();
            $table->string('receipt_number', 191)->nullable();
            $table->string('receipt_document', 191)->nullable();
            $table->date('doc_date')->nullable();
            $table->string('cheque_number', 191)->nullable();
            $table->string('payment_status', 191)->nullable();
            $table->decimal('amount', 10, 2);
            $table->string('token', 191)->nullable();
            $table->string('razorpay_id', 191)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('b_fund_payments');
    }
}
