<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Add new column joining_office
            $table->string('joining_office')->nullable();

            // Change column types from year to date
            $table->date('joining_year')->nullable()->change();
            $table->date('retirement_year')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Revert changes by dropping columns
            $table->dropColumn('joining_office');
            $table->date('joining_year')->nullable()->change();
            $table->date('retirement_year')->nullable()->change();
        });
    }
};
