<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('fathers_name')->nullable()->after('name');
            $table->string('religion')->nullable()->after('fathers_name');
            $table->string('order_no')->nullable()->after('religion');
            $table->string('order_date')->nullable()->after('order_no');


        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
               'fathers_name',
               'religion',
               'order_no',
               'order_date'
            ]);
        });
    }
};
