<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {

        Schema::table('users', function (Blueprint $table) {
            $table->string('employee_id')->nullable()->after('id');
            $table->string('qualification')->nullable()->after('contact');
            $table->string('home_district')->nullable()->after('qualification');
            $table->string('home_mandal')->nullable()->after('home_district');
            $table->string('category')->nullable()->after('home_mandal');
            $table->year('joining_year')->nullable()->after('category');
            $table->year('retirement_year')->nullable()->after('joining_year');
            $table->string('current_office')->nullable()->after('retirement_year');
            $table->date('present_posting_joining_date')->nullable()->after('current_office');
            $table->string('batch')->nullable()->after('present_posting_joining_date');
            $table->string('current_mandal')->nullable()->after('batch');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'employee_id',
                'qualification',
                'home_district',
                'home_mandal',
                'category',
                'joining_year',
                'retirement_year',
                'current_office',
                'present_posting_joining_date',
                'batch',
                'current_mandal'
            ]);
        });
    }
};
