<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('gender')->nullable()->after('email');
            $table->string('contact')->nullable()->after('gender');
            $table->boolean('contact_privacy')->default(false);
            $table->string('bio')->nullable()->after('contact_privacy');
            $table->string('cug_no')->nullable()->after('bio');
            $table->string('designation')->nullable()->after('cug_no');
            $table->string('posting_area')->nullable()->after('designation');
            $table->string('zone')->nullable()->after('posting_area');
            $table->string('home_town')->nullable()->after('zone');
            $table->date('date_of_birth')->nullable()->after('home_town');
            $table->date('marriage_anniversary')->nullable()->after('date_of_birth');
            $table->string('state')->nullable()->after('marriage_anniversary');
            $table->string('profile_photo')->nullable()->after('state');
            $table->string('cover_image')->nullable()->after('profile_photo');
            $table->integer('annual_status')->default(0);
            $table->integer('b_fund_status')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'gender', 'contact', 'contact_privacy', 'bio', 'cug_no',  'designation', 'posting_area', 'zone',
                'home_town', 'date_of_birth', 'marriage_anniversary', 'state',
                'profile_photo', 'cover_image','annual_status', 'b_fund_status'
            ]);
        });
    }
};
