<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Support\Facades\Auth;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'contact',
        'password',
        'gender',
        'cug_no',
        'designation',
        'posting_area',
        'home_town',
        'date_of_birth',
        'marriage_anniversary',
        'state',
        'profile_photo',
        'cover_image',
        'contact_privacy',
        'annual_status',
        'b_fund_status',
        'employee_id',
        'qualification',
        'home_district',
        'home_mandal',
        'category',
        'joining_year',
        'retirement_year',
        'current_office',
        'present_posting_joining_date',
        'batch',
        'current_mandal',
        'fathers_name',
        'religion',
        'order_no',
        'order_date',
        'zone',
        'registration_status',
		 'registration_type',
		'approved_by',

    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

     /**
     * Enter your own logic (e.g. if ($this->id === 1) to
     *   enable this user to be able to add/edit blog posts
     *
     * @return bool - true = they can edit / manage blog posts,
     *        false = they have no access to the blog admin panel
     */
    public function canManageBinshopsBlogPosts()
    {
        // Enter the logic needed for your app.
        // Maybe you can just hardcode in a user id that you
        //   know is always an admin ID?

        if (Auth::check())
        {

           // return true so this user CAN edit/post/delete
           // blog posts (and post any HTML/JS)

           return true;
        }

        // otherwise return false, so they have no access
        // to the admin panel (but can still view posts)

        return false;
    }

    public function payments()
    {
        return $this->hasMany(Payment::class);
    }
    public function b_fund_payments()
    {
        return $this->hasMany(BFundPayment::class);
    }

    public function nominees()
    {
        return $this->hasMany(Nominees::class);
    }

}
