<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BFundPayment extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'cashier_id',
        'package_name',
        'amount',
        'token',
		'payment_type',
        'razorpay_id',
        'timestamp',
        'receipt_number',
        'payment_status',
        'receipt_document',
        'doc_date',
        'cheque_number',
        'main_receipt_id'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function nominees()
    {
        return $this->hasMany(Nominee::class);
    }
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->main_receipt_id = $model->generateReceiptId();
        });
    }

    // Method to generate the receipt ID
    private function generateReceiptId()
    {
        $siteName = 'UPVKSS';
        $year = date('Y');
        $nextYear = $year + 1;
        $yearString = "$year-$nextYear";

        $lastPayment = self::where('main_receipt_id', 'LIKE', "$siteName/$yearString/%")
            ->orderBy('id', 'desc')
            ->first();

        if ($lastPayment) {
            $lastNumber = (int)substr($lastPayment->main_receipt_id, -4);
            $newNumber = $lastNumber + 1;
        } else {
            $newNumber = 1;
        }

        $receiptNumber = str_pad($newNumber, 4, '0', STR_PAD_LEFT);

        return "$siteName/$yearString/$receiptNumber";
    }

    public function cashier()
    {
        return $this->belongsTo(User::class, 'cashier_id');
    }

}
