<?php

namespace App\Mail;

use App\Models\User;
use App\Models\Payment;
use App\Models\BFundPayment;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class BfundPaymentSuccess extends Mailable
{
    use Queueable, SerializesModels;

    public $user;
    public $payment;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(User $user, BfundPayment $payment)
    {
        $this->user = $user;
        $this->payment = $payment;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject('Payment Successful')
                    ->view('emails.payment_success')
                    ->with([
                        'user' => $this->user,
                        'payment' => $this->payment,
                    ]);
    }
}
