<?php

// namespace App\Imports;

// use App\Models\User;
// use Maatwebsite\Excel\Concerns\ToModel;

// class UsersImport implements ToModel
// {
//     /**
//      * @param array $row
//      * @return \Illuminate\Database\Eloquent\Model|null
//      */
//     public function model(array $row)
//     {
//         // Skip the first row (heading row)
//         if ($row[0] == 'employee_id') {
//             return null;
//         }

//         return new User([
// 			'employee_id' => $row[0],
//             'name' => $row[1],
//             'email' => $row[2],
//             'contact' => $row[3],
//             'designation' => $row[4],
// 			'current_office' => $row[5],
//             'posting_area' => $row[6],
//             'home_district' => $row[7],
//             'date_of_birth' => is_numeric($row[8]) ? \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($row[8])->format('Y-m-d') : null,
//              'batch' => $row[9],
//             'password' => bcrypt('Pass@123#'), // You can set a default Pass@123# here
// 			'registration_status' => '1',
//             'registration_type' => '1',
//         ]);
//     }
// }



namespace App\Imports;

use App\Models\User;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithStartRow;
use PhpOffice\PhpSpreadsheet\Shared\Date;

class UsersImport implements ToModel, WithStartRow
{
    private $rowsProcessed = 0;

    /**
     * Start row for the import.
     *
     * @return int
     */
    public function startRow(): int
    {
        return 2; // Assuming your data starts from the second row (0-based index)
    }

    /**
     * @param array $row
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {
        // Increment processed row count
        $this->rowsProcessed++;
        // Find user by employee_id
        $user = User::where('employee_id', $row[0])->first();
        // If user exists, update date_of_birth
        if ($user) {
            $user->date_of_birth = is_numeric($row[7]) ? Date::excelToDateTimeObject($row[7])->format('Y-m-d') : null;
            $user->save();
        }
        return null;

    }

    /**
     * Get the number of rows processed.
     *
     * @return int
     */
    public function getRowsProcessed(): int
    {
        return $this->rowsProcessed;
    }
}
