<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class RedirectIfRegistrationTypeIsOne
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next)
    {
        // Check if the user is authenticated and if registration_type is '1'
        if (Auth::check()) {
            if (Auth::user()->registration_type === '1') {
                // Allow access only to the password_check route
                if ($request->route()->getName() !== 'password_check') {
                    // Redirect to password_check route if trying to access any other route
                    return redirect()->route('password_check');
                }
            } else {
                // Prevent users with updated passwords from accessing password_check
                if ($request->route()->getName() === 'password_check') {
                    return redirect()->route('home'); // Redirect to home or any other page
                }
            }
        }

        // Proceed with the request
        return $next($request);
    }
}
