<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;

class RedirectIfNotAdmin
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (Auth::check() && Auth::user()->role === 'admin') {
            return $next($request);
        }

        if (Auth::check() && Auth::user()->role === 'sub-admin') {
            return redirect()->route('subadmin.home');
        }

        if(Auth::user()->role === 'employee' && auth()->user()->registration_type == '1' ) {
                // Redirect to desired route
                return redirect()->route('password_check');
            }
        return redirect('/home');

    }
}
