<?php

namespace App\Http\Controllers;

use App\Mail\AdminApprovedAccount;
use App\Mail\BfundPaymentSuccess;
use Illuminate\Http\Request;
use App\Models\Payment;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Hash;
use App\Models\BFundPayment;

use App\Mail\PaymentSuccess;
class SubAdminController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        $users = User::all();
        $today = Carbon::today();
        $usersJoinedTodayCount = User::whereDate('created_at', $today)->count();

        return view('sub-admin.dashboard', [
            'user' => $user,
            'users' => $users,
            'usersJoinedTodayCount' => $usersJoinedTodayCount
        ]);
    }

    public function edit()
    {

        return view('sub-admin.edit', []);
    }
    public function updatePassword(Request $request)
{
    $request->validate([
        'password' => 'required|string|min:8',
        'password_confirmation' => 'same:password'
    ]);

    $user = Auth::user();
    $user->password = Hash::make($request->password);
    $user->save();

    return redirect()->route('subadmin.home')->with('success', 'Password successfully updated');
}
    public function membership()
    {
        $payments = Payment::with('user')->get();

        return view('sub-admin.membership', compact('payments'));
    }

    public function annual()
    {
        $payments = BFundPayment::with('user')->get();

        return view('sub-admin.annual_membership', compact('payments'));
    }

    public function submitOfflineSubscription(Request $request)
    {
        // Retrieve user by employee ID
        $user = User::where('employee_id', $request->employee_id)->first();
        $employeeId = $request->employee_id;
        if ($user) {
            // Retrieve the first payment with the package name 'Annual Subscription'
            $payment = $user->payments()->where('package_name', 'Annual Subscription')->first();

            if ($payment) {
                // Update payment details
                $payment->cashier_id = auth()->user()->id;
                $payment->payment_status = "success";
                $payment->save(); // Call save as a function

                // Update user's b_fund_status
                $user->annual_status = 1;
                $user->save(); // Call save as a function

                return redirect()->route('sub.membership')->with([
                    'success' => 'Subscription submitted and updated successfully!',
                    'employee_id' => $employeeId,
                ]);
            } else {
                // Handle case where payment is not found
                return response()->json(['error' => 'Payment not found'], 404);
            }
        } else {
            // Handle case where user is not found
            return response()->json(['error' => 'User not found'], 404);
        }
    }


    public function view_receipt(Request $request)
    {

        $employeeId = $request->input('employee_id');
        $user = User::where('employee_id', $employeeId)->first();
        $details = Payment::where('package_name', 'Annual Subscription')
            ->where('user_id', $user->id)
            ->where('payment_status', 'success')
            ->with('cashier') // Eager load the cashier relationship
            ->first();

        $cashierName = $details && $details->cashier ? $details->cashier->name : 'No cashier assigned';
        return view('sub-admin.receipt', compact('details', 'cashierName'));
    }

    public function view_receiptbfund(Request $request)
    {

        $employeeId = $request->input('employee_id');
        $user = User::where('employee_id', $employeeId)->first();
        $details = BFundPayment::where('user_id', $user->id)
            ->where('payment_status', 'success')
            ->with('cashier') // Eager load the cashier relationship
            ->first();

        $cashierName = $details && $details->cashier ? $details->cashier->name : 'No cashier assigned';
        return view('sub-admin.receipt_bfund', compact('details', 'cashierName'));
    }

    public function reports()
    {
        $userId = auth()->user()->id;

        // Retrieve successful payments for both models
        $paymentsA = Payment::where('cashier_id', $userId)
            ->where('payment_status', 'success')
            ->get();

        $paymentsB = BFundPayment::where('cashier_id', $userId)
            ->where('payment_status', 'success')
            ->get();

        // Combine the collections
        $payments = $paymentsA->concat($paymentsB);

        // Calculate the total amount for both types of payments
        $totalA = $paymentsA->sum('amount');
        $totalB = $paymentsB->sum('amount');
        $total = $totalA + $totalB;

        return view('sub-admin.reports', compact('payments', 'total'));
    }


    public function approve($id)
    {
        $payment = Payment::findOrFail($id);
        $payment->update([
            'payment_status' => 'success',
            'cashier_id' => auth()->user()->id
        ]);
        $user = $payment->user;

        if ($payment->package_name === 'Annual Subscription') {
            $user->update(['annual_status' => 1]);
        } else {
            $user->update(['b_fund_status' => 1]);
        }

        return redirect()->back()->with('success', 'Payment approved successfully.');
    }

    public function bfundapprove($id)
    {
        $payment = BfundPayment::findOrFail($id);
        $payment->update([
            'payment_status' => 'success',
            'cashier_id' => auth()->user()->id
        ]);
        $user = $payment->user;

        if ($payment->package_name === 'Annual Subscription') {
            $user->update(['annual_status' => 1]);
        } else {
            $user->update(['b_fund_status' => 1]);
        }

        return redirect()->back()->with('success', 'Payment approved successfully.');
    }

    public function show($id)
    {
        $payment = Payment::findOrFail($id);
        $payment->is_doc = (strtolower(pathinfo($payment->receipt_document, PATHINFO_EXTENSION)) === 'pdf') ? 1 : 0;

        return view('sub-admin.payment_show', compact('payment'));
    }

    public function b_show($id)
    {
        $payment = BfundPayment::findOrFail($id);
        $payment->is_doc = (strtolower(pathinfo($payment->receipt_document, PATHINFO_EXTENSION)) === 'pdf') ? 1 : 0;

        return view('sub-admin.payment_show', compact('payment'));
    }

    public function payments_history()
    {
        $userId = auth()->user()->id;

        $paymentsAnnual = Payment::with('user')
        ->where('cashier_id', $userId)
        ->get();

    $paymentsBfund = BFundPayment::with('user')
        ->where('cashier_id', $userId)
        ->get();

    // Combine collections
    $combinedPayments = $paymentsAnnual->concat($paymentsBfund);

    // Sort by created_at in descending order
    $payments = $combinedPayments->sortByDesc('created_at')->values();

        return view('sub-admin.payments_history', compact('payments'));
    }

    public function list()
    {
        $users = User::all();
        return view('sub-admin.list', compact('users'));
    }

    public function approvals()
    {
        $users = User::where('registration_status', '2')->get();

        return view('sub-admin.approvals', compact('users'));
    }
    public function account_approve($id)
    {
        $user = User::findOrFail($id);
        $user->update([
            'registration_status' => '1',
            'approved_by' => auth()->user()->id
        ]);

        Mail::to($user->email)->send(new AdminApprovedAccount($user));
        return redirect()->back()->with('success', 'Account approved successfully.');
    }

    public function history()
    {
        $users = User::where('approved_by', auth()->user()->id)->get();
        return view('sub-admin.history', compact('users'));
    }

    public function downloadAsImage(Request $request)
    {
        $employeeId = $request->input('employee_id');
        $details = Payment::where('package_name', 'Benevolent Fund')
            ->where('user_id', $employeeId)
            ->where('payment_status', 'success')
            ->with('cashier') // Eager load the cashier relationship
            ->first();
        if (!$details) {
            abort(404); // Or handle the case where payment details are not found
        }

        $cashierName = $details->cashier ? $details->cashier->name : 'No cashier assigned';

        // Render the receipt view to HTML
        $html = view('sub-admin.receipt', compact('details', 'cashierName'))->render();

        // Set headers for download
        $headers = [
            'Content-Type' => 'image/png',
            'Content-Disposition' => 'attachment; filename="receipt.png"'
        ];

        // Use dom-to-image library to convert HTML to image
        $imageData = \Image::make($html)->encode('png', 100);

        // Return response with image data
        return response()->streamDownload(function () use ($imageData) {
            echo $imageData;
        }, 'receipt.png');
    }

    public function submitOfflineSubscriptionsub(Request $request)
    {
        // Retrieve user by employee ID
        $user = User::where('employee_id', $request->employee_id)->first();
        if ($user) {
            $payment = Payment::create([
                'user_id' => $user->id,
                'package_name' => 'Annual Subscription',
                'amount' => 2000,
                'payment_type' => "offline",
                'payment_status' => "success",
                'cashier_id' => auth()->user()->id
            ]);

            $user->annual_status = 1;
            $user->save(); // Call save as a function

            Mail::to($user->email)->send(new PaymentSuccess($user, $payment));


            $employeeId = $request->input('employee_id');
            $details = Payment::where('package_name', 'Annual Subscription')
                ->where('user_id', $user->id)
                ->where('payment_status', 'success')
                ->with('cashier') // Eager load the cashier relationship
                ->first();

            $cashierName = $details && $details->cashier ? $details->cashier->name : 'No cashier assigned';
            return view('sub-admin.receipt', compact('details', 'cashierName'));
        } else {
            // Handle case where user is not found
            return response()->json(['error' => 'User not found'], 404);
        }
    }

    public function submitOfflineSubscriptionsub_bfund(Request $request)
    {
        // Retrieve user by employee ID
        $user = User::where('employee_id', $request->employee_id)->first();
        if ($user) {
            $payment = BFundPayment::create([
                'user_id' => $user->id,
                'package_name' => 'Benevolent Fund',
                'amount' => 20000,
                'payment_type' => "offline",
                'payment_status' => "success",
                'cashier_id' => auth()->user()->id
            ]);

            $user->b_fund_status = 1;
            $user->save(); // Call save as a function

            Mail::to($user->email)->send(new BfundPaymentSuccess($user, $payment));


            $employeeId = $request->input('employee_id');
            $details = BFundPayment::where('user_id', $user->id)
                ->where('payment_status', 'success')
                ->with('cashier') // Eager load the cashier relationship
                ->first();

            $cashierName = $details && $details->cashier ? $details->cashier->name : 'No cashier assigned';
            return view('sub-admin.receipt', compact('details', 'cashierName'));
        } else {
            // Handle case where user is not found
            return response()->json(['error' => 'User not found'], 404);
        }
    }


    public function payments_index()
    {
        $payments = Payment::with('user')->get();
        $bFundPayments = BFundPayment::with('user')->get();

        // Combine the collections
        $allPayments = $payments->concat($bFundPayments);

        // Optionally, sort the combined collection by created_at or any other attribute
        $payments = $allPayments->sortByDesc('created_at')->values();


        return view('sub-admin.payments', compact('payments'));
    }

    public function disapprove($id)
    {
        $payment = Payment::findOrFail($id);
        $payment->update(['payment_status' => 'failed', 'cashier_id' => auth()->user()->id]);
        $user = $payment->user;
        if ($payment->package_name === 'Annual Subscription') {
            $user->update(['annual_status' => 3]);
        } else {
            $user->update(['b_fund_status' => 3]);
        }

        return redirect()->back()->with('success', 'Payment disapproved successfully.');
    }
    public function bfunddisapprove($id)
    {
        $payment = BfundPayment::findOrFail($id);
        $payment->update(['payment_status' => 'failed', 'cashier_id' => auth()->user()->id]);
        $user = $payment->user;
        if ($payment->package_name === 'Annual Subscription') {
            $user->update(['annual_status' => 3]);
        } else {
            $user->update(['b_fund_status' => 3]);
        }

        return redirect()->back()->with('success', 'Payment disapproved successfully.');
    }

}
