<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use PhpOffice\PhpSpreadsheet\Calculation\Financial\CashFlow\Constant\Periodic\Payments;
use Razorpay\Api\Api;
use App\Models\Payment;
use App\Models\User;
use Illuminate\Support\Facades\Mail;
use App\Mail\PaymentSuccess;
use App\Models\BFundPayment;

class PaymentController extends Controller
{

    public function payment()
    {
        $api = new Api(env('RAZOR_KEY'), env('RAZOR_SECRET'));
        $order = $api->order->create(
            array(
                'receipt' => '123',
                'amount' => 100 * 100, // amount in the smallest currency unit
                'currency' => 'INR'
            )
        );
        $orderId = $order['id'];
        return view('payment', compact('orderId'));
    }

    public function paymentResponse(Request $request)
    {
        $user = auth()->user();
        $user_id = $user->id;
        $email = $user->email;
        if ($request->type === 'Benevolent Fund') {
            $user->b_fund_status = true;
            $package_name = "Benevolent Fund";
            $amount = "20000";
            $payment = BFundPayment::create([
                'user_id' => $user_id,
                'package_name' => $package_name,
                'amount' => $amount,
                'payment_type' => "online",
                'payment_status' => "success",
                'token' => $request->_token,
                'razorpay_id' => $request->razorpay_payment_id,
            ]);
        } else {
            $user->annual_status = true;
            $package_name = "Annual Subscription";
            $amount = "2000";
            $payment = Payment::create([
                'user_id' => $user_id,
                'package_name' => $package_name,
                'amount' => $amount,
                'payment_type' => "online",
                'payment_status' => "success",
                'token' => $request->_token,
                'razorpay_id' => $request->razorpay_payment_id,
            ]);
        }




        $user->save();
        Mail::to($user->email)->send(new PaymentSuccess($user, $payment));


        return back()->with('success', 'Payment successful.');
    }

    public function updatePaymentStatus(Request $request)
    {
        $type = $request->query('type');

        if ($type === 'annual') {
            // Update annual_status in the user table to 0
            auth()->user()->update(['annual_status' => 0]);
        } elseif ($type === 'benevolent') {
            // Update b_fund_status in the user table to 0
            auth()->user()->update(['b_fund_status' => 0]);
        }

        // Redirect the user to a relevant page after updating
        return redirect()->back()->with('success', 'Payment status updated successfully.');
    }
}
