<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class InvoiceController extends Controller
{
    public function download($type)
    {
        // Check if the user is authenticated
        if (!auth()->check()) {
            return redirect()->route('login')->with('error', 'You need to login to download the invoice.');
        }

        // Get the authenticated user
        $user = auth()->user();

        // Check if the user has paid for the specified type
        if ($type == 'Annual Subscription' && !$user->annual_status) {
            return redirect()->back()->with('error', 'You haven\'t paid for the Annual Membership.');
        } elseif ($type == 'Benevolent Fund' && !$user->b_fund_status) {
            return redirect()->back()->with('error', 'You haven\'t paid for the Benevolent Fund.');
        }

        // Generate invoice PDF
        $pdf = PDF::loadView('pdf.invoice', ['user' => $user, 'type' => $type]);

        // Download the invoice PDF
        return $pdf->download('invoice_' . $type . '_' . $user->id . '.pdf');
    }
}
