<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Payment;
use Carbon\Carbon;
use BinshopsBlog\Laravel\Fulltext\Search;
use BinshopsBlog\Models\BinshopsCategoryTranslation;
use BinshopsBlog\Captcha\UsesCaptcha;
use BinshopsBlog\Middleware\DetectLanguage;
use BinshopsBlog\Models\BinshopsCategory;
use BinshopsBlog\Models\BinshopsLanguage;
use BinshopsBlog\Models\BinshopsPost;
use BinshopsBlog\Models\BinshopsPostTranslation;
use App\Models\User;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $user = $currentUser = auth()->user();

        if ($user->role === 'admin') {
            return redirect('/admin/home');
        }
        if ($user->role === 'sub-admin') {
            return redirect('/subadmin/home');
        }

        $annual_status = '';
        $remainingDays = '';
        $bFundStatus = $user->b_fund_status;
        $annualStatus = $user->annual_status;
        $currentDate = Carbon::today()->toDateString();
        $currentMonth = date('m');
        $currentDay = date('d');
		$currentYear = date('Y');


      $birthdays = User::whereDate('date_of_birth', '=', $currentDate)
    ->take(4)
    ->get();
       $anniversaries = User::whereYear('retirement_year', $currentYear)
    ->whereMonth('retirement_year', $currentMonth)
    ->whereDay('retirement_year', '>=', $currentDay)
    ->take(4)
    ->get();
        if ($user->annual_status !== 0) {
            $lastPayment = Payment::where('user_id', $user->id)
                ->latest()
                ->first();
            if ($lastPayment) {
                $paymentDate = $lastPayment->created_at->addYear();
                $remainingDays = now()->diffInDays($paymentDate);
            }
        }

        $coverImage = $user->cover_image ? asset('user/cover_image/' . $user->cover_image) : asset('default-cover.jpg');
        $remainingDays = $annualStatus ? $remainingDays : null;

        $posts = array();
        $posts = BinshopsPostTranslation::join('binshops_posts', 'binshops_post_translations.post_id', '=', 'binshops_posts.id')
            ->where("is_published", '=', true)
            ->where('posted_at', '<', Carbon::now()->format('Y-m-d H:i:s'))
            ->orderBy("posted_at", "desc")
            ->paginate(config("binshopsblog.per_page", 10));
        foreach ($posts as $post) {
            $post->image_url = $this->extractImageUrl($post);

            // Fetch user data based on user_id
            $user = User::find($post->user_id);

            // Add user data to the post object
            $post->user = $user;
        }

        return view('user.dashboard', compact('annualStatus', 'remainingDays', 'bFundStatus', 'coverImage', 'currentUser', 'posts','birthdays','anniversaries'));
    }

    private function extractImageUrl($post)
    {
        // Generate the HTML for the image tag
        $image_html = $post->image_tag("large", true, '');

        // Initialize the image URL variable
        $image_url = '';

        if (!empty($image_html)) {
            // Load the HTML into DOMDocument
            $doc = new \DOMDocument();
            libxml_use_internal_errors(true); // To suppress warnings due to malformed HTML
            $doc->loadHTML($image_html);
            libxml_clear_errors();

            // Extract the image URL from the DOM
            $img_tags = $doc->getElementsByTagName('img');
            if ($img_tags->length > 0) {
                $image_url = $img_tags->item(0)->getAttribute('src');
            }
        }

        return $image_url;
    }

    public function index2()
    {
        $user = $currentUser = auth()->user();

        if ($user->email === 'admin@gmail.com') {
            return redirect('/admin/dashboard');
        }

        $annual_status = '';
        $remainingDays = '';
        $b_fund_status = $user->b_fund_status;

        if ($user->annual_status !== 0) {
            $annual_status = "paid";
            $lastPayment = Payment::where('user_id', $user->id)
                ->latest()
                ->first();
            if ($lastPayment) {
                $paymentDate = $lastPayment->created_at->addYear();
                $remainingDays = now()->diffInDays($paymentDate);
            }
        }

        $coverImage = $user->cover_image ? asset('user/cover_image/' . $user->cover_image) : asset('default-cover.jpg');
        $annualStatus = !empty($annual_status);
        $bFundStatus = !empty($b_fund_status);
        $remainingDays = $annualStatus ? $remainingDays : null;

        return view('user.dashboard2', compact('annualStatus', 'remainingDays', 'bFundStatus', 'coverImage', 'currentUser'));
    }

    public function registration_status()
    {
        Auth::logout();
        return redirect()->route('register')->with('status', 'Your registration detail has been submitted successfully, now it is pending for approval. Please Login once it is approved or you may try login attempt after 24 hours.');
    }

    public function password_check()
    {
        return view('password_check');
    }

	 public function getEmailByUserId(Request $request)
    {
        $userId = $request->query('user_id');
        $user = User::find($userId);

        if ($user) {
            return response()->json(['email' => $user->email]);
        } else {
            return response()->json(['error' => 'User not found'], 404);
        }
    }
}
