<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LoginController extends Controller
{
    use AuthenticatesUsers;

    protected $redirectTo = '/home';

    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    /**
     * Get the login username to be used by the controller.
     *
     * @return string
     */
    public function username()
    {
        return 'employee_id';
    }

    /**
     * Validate the user login request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return void
     */
    protected function validateLogin(Request $request)
    {
        $request->validate([
            'employee_id' => 'required|string',
            'password' => 'required|string',
        ]);
    }

    protected function authenticated(Request $request, $user)
    {


        if ($user->role === 'admin') {
            return redirect('/admin/home');
        }
        if ($user->role === 'sub-admin') {
            return redirect('/subadmin/home');
        }
        // if user registeration is active(1)
        if ($user->registration_status == '1') {
            // if employee is registere(1)
            if ($user->role === 'employee' && $user->registration_type === '1') {
                return redirect('/password_check');
            }

            return redirect('/dashboard');
        } else {
            // If the user is not active, log them out and redirect to the error view
            Auth::logout();
            return redirect()->route('login')->with('message', 'User is not active.');
        }
    }
    public function logout(Request $request)
    {
        $this->guard()->logout();

        $request->session()->invalidate();

        $request->session()->regenerateToken();

        return redirect('/login');
    }
}
