<?php

namespace App\Http\Controllers;

use App\Mail\AdminApprovedAccount;
use Illuminate\Http\Request;
use App\Models\Payment;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Mail;

class AdminController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        $users = User::all();
        $today = Carbon::today();
        $usersJoinedTodayCount = User::whereDate('created_at', $today)->count();

        return view('admin.dashboard', [
            'user' => $user,
            'users' => $users,
            'usersJoinedTodayCount' => $usersJoinedTodayCount
        ]);
    }

    public function payments_index()
    {
        $payments = Payment::with('user')->get();

        return view('admin.payments', compact('payments'));
    }

    public function approvals()
    {
        $payments = Payment::with('user')
            ->where('payment_status', 'pending approval')
            ->get();

        return view('admin.approvals', compact('payments'));
    }
    public function show($id)
    {
        $payment = Payment::findOrFail($id);
        $payment->is_doc = (strtolower(pathinfo($payment->receipt_document, PATHINFO_EXTENSION)) === 'pdf') ? 1 : 0;

        return view('admin.payment_show', compact('payment'));
    }

    public function approve($id)
    {
        $payment = Payment::findOrFail($id);
        $payment->update(['payment_status' => 'success']);
        $user = $payment->user;

        if ($payment->package_name === 'Annual Subscription') {
            $user->update(['annual_status' => 1]);
        } else {
            $user->update(['b_fund_status' => 1]);
        }

        return redirect()->back()->with('success', 'Payment approved successfully.');
    }

    public function disapprove($id)
    {
        $payment = Payment::findOrFail($id);
        $payment->update(['payment_status' => 'failed']);
        $user = $payment->user;
        if ($payment->package_name === 'Annual Subscription') {
            $user->update(['annual_status' => 3]);
        } else {
            $user->update(['b_fund_status' => 3]);
        }

        return redirect()->back()->with('success', 'Payment disapproved successfully.');
    }

    public function collection()
    {
        $payments = Payment::with('user')
            ->where('payment_status', 'success')
            ->get();

        return view('admin.collection', compact('payments'));
    }

    public function membership()
    {
        $payments = Payment::with('user')->get();

        return view('admin.membership', compact('payments'));
    }

    public function account_approval()
    {

        $users = User::where('registration_status', '2')->get();
        return view('admin.user_approvals', [
            'users' => $users,
        ]);
    }
    public function account_approve($id)
    {

        $user = User::findOrFail($id);
        $user->update(['registration_status' => '1']);

        Mail::to($user->email)->send(new AdminApprovedAccount($user));


        return redirect()->back()->with('success', 'Account approved successfully.');
    }

    public function submitOfflineSubscription(Request $request)
    {
        $user = User::where('employee_id', $request->employee_id)->first();
        // Handle file upload
        if ($request->hasFile('receipt_document')) {
            $file = $request->file('receipt_document');
            $destinationPath = 'receipts';
            $filename = time() . '_' . $file->getClientOriginalName();
            $file->move(public_path($destinationPath), $filename);
            $receiptDocumentPath = $destinationPath . '/' . $filename;
        }

        Payment::create([
            'user_id' => $user->id,
            'package_name' => 'Benevolent Fund',
            'amount' => "20000",
            'cashier_id'=> auth()->user()->id,
            'payment_type' => "offline",
            'doc_date' => $request->doc_date,
            'cheque_number' => $request->cheque_number,
            'receipt_document' => $receiptDocumentPath ?? null,
            'payment_status' => 'success',
        ]);
        $user->b_fund_status = 1;
        $user->save();
        return redirect()->route('membership')->with('success', 'Subscription submitted and updated successfully!');
    }
}
